/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.Msa;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class BasicMsa
implements Msa {
    private final char[][] _data;
    private final String[] _identifiers;
    private final Set<String> _identifiers_set;
    private final MolecularSequence.TYPE _type;

    public BasicMsa(int n, int n2, MolecularSequence.TYPE tYPE) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("basic msa of size zero are illegal");
        }
        this._data = new char[n][n2];
        this._identifiers = new String[n];
        this._identifiers_set = new HashSet<String>();
        this._type = tYPE;
    }

    BasicMsa(BasicMsa basicMsa) {
        this._data = basicMsa._data;
        this._identifiers = basicMsa._identifiers;
        this._type = basicMsa._type;
        this._identifiers_set = basicMsa._identifiers_set;
    }

    @Override
    public List<MolecularSequence> asSequenceList() {
        ArrayList<MolecularSequence> arrayList = new ArrayList<MolecularSequence>();
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            arrayList.add(this.getSequence(i));
        }
        return arrayList;
    }

    @Override
    public List<Character> getColumnAt(int n) {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            arrayList.add(Character.valueOf(this.getResidueAt(i, n)));
        }
        return arrayList;
    }

    @Override
    public String getIdentifier(int n) {
        return this._identifiers[n];
    }

    @Override
    public int getLength() {
        return this._data[0].length;
    }

    @Override
    public int getNumberOfSequences() {
        return this._identifiers.length;
    }

    @Override
    public char getResidueAt(int n, int n2) {
        return this._data[n][n2];
    }

    @Override
    public MolecularSequence getSequence(int n) {
        return new BasicSequence(this.getIdentifier(n), this._data[n], this.getType());
    }

    @Override
    public MolecularSequence getSequence(String string) {
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            if (!this.getIdentifier(i).equals(string)) continue;
            return this.getSequence(i);
        }
        return null;
    }

    @Override
    public StringBuffer getSequenceAsString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            stringBuffer.append(this.getResidueAt(n, i));
        }
        return stringBuffer;
    }

    @Override
    public MolecularSequence.TYPE getType() {
        return this._type;
    }

    @Override
    public boolean isGapAt(int n, int n2) {
        return this.getResidueAt(n, n2) == '-';
    }

    @Override
    public void setIdentifier(int n, String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("illegal attempt to create msa with empty identifier");
        }
        if (this._identifiers_set.contains(string)) {
            throw new IllegalArgumentException("illegal attempt to create msa with non-unique identifiers [" + string + "]");
        }
        this._identifiers_set.add(string);
        this._identifiers[n] = string;
    }

    @Override
    public void setResidueAt(int n, int n2, char c) {
        this._data[n][n2] = c;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.write(stringWriter, Msa.MSA_FORMAT.PHYLIP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ((Object)stringWriter).toString();
    }

    @Override
    public void write(Writer writer, Msa.MSA_FORMAT mSA_FORMAT) throws IOException {
        switch (mSA_FORMAT) {
            case PHYLIP: {
                this.writeToPhylip(writer);
                break;
            }
            case FASTA: {
                this.writeToFasta(writer);
                break;
            }
            case NEXUS: {
                this.writeToNexus(writer);
                break;
            }
            default: {
                throw new RuntimeException("unknown format " + (Object)((Object)mSA_FORMAT));
            }
        }
    }

    private short determineMaxIdLength() {
        short s = 0;
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            short s2 = (short)this.getIdentifier(i).length();
            if (s2 <= s) continue;
            s = s2;
        }
        return s;
    }

    private void writeToFasta(Writer writer) throws IOException {
        SequenceWriter.writeSeqs(this.asSequenceList(), writer, SequenceWriter.SEQ_FORMAT.FASTA, 100);
    }

    private void writeToNexus(Writer writer) throws IOException {
        int n = this.determineMaxIdLength() + 1;
        MolecularSequence.TYPE tYPE = null;
        for (int i = 0; i < this.getNumberOfSequences() && (tYPE = ForesterUtil.guessMolecularSequenceType(this.getSequence(i).getMolecularSequenceAsString())) == null; ++i) {
        }
        String string = "Protein";
        if (tYPE != null) {
            if (tYPE == MolecularSequence.TYPE.DNA) {
                string = "DNA";
            } else if (tYPE == MolecularSequence.TYPE.RNA) {
                string = "RNA";
            } else if (tYPE == MolecularSequence.TYPE.GENERAL) {
                string = "Standard";
            }
        }
        writer.write("Begin Data;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("   Dimensions NTax=" + this.getNumberOfSequences());
        writer.write(" NChar=" + this.getLength());
        writer.write(";");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("   Format DataType=" + string + " Interleave=No gap=-;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("   Matrix");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            MolecularSequence molecularSequence = this.getSequence(i);
            String string2 = molecularSequence.getMolecularSequenceAsString();
            writer.write("      ");
            writer.write(ForesterUtil.pad(this.getIdentifier(i).replace(' ', '_'), n, ' ', false).toString());
            writer.write(" ");
            writer.write(string2);
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        writer.write("   ;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("End;");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private void writeToPhylip(Writer writer) throws IOException {
        int n = this.determineMaxIdLength() + 1;
        writer.write(this.getNumberOfSequences() + " " + this.getLength());
        writer.write(ForesterUtil.LINE_SEPARATOR);
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            writer.write(ForesterUtil.pad(this.getIdentifier(i).replace(' ', '_'), n, ' ', false).toString());
            for (int j = 0; j < this.getLength(); ++j) {
                writer.write(this.getResidueAt(i, j));
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    public static Msa createInstance(List<MolecularSequence> list) {
        if (list.size() < 1) {
            throw new IllegalArgumentException("cannot create msa from less than one sequence");
        }
        int n = list.get(0).getLength();
        BasicMsa basicMsa = new BasicMsa(list.size(), n, list.get(0).getType());
        for (int i = 0; i < list.size(); ++i) {
            MolecularSequence molecularSequence = list.get(i);
            if (molecularSequence.getLength() != n) {
                throw new IllegalArgumentException("illegal attempt to build msa from sequences of unequal length [" + molecularSequence.getIdentifier() + "]");
            }
            if (molecularSequence.getType() != basicMsa.getType()) {
                throw new IllegalArgumentException("illegal attempt to build msa from sequences of different type [" + molecularSequence.getIdentifier() + "]");
            }
            basicMsa.setIdentifier(i, molecularSequence.getIdentifier());
            for (int j = 0; j < n; ++j) {
                basicMsa._data[i][j] = molecularSequence.getResidueAt(j);
            }
        }
        return basicMsa;
    }
}

