/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.msa.Msa;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.tools.MutationInference;
import org.forester.util.ForesterUtil;

public class m_label {
    private static final String PROPERTY_REF = "aptx:branch_event";
    private static final String PRG_NAME = "m_label";

    public static void main(String[] stringArray) {
        Object object;
        File file;
        File file2;
        File file3;
        if (stringArray.length < 2 || stringArray.length > 3) {
            System.out.println("\nWrong number of arguments.\n");
            System.exit(-1);
        }
        if (!(file3 = new File(stringArray[0])).exists()) {
            ForesterUtil.fatalError(PRG_NAME, "[" + file3 + "] does not exist");
        }
        if (stringArray.length > 2) {
            file2 = new File(stringArray[1]);
            file = new File(stringArray[2]);
            if (!file3.exists()) {
                ForesterUtil.fatalError(PRG_NAME, "[" + file2 + "] does not exist");
            }
        } else {
            file2 = null;
            file = new File(stringArray[1]);
        }
        if (file.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "[" + file + "] already exists");
        }
        Msa msa = null;
        if (file2 != null) {
            try {
                msa = FastaParser.parseMsa(file2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        Phylogeny phylogeny = null;
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file3, true);
            phylogeny = object.create(file3, phylogenyParser)[0];
        }
        catch (Exception exception) {
            System.out.println("\nCould not read \"" + file3 + "\" [" + exception.getMessage() + "]\n");
            System.exit(-1);
        }
        if (msa != null) {
            MutationInference.addMolSeqs(msa, phylogeny);
        }
        MutationInference.inferBranchEvents(phylogeny, PROPERTY_REF);
        try {
            object = new PhylogenyWriter();
            ((PhylogenyWriter)object).toPhyloXML(phylogeny, 0, file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + file + "]: " + iOException.getMessage());
        }
        System.out.println("[m_label] wrote: [" + file + "]");
        System.out.println("[m_label] OK");
        System.out.println();
    }
}

