/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;

public class decoratorX {
    private static final int SEQ_NAME_COLUMN = 1;
    private static final int SPECIES_COLUMN = 2;
    private static final int SEQ_COLUMN = 3;
    private static final int TARGET_COLUMN = 4;

    public static void main(String[] stringArray) {
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        try {
            Object object;
            Object object2;
            CommandLineArguments commandLineArguments = null;
            commandLineArguments = new CommandLineArguments(stringArray);
            file = commandLineArguments.getFile(0);
            file4 = commandLineArguments.getFile(1);
            file2 = commandLineArguments.getFile(2);
            file3 = commandLineArguments.getFile(3);
            if (file2.exists()) {
                System.out.println(file2 + " already exists");
                System.exit(-1);
            }
            if (file3.exists()) {
                System.out.println(file3 + " already exists");
                System.exit(-1);
            }
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhyloXmlParser phyloXmlParser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
            Phylogeny phylogeny = phylogenyFactory.create(file, phyloXmlParser)[0];
            BasicTable<String> basicTable = BasicTableParser.parse(file4, '\t');
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
            int n = 0;
            while (phylogenyNodeIterator.hasNext()) {
                object2 = phylogenyNodeIterator.next();
                decoratorX.processNode((PhylogenyNode)object2, basicTable);
                ++n;
            }
            object2 = new PhylogenyWriter();
            ((PhylogenyWriter)object2).toPhyloXML(file2, phylogeny, 0);
            PhylogenyNodeIterator phylogenyNodeIterator2 = phylogeny.iteratorExternalForward();
            while (phylogenyNodeIterator2.hasNext()) {
                object = phylogenyNodeIterator2.next();
                decoratorX.processNode2((PhylogenyNode)object, phylogeny);
            }
            object = new PhylogenyWriter();
            ((PhylogenyWriter)object).toPhyloXML(file3, phylogeny, 0);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            System.exit(-1);
        }
    }

    private static void processNode(PhylogenyNode phylogenyNode, BasicTable<String> basicTable) throws Exception {
        String string = phylogenyNode.getNodeData().getSequence().getMolecularSequence().toUpperCase();
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (int i = 0; i < basicTable.getNumberOfRows(); ++i) {
            String string5 = basicTable.getValueAsString(3, i).toUpperCase();
            if (!string5.contains(string)) continue;
            if (bl) {
                if (!string3.equals(basicTable.getValueAsString(1, i)) || !string4.equals(basicTable.getValueAsString(2, i))) {
                    throw new Exception("Sequence from node " + phylogenyNode + " is not unique: " + string + "\nAlready found in row " + string2);
                }
            } else {
                bl = true;
                string2 = basicTable.getRowAsString(i, ", ");
                string3 = basicTable.getValueAsString(1, i);
                string4 = basicTable.getValueAsString(2, i);
            }
            Annotation annotation = new Annotation("target", basicTable.getValueAsString(4, i));
            phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
            System.out.println(phylogenyNode + "->" + annotation);
        }
    }

    private static void processNode2(PhylogenyNode phylogenyNode, Phylogeny phylogeny) {
        if (phylogenyNode.getNodeData().getSequence().getAnnotations() == null || phylogenyNode.getNodeData().getSequence().getAnnotations().isEmpty()) {
            phylogeny.deleteSubtree(phylogenyNode, true);
        }
    }
}

