/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class PlotChartRenderer
extends AbstractChartRenderer {
    protected double shapeSize = 10.0;

    public PlotChartRenderer(CoordSystem cs, ChartDataModel model) {
        super(cs, model);
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        ChartDataModel m = this.getChartDataModel();
        RowColorModel rcm = this.getRowColorModel();
        AffineTransform yaxis1 = this.getTransform(0);
        int datasetcount = m.getDataSetNumber();
        Point2D.Float paint = new Point2D.Float(0.0f, 0.0f);
        boolean numericalcolumns = m.isColumnNumeric();
        float modelVal = 0.0f;
        int set = 0;
        while (set < datasetcount && !this.getStopFlag()) {
            int value = 0;
            while (value < m.getDataSetLength(set) && !this.getStopFlag()) {
                modelVal = m.getValueAt(set, value).floatValue();
                if (modelVal == modelVal) {
                    Point2D.Float val = numericalcolumns ? new Point2D.Float(((Number)m.getColumnValueAt(set, value)).floatValue(), modelVal) : new Point2D.Float(value, modelVal);
                    yaxis1.transform(val, paint);
                    if (paint != null) {
                        g.setColor(rcm.getColor(set));
                        RectangularShape shape = rcm.getShape(set);
                        shape.setFrame(((Point2D)paint).getX() - this.shapeSize / 2.0, ((Point2D)paint).getY() - this.shapeSize / 2.0, this.shapeSize, this.shapeSize);
                        g.fill(shape);
                    }
                }
                ++value;
            }
            ++set;
        }
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }
}

