/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem.ticklocator;

public class NumericTickLocator {
    private static final int SIMPLE_TICK_THRESHOLD = 4;
    private static final int STOP_TICK_RECURSIONS = 80;
    private double max = 0.0;
    private double min = 1.0;
    private int maxtics = 40;
    private int destics = 20;
    private boolean simple = false;
    private int tick_recursions = 0;

    public NumericTickLocator(double max, double min, int numTicsDesired, int maxTics) {
        this(max, min, numTicsDesired, maxTics, false);
    }

    public NumericTickLocator(double max, double min, int numTicsDesired, int maxTics, boolean force_simple) {
        this.max = max;
        this.min = min;
        this.maxtics = maxTics;
        this.destics = numTicsDesired;
        this.simple = force_simple;
    }

    public double[] getTickMarkLocations() {
        return this.computeTicMarkLocations(this.max, this.min, this.destics, this.maxtics, this.simple);
    }

    private double[] computeTicMarkLocations(double max, double min, int numTicsDesired, int maxTics, boolean force_simple) {
        this.tick_recursions = 0;
        if (numTicsDesired == 0) {
            return this.computeTicMarkLocations(max, min, 2, maxTics, true);
        }
        if (numTicsDesired <= 4 || force_simple) {
            return this.simpleTics(max, min, numTicsDesired);
        }
        return this.performAutoScale(max, min, numTicsDesired, maxTics);
    }

    private double[] simpleTics(double max, double min, int numTicsDesired) {
        if (numTicsDesired == 0) {
            return null;
        }
        double increment = (max - min) / (double)(numTicsDesired - 1);
        double[] return_val = new double[numTicsDesired];
        return_val[0] = min;
        int i = 1;
        while (i < numTicsDesired) {
            return_val[i] = return_val[i - 1] + increment;
            ++i;
        }
        return return_val;
    }

    private double[] performAutoScale(double max, double min, int numTicsDesired, int maxTics) {
        int internalDesired = numTicsDesired;
        if (numTicsDesired < 10 && this.tick_recursions == 0) {
            internalDesired = 10;
        }
        double d = (max - min) / (double)internalDesired;
        double ld = Math.log(d) / Math.log(10.0);
        int ild = (int)Math.round(ld);
        ++this.tick_recursions;
        int numDecimals = 0;
        if (ild < 0) {
            numDecimals = -ild;
        }
        double fld = Math.pow(10.0, ld - (double)ild);
        double ticValueIncrement = Math.pow(10.0, ild);
        if (fld > 5.0) {
            ticValueIncrement *= 10.0;
            if (--numDecimals < 0) {
                numDecimals = 0;
            }
        } else if (fld > 2.0) {
            ticValueIncrement = 5.0;
        } else if (fld > 1.0) {
            ticValueIncrement = 2.0;
        }
        double minAdjusted = Math.floor(min / ticValueIncrement) * ticValueIncrement;
        double maxAdjusted = Math.floor(max / ticValueIncrement + 0.99999) * ticValueIncrement;
        int numTicsActual = (int)Math.floor((maxAdjusted - minAdjusted) / ticValueIncrement + 1.0E-5);
        if (numTicsActual > maxTics && numTicsActual / 2 <= maxTics) {
            numTicsActual /= 2;
            ticValueIncrement *= 2.0;
        }
        if (numTicsActual > maxTics && maxTics < 5 || this.tick_recursions > Math.min(80, numTicsDesired - 2)) {
            return this.simpleTics(max, min, numTicsDesired);
        }
        if (numTicsActual > maxTics) {
            return this.performAutoScale(max, min, numTicsDesired - 1, maxTics);
        }
        if (numTicsActual < numTicsDesired / 2) {
            numTicsActual *= 2;
            ticValueIncrement /= 2.0;
        }
        if (ticValueIncrement == 0.0) {
            numTicsActual = 3;
            minAdjusted = min;
            ticValueIncrement = (max - min) / 2.0;
        }
        double[] return_val = new double[Math.min(numTicsActual + 1, maxTics)];
        return_val[0] = minAdjusted;
        int i = 1;
        while (i < return_val.length) {
            return_val[i] = return_val[i - 1] + ticValueIncrement;
            ++i;
        }
        return return_val;
    }
}

