/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.server.api;

import com.pomodorotechnique.server.InterruptionType;
import com.pomodorotechnique.server.Messages;
import com.pomodorotechnique.server.PlanType;
import com.pomodorotechnique.server.Plans;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.StatusType;
import com.pomodorotechnique.server.UserType;
import com.pomodorotechnique.server.Users;
import com.pomodorotechnique.server.WorkitemType;
import com.pomodorotechnique.server.api.AlreadyExistsException;
import com.pomodorotechnique.server.api.InvalidStateException;
import com.pomodorotechnique.server.api.LoginException;
import com.pomodorotechnique.server.api.NoPomodorosLeftException;
import com.pomodorotechnique.server.api.NotFoundException;
import com.pomodorotechnique.server.api.Server;
import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;

public class OfflineServerImpl
implements Server {
    private final UserType user;
    private final Users users;
    private Date lastFlushDate = new Date();
    private int MAX_FLUSH_INTERVAL = 30;
    private static final String DATA_FILENAME = "flowkeeper.xml";

    private void fixStartedPomodoros() {
        for (PlanType p : this.user.getPlan()) {
            for (WorkitemType w : p.getWorkitem()) {
                for (PomodoroType o : w.getPomodoro()) {
                    if (!o.getStatus().equals((Object)StatusType.STARTED)) continue;
                    o.setStatus(StatusType.FAILED);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfflineServerImpl() throws IOException, LoginException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.getDataFile()));
        try {
            this.users = (Users)JAXB.unmarshal((InputStream)is, Users.class);
            this.user = this.users.getUser().get(0);
            this.fixStartedPomodoros();
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public void logout() {
        this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flush(boolean force) {
        if (force || new Date().getTime() - this.lastFlushDate.getTime() >= (long)(this.MAX_FLUSH_INTERVAL * 1000)) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            try {
                fos = new FileOutputStream(this.getDataFile());
                bos = new BufferedOutputStream(fos);
                JAXB.marshal((Object)this.users, (OutputStream)bos);
                this.lastFlushDate = new Date();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(OfflineServerImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(OfflineServerImpl.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public Users getAllUsers() {
        return this.users;
    }

    public PomodoroType addPomodoro(WorkitemType wi) throws NotFoundException {
        PomodoroType p = new PomodoroType();
        p.setPlanned(this.getPlan().getStatus().equals((Object)StatusType.NEW));
        p.setStatus(StatusType.NEW);
        wi.getPomodoro().add(p);
        this.flush(false);
        return p;
    }

    public WorkitemType addWorkItem(String workItemTitle, int pomodoros) throws NotFoundException {
        WorkitemType wi = new WorkitemType();
        boolean planned = this.getPlan().getStatus().equals((Object)StatusType.NEW);
        wi.setSection(planned ? "planned" : "unplanned");
        wi.setStatus(StatusType.NEW);
        wi.setTitle(workItemTitle);
        for (int i = 0; i < pomodoros; ++i) {
            PomodoroType p = new PomodoroType();
            p.setPlanned(true);
            p.setStatus(StatusType.NEW);
            wi.getPomodoro().add(p);
        }
        this.getPlan().getWorkitem().add(wi);
        this.flush(false);
        return wi;
    }

    public void completeWorkItem(WorkitemType wi) {
        wi.setStatus(StatusType.COMPLETED);
        this.flush(false);
    }

    public UserType getUser() {
        return this.user;
    }

    private XMLGregorianCalendar calendarToXMLGregorianCalendar(Calendar date) {
        return XMLGregorianCalendarImpl.createDate(date.get(1), date.get(2) + 1, date.get(5), Integer.MIN_VALUE);
    }

    private XMLGregorianCalendar calendarWithTimeToXMLGregorianCalendar(Calendar dateTime) {
        return XMLGregorianCalendarImpl.createDateTime(dateTime.get(1), dateTime.get(2) + 1, dateTime.get(5), dateTime.get(11), dateTime.get(12), dateTime.get(13));
    }

    public PlanType getPlan(Calendar date) throws NotFoundException {
        for (PlanType p : this.user.getPlan()) {
            if (!p.getDate().equals(this.calendarToXMLGregorianCalendar(date))) continue;
            return p;
        }
        throw new NotFoundException("Plan for given date (" + date + ") not found.");
    }

    private PomodoroType getStartedPomodoro(WorkitemType workItem) {
        for (PomodoroType p : workItem.getPomodoro()) {
            if (!p.getStatus().equals((Object)StatusType.STARTED)) continue;
            return p;
        }
        return null;
    }

    public void registerInterruption(WorkitemType workItem, InterruptionType interruption) throws InvalidStateException {
        PomodoroType p = this.getStartedPomodoro(workItem);
        if (p == null) {
            throw new InvalidStateException("Unable to register interruption because work item is not started");
        }
        p.getInterruption().add(interruption);
        this.flush(false);
    }

    public PomodoroType startNextPomodoro(WorkitemType wi) throws NotFoundException, NoPomodorosLeftException {
        XMLGregorianCalendar now = this.calendarWithTimeToXMLGregorianCalendar(this.getToday());
        for (PomodoroType p : wi.getPomodoro()) {
            if (!p.getStatus().equals((Object)StatusType.NEW)) continue;
            p.setStart(now);
            p.setStatus(StatusType.STARTED);
            wi.setStatus(StatusType.STARTED);
            this.getPlan().setStatus(StatusType.STARTED);
            this.flush(false);
            return p;
        }
        throw new NoPomodorosLeftException();
    }

    public void voidPomodoro(WorkitemType workItem) throws InvalidStateException {
        PomodoroType p = this.getStartedPomodoro(workItem);
        if (p == null) {
            throw new InvalidStateException("Unable to void pomodoro because work item is not started");
        }
        XMLGregorianCalendar now = this.calendarWithTimeToXMLGregorianCalendar(this.getToday());
        p.setFinish(now);
        p.setStatus(StatusType.FAILED);
        this.flush(false);
    }

    private Calendar getToday() {
        return Calendar.getInstance();
    }

    public PlanType getPlan() throws NotFoundException {
        return this.getPlan(this.getToday());
    }

    public PlanType createPlan() throws AlreadyExistsException {
        PlanType res = new PlanType();
        res.setStatus(StatusType.NEW);
        res.setDate(this.calendarToXMLGregorianCalendar(this.getToday()));
        this.user.getPlan().add(res);
        this.flush(false);
        return res;
    }

    public Plans getPlans() {
        Plans plans = new Plans();
        plans.getPlan().addAll(this.user.getPlan());
        return plans;
    }

    public Messages getMessages(WorkitemType workItem) throws InvalidStateException {
        PomodoroType p = this.getStartedPomodoro(workItem);
        if (p == null) {
            throw new InvalidStateException("Unable to get messages because work item is not started");
        }
        Messages m = new Messages();
        m.getMessage().addAll(p.getMessage());
        return m;
    }

    public void sendMessage(String userId, String message) throws InvalidStateException {
        throw new UnsupportedOperationException("Sending messages is not supported in offline mode");
    }

    public void deletePlan(PlanType plan) {
        this.user.getPlan().remove(plan);
        this.flush(false);
    }

    public void completePomodoro(WorkitemType workItem) throws InvalidStateException {
        PomodoroType p = this.getStartedPomodoro(workItem);
        if (p == null) {
            throw new InvalidStateException("Unable to complete pomodoro because work item is not started");
        }
        XMLGregorianCalendar now = this.calendarWithTimeToXMLGregorianCalendar(this.getToday());
        p.setFinish(now);
        p.setStatus(StatusType.COMPLETED);
        this.flush(false);
    }

    private File getDataFile() {
        try {
            String fn = System.getProperty("user.home") + System.getProperty("file.separator") + DATA_FILENAME;
            File f = new File(fn);
            if (!f.exists()) {
                FileWriter fw = new FileWriter(f);
                fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
                fw.write("<users xmlns=\"http://flowkeeper.org/server\">\n");
                fw.write("<user break-length=\"5\" id=\"user\" name=\"Pomodoro User\" pomodoro-length=\"25\" regdate=\"2001-12-31T12:00:00\" password=\"\" />\n");
                fw.write("</users>");
                fw.close();
            }
            return f;
        }
        catch (Throwable t) {
            throw new RuntimeException("Fatal error while accessing data file", t);
        }
    }
}

