/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.text.NumberFormat;

public final class Format {
    public static final int SECONDS_INA_MINUTE = 60;
    public static final int SECONDS_INA_HOUR = 3600;
    public static final int SECONDS_INA_DAY = 86400;
    public static final long MEMORY_K = 1024L;
    public static final long MEMORY_MEG = 0x100000L;
    public static final long MEMORY_GIG = 0x40000000L;
    public static final long MEMORY_TERA = 0x10000000000L;
    public static final long MILI_IN_SEC = 1000L;
    public static final double HUNDRED_PERCENT = 100.0;

    public static String formatDouble(double d, int i) {
        NumberFormat f = NumberFormat.getNumberInstance();
        f.setMinimumFractionDigits(i);
        return f.format(d);
    }

    public static String formatInteger(int i) {
        NumberFormat f = NumberFormat.getIntegerInstance();
        return f.format(i);
    }

    public static String formatMemory(long memory) {
        if (memory < 1024L) {
            return memory + " bytes";
        }
        if (memory < 0x100000L) {
            return Format.formatDouble((double)memory / 1024.0, 2) + " KB";
        }
        if (memory < 0x40000000L) {
            return Format.formatDouble((double)memory / 1048576.0, 2) + " MB";
        }
        if (memory < 0x10000000000L) {
            return Format.formatDouble((double)memory / 1.073741824E9, 2) + " GB";
        }
        return Format.formatDouble((double)memory / 1.099511627776E12, 2) + " TB";
    }

    public static String formatPercent(double e) {
        if (Double.isNaN(e) || Double.isInfinite(e)) {
            return "NaN";
        }
        NumberFormat f = NumberFormat.getPercentInstance();
        f.setMinimumFractionDigits(6);
        return f.format(e);
    }

    public static String formatPercentWhole(double e) {
        NumberFormat f = NumberFormat.getPercentInstance();
        return f.format(e);
    }

    public static String formatTimeSpan(int seconds) {
        int secondsCount = seconds;
        int days = seconds / 86400;
        int hours = (secondsCount -= days * 86400) / 3600;
        int minutes = (secondsCount -= hours * 3600) / 60;
        secondsCount -= minutes * 60;
        NumberFormat f = NumberFormat.getIntegerInstance();
        f.setMinimumIntegerDigits(2);
        f.setMaximumIntegerDigits(2);
        StringBuilder result = new StringBuilder();
        if (days > 0) {
            result.append(days);
            if (days > 1) {
                result.append(" days ");
            } else {
                result.append(" day ");
            }
        }
        result.append(f.format(hours));
        result.append(':');
        result.append(f.format(minutes));
        result.append(':');
        result.append(f.format(secondsCount));
        return result.toString();
    }

    public static String formatYesNo(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    private Format() {
    }
}

