/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.world.grid.probability;

import java.util.Set;
import java.util.TreeSet;
import org.encog.ml.world.Action;
import org.encog.ml.world.State;
import org.encog.ml.world.SuccessorState;
import org.encog.ml.world.WorldError;
import org.encog.ml.world.grid.GridState;
import org.encog.ml.world.grid.GridWorld;
import org.encog.ml.world.grid.probability.GridAbstractProbability;

public class GridStochasticProbability
extends GridAbstractProbability {
    private double probabilitySuccess;
    private double probabilitySame;
    private double probabilityLeft;
    private double probabilityRight;
    private double probabilityReverse;

    public GridStochasticProbability(GridWorld theWorld, double theProbabilitySuccess, double theProbabilitySame, double theProbabilityLeft, double theProbabilityRight, double theProbabilityReverse) {
        super(theWorld);
        this.probabilitySuccess = theProbabilitySuccess;
        this.probabilitySame = theProbabilitySame;
        this.probabilityLeft = theProbabilityLeft;
        this.probabilityRight = theProbabilityRight;
        this.probabilityReverse = theProbabilityReverse;
    }

    public GridStochasticProbability(GridWorld theWorld) {
        this(theWorld, 0.8, 0.0, 0.1, 0.1, 0.0);
    }

    public double getProbabilitySuccess() {
        return this.probabilitySuccess;
    }

    public void setProbabilitySuccess(double probabilitySuccess) {
        this.probabilitySuccess = probabilitySuccess;
    }

    public double getProbabilitySame() {
        return this.probabilitySame;
    }

    public void setProbabilitySame(double probabilitySame) {
        this.probabilitySame = probabilitySame;
    }

    public double getProbabilityLeft() {
        return this.probabilityLeft;
    }

    public void setProbabilityLeft(double probabilityLeft) {
        this.probabilityLeft = probabilityLeft;
    }

    public double getProbabilityRight() {
        return this.probabilityRight;
    }

    public void setProbabilityRight(double probabilityRight) {
        this.probabilityRight = probabilityRight;
    }

    public double getProbabilityReverse() {
        return this.probabilityReverse;
    }

    public void setProbabilityReverse(double probabilityReverse) {
        this.probabilityReverse = probabilityReverse;
    }

    @Override
    public double calculate(State resultState, State previousState, Action desiredAction) {
        if (!(resultState instanceof GridState) || !(previousState instanceof GridState)) {
            throw new WorldError("Must be instance of GridState");
        }
        GridState gridResultState = (GridState)resultState;
        GridState gridPreviousState = (GridState)previousState;
        Action resultingAction = this.determineResultingAction(gridPreviousState, gridResultState);
        GridState desiredState = this.determineActionState(gridPreviousState, desiredAction);
        if (gridResultState == gridPreviousState) {
            if (GridWorld.isStateBlocked(desiredState)) {
                return this.probabilitySuccess;
            }
            return 0.0;
        }
        if (resultingAction == desiredAction) {
            return this.probabilitySuccess;
        }
        if (resultingAction == GridWorld.rightOfAction(desiredAction)) {
            return this.probabilityRight;
        }
        if (resultingAction == GridWorld.leftOfAction(desiredAction)) {
            return this.probabilityLeft;
        }
        if (resultingAction == GridWorld.reverseOfAction(desiredAction)) {
            return this.probabilityReverse;
        }
        return 0.0;
    }

    @Override
    public Set<SuccessorState> determineSuccessorStates(State state, Action action) {
        TreeSet<SuccessorState> result = new TreeSet<SuccessorState>();
        if (action != null) {
            GridState newState;
            if (this.probabilitySuccess > 1.0E-13 && (newState = this.determineActionState((GridState)state, action)) != null) {
                result.add(new SuccessorState(newState, this.probabilitySuccess));
            }
            if (this.probabilityLeft > 1.0E-13 && (newState = this.determineActionState((GridState)state, GridWorld.leftOfAction(action))) != null) {
                result.add(new SuccessorState(newState, this.probabilityLeft));
            }
            if (this.probabilityRight > 1.0E-13 && (newState = this.determineActionState((GridState)state, GridWorld.rightOfAction(action))) != null) {
                result.add(new SuccessorState(newState, this.probabilityRight));
            }
            if (this.probabilityReverse > 1.0E-13 && (newState = this.determineActionState((GridState)state, GridWorld.reverseOfAction(action))) != null) {
                result.add(new SuccessorState(newState, this.probabilityReverse));
            }
        }
        return result;
    }
}

