/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.text.CharacterIterator;

final class CharArrayIterator
implements CharacterIterator {
    private char[] array;
    private int start;
    private int index;
    private int length;
    private int limit;

    CharArrayIterator() {
    }

    public char[] getText() {
        return this.array;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    void setText(char[] array, int start, int length) {
        this.array = array;
        this.start = start;
        this.index = start;
        this.length = length;
        this.limit = start + length;
    }

    public char current() {
        return this.index == this.limit ? (char)'\uffff' : CharArrayIterator.jvmBugWorkaround(this.array[this.index]);
    }

    public static final char jvmBugWorkaround(char ch) {
        return (char)(ch >= 55296 && ch <= 57343 ? 44 : ch);
    }

    public char first() {
        this.index = this.start;
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.length;
    }

    public int getIndex() {
        return this.index - this.start;
    }

    public char last() {
        this.index = this.limit == this.start ? this.limit : this.limit - 1;
        return this.current();
    }

    public char next() {
        if (++this.index >= this.limit) {
            this.index = this.limit;
            return '\uffff';
        }
        return this.current();
    }

    public char previous() {
        if (--this.index < this.start) {
            this.index = this.start;
            return '\uffff';
        }
        return this.current();
    }

    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException("Illegal Position: " + position);
        }
        this.index = this.start + position;
        return this.current();
    }

    public Object clone() {
        CharArrayIterator clone = new CharArrayIterator();
        clone.setText(this.array, this.start, this.length);
        clone.index = this.index;
        return clone;
    }
}

