/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.Relevance;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.undo.NamedCompound;

public class SpecialFieldsUtils {
    public static final String FIELDNAME_PRIORITY = "priority";
    public static final String FIELDNAME_RANKING = "ranking";
    public static final String FIELDNAME_RELEVANCE = "relevance";
    public static final String FIELDNAME_QUALITY = "qualityassured";
    public static final String PREF_SPECIALFIELDSENABLED = "specialFieldsEnabled";
    public static final Boolean PREF_SPECIALFIELDSENABLED_DEFAULT = Boolean.FALSE;
    public static final String PREF_SHOWCOLUMN_RANKING = "showRankingColumn";
    public static final Boolean PREF_SHOWCOLUMN_RANKING_DEFAULT = Boolean.TRUE;
    public static final String PREF_RANKING_COMPACT = "compactRankingColumn";
    public static final Boolean PREF_RANKING_COMPACT_DEFAULT = Boolean.TRUE;
    public static final String PREF_SHOWCOLUMN_PRIORITY = "showPriorityColumn";
    public static final Boolean PREF_SHOWCOLUMN_PRIORITY_DEFAULT = Boolean.FALSE;
    public static final String PREF_SHOWCOLUMN_RELEVANCE = "showRelevanceColumn";
    public static final Boolean PREF_SHOWCOLUMN_RELEVANCE_DEFAULT = Boolean.FALSE;
    public static final String PREF_SHOWCOLUMN_QUALITY = "showQualityColumn";
    public static final Boolean PREF_SHOWCOLUMN_QUALITY_DEFAULT = Boolean.FALSE;
    public static final String PREF_AUTOSYNCSPECIALFIELDSTOKEYWORDS = "autoSyncSpecialFieldsToKeywords";
    public static final Boolean PREF_AUTOSYNCSPECIALFIELDSTOKEYWORDS_DEFAULT = Boolean.FALSE;
    public static final String PREF_SERIALIZESPECIALFIELDS = "serializeSpecialFields";
    public static final Boolean PREF_SERIALIZESPECIALFIELDS_DEFAULT = Boolean.TRUE;

    public static void updateField(SpecialField e, String value, BibtexEntry be, NamedCompound ce, boolean nullFieldIfValueIsTheSame) {
        Util.updateField(be, e.getFieldName(), value, ce, nullFieldIfValueIsTheSame);
        SpecialFieldsUtils.exportFieldToKeywords(e, be.getField(e.getFieldName()), be, ce);
    }

    private static void exportFieldToKeywords(SpecialField e, BibtexEntry be, NamedCompound ce) {
        SpecialFieldsUtils.exportFieldToKeywords(e, be.getField(e.getFieldName()), be, ce);
    }

    private static void exportFieldToKeywords(SpecialField e, String newValue, BibtexEntry be, NamedCompound ce) {
        if (!SpecialFieldsUtils.keywordSyncEnabled()) {
            return;
        }
        ArrayList<String> keywordList = Util.getSeparatedKeywords(be);
        List<String> values = e.getKeyWords();
        int foundPos = -1;
        for (String value : values) {
            int pos = keywordList.indexOf(value);
            if (pos < 0) continue;
            foundPos = pos;
            keywordList.remove(pos);
        }
        if (newValue != null) {
            if (foundPos == -1) {
                keywordList.add(newValue);
            } else {
                keywordList.add(foundPos, newValue);
            }
        }
        Util.putKeywords(be, keywordList, ce);
    }

    public static void syncKeywordsFromSpecialFields(BibtexEntry be, NamedCompound nc) {
        SpecialFieldsUtils.exportFieldToKeywords(Priority.getInstance(), be, nc);
        SpecialFieldsUtils.exportFieldToKeywords(Rank.getInstance(), be, nc);
        SpecialFieldsUtils.exportFieldToKeywords(Relevance.getInstance(), be, nc);
        SpecialFieldsUtils.exportFieldToKeywords(Quality.getInstance(), be, nc);
    }

    private static void importKeywordsForField(ArrayList<String> keywordList, SpecialField c, BibtexEntry be, NamedCompound nc) {
        List<String> values = c.getKeyWords();
        String newValue = null;
        for (String val : values) {
            if (!keywordList.contains(val)) continue;
            newValue = val;
            break;
        }
        Util.updateField(be, c.getFieldName(), newValue, nc);
    }

    public static void syncSpecialFieldsFromKeywords(BibtexEntry be, NamedCompound ce) {
        if (be.getField("keywords") == null) {
            return;
        }
        ArrayList<String> keywordList = Util.getSeparatedKeywords(be.getField("keywords"));
        SpecialFieldsUtils.importKeywordsForField(keywordList, Priority.getInstance(), be, ce);
        SpecialFieldsUtils.importKeywordsForField(keywordList, Rank.getInstance(), be, ce);
        SpecialFieldsUtils.importKeywordsForField(keywordList, Quality.getInstance(), be, ce);
        SpecialFieldsUtils.importKeywordsForField(keywordList, Relevance.getInstance(), be, ce);
    }

    public static SpecialField getSpecialFieldInstanceFromFieldName(String fieldName) {
        if (fieldName.equals(FIELDNAME_PRIORITY)) {
            return Priority.getInstance();
        }
        if (fieldName.equals(FIELDNAME_QUALITY)) {
            return Quality.getInstance();
        }
        if (fieldName.equals(FIELDNAME_RANKING)) {
            return Rank.getInstance();
        }
        if (fieldName.equals(FIELDNAME_RELEVANCE)) {
            return Relevance.getInstance();
        }
        return null;
    }

    public static boolean isSpecialField(String fieldName) {
        return SpecialFieldsUtils.getSpecialFieldInstanceFromFieldName(fieldName) != null;
    }

    public static boolean keywordSyncEnabled() {
        return Globals.prefs.getBoolean(PREF_SPECIALFIELDSENABLED) && Globals.prefs.getBoolean(PREF_AUTOSYNCSPECIALFIELDSTOKEYWORDS);
    }
}

