/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PageNumbers {
    String freeform = null;
    int start;
    int end;

    public PageNumbers(String s) {
        this.parsePageNums(s);
    }

    protected void parsePageNums(String s) {
        Pattern p = Pattern.compile("\\s*(\\d+)\\s*-{1,2}\\s*(\\d+)\\s*");
        Matcher m = p.matcher(s);
        if (m.matches()) {
            this.start = Integer.parseInt(m.group(1));
            this.end = Integer.parseInt(m.group(2));
        } else {
            this.freeform = s;
        }
    }

    public Element getDOMrepresentation(Document d) {
        Element result = d.createElement("extent");
        result.setAttribute("unit", "page");
        if (this.freeform != null) {
            Text t = d.createTextNode(this.freeform);
            result.appendChild(t);
        } else {
            Element start = d.createElement("start");
            Element end = d.createElement("end");
            start.appendChild(d.createTextNode("" + this.start));
            end.appendChild(d.createTextNode("" + this.end));
            result.appendChild(start);
            result.appendChild(end);
        }
        return result;
    }

    public String toString(String seperator) {
        if (this.freeform != null) {
            return this.freeform;
        }
        return this.start + seperator + this.end;
    }

    public String toString() {
        return this.toString("--");
    }
}

