/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Scanner;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;

public class ISBNtoBibTeXFetcher
implements EntryFetcher {
    private static final String URL_PATTERN = "http://manas.tungare.name/software/isbn-to-bibtex/isbn-service?isbn=%s";
    final CaseKeeper caseKeeper = new CaseKeeper();

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        InputStream source;
        URL url;
        String q;
        try {
            q = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            status.setStatus(Globals.lang("Error"));
            e.printStackTrace();
            return false;
        }
        String urlString = String.format(URL_PATTERN, q);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            source = url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        String bibtexString = new Scanner(source).useDelimiter("\\A").next();
        if (bibtexString.startsWith("@comment")) {
            String errorMsg = bibtexString.substring("@comment{".length());
            errorMsg = errorMsg.substring(0, errorMsg.length() - 1);
            status.showMessage(errorMsg);
            return false;
        }
        BibtexEntry entry = BibtexParser.singleFromString(bibtexString);
        if (entry != null) {
            String title = entry.getField("title");
            if (title != null) {
                if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                    title = this.caseKeeper.format(title);
                }
                entry.setField("title", title);
            }
            inspector.addEntry(entry);
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "ISBN to BibTeX";
    }

    @Override
    public String getKeyName() {
        return "ISBNtoBibTeX";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getHelpPage() {
        return "ISBNtoBibTeXHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

