/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.sf.jabref.BibtexEntry;

public class TransferableEntrySelection
implements Transferable {
    public static final DataFlavor flavorInternal;
    public static final DataFlavor flavorExternal;
    public static final DataFlavor[] flavors;
    public final BibtexEntry[] selectedEntries;
    public final String selectedEntriesCiteKeys;
    protected boolean includeCiteKeyword = false;

    public TransferableEntrySelection(BibtexEntry[] selectedEntries) {
        this.selectedEntries = selectedEntries;
        StringBuffer keys = new StringBuffer();
        for (int i = 0; i < selectedEntries.length; ++i) {
            keys.append(selectedEntries[i].getCiteKey());
            if (i + 1 >= selectedEntries.length) continue;
            keys.append(",");
        }
        this.selectedEntriesCiteKeys = keys.toString();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor someFlavor) {
        return someFlavor.equals(flavorInternal) || someFlavor.equals(flavorExternal);
    }

    @Override
    public Object getTransferData(DataFlavor someFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(someFlavor)) {
            throw new UnsupportedFlavorException(someFlavor);
        }
        if (someFlavor.equals(flavorInternal)) {
            return this;
        }
        String s = this.includeCiteKeyword ? "\\cite{" + this.selectedEntriesCiteKeys + "}" : this.selectedEntriesCiteKeys;
        return new ByteArrayInputStream(s.getBytes(flavorExternal.getParameter("charset").trim()));
    }

    public BibtexEntry[] getSelection() {
        return this.selectedEntries;
    }

    public void setIncludeCiteKeyword(boolean includeCiteKeyword) {
        this.includeCiteKeyword = includeCiteKeyword;
    }

    static {
        DataFlavor df1 = null;
        DataFlavor df2 = null;
        try {
            df1 = new DataFlavor("application/x-java-jvm-local-objectref;class=net.sf.jabref.groups.TransferableEntrySelection");
            df2 = DataFlavor.getTextPlainUnicodeFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        flavorInternal = df1;
        flavorExternal = df2;
        flavors = new DataFlavor[]{flavorInternal, flavorExternal};
    }
}

