/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import javax.swing.filechooser.FileFilter;

public class OpenFileFilter
extends FileFilter
implements FilenameFilter {
    HashSet<String> extSet = new HashSet();
    String desc;

    public OpenFileFilter(String[] extensions) {
        StringBuffer buf = new StringBuffer();
        int numExt = extensions.length;
        if (numExt > 0) {
            buf.append('*');
            buf.append(extensions[0]);
            this.extSet.add(extensions[0]);
        }
        for (int curExt = 1; curExt < numExt; ++curExt) {
            buf.append(", *");
            buf.append(extensions[curExt]);
            this.extSet.add(extensions[curExt]);
        }
        this.desc = buf.toString();
    }

    public OpenFileFilter() {
        this(new String[]{".bib", ".dat", ".txt", ".ris", ".ref", ".fcgi", ".bibx", ".xml"});
    }

    public OpenFileFilter(String s) {
        this(s.split("[, ]+", 0));
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.accept(file.getName());
    }

    public boolean accept(String filenm) {
        int dotPos = (filenm = filenm.toLowerCase()).lastIndexOf(".");
        if (dotPos == -1) {
            return false;
        }
        int dotDotPos = filenm.lastIndexOf(".", dotPos - 1);
        return this.extSet.contains(filenm.substring(dotPos)) || dotDotPos >= 0 && this.extSet.contains(filenm.substring(dotDotPos));
    }

    public String getSuffix(String filenm) {
        int dotPos = filenm.lastIndexOf(".");
        if (dotPos == -1) {
            return null;
        }
        String suffix = filenm.substring(dotPos);
        if (this.extSet.contains(suffix)) {
            return suffix;
        }
        if ((dotPos = filenm.lastIndexOf(".", dotPos - 1)) == -1) {
            return null;
        }
        suffix = filenm.substring(dotPos);
        if (this.extSet.contains(suffix)) {
            return suffix;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.accept(new File(dir.getPath() + name));
    }
}

