/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.UndoableEditListener;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.FieldTextMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JTextAreaWithHighlighting;
import net.sf.jabref.Util;
import net.sf.jabref.gui.AutoCompleteListener;

public class FieldTextArea
extends JTextAreaWithHighlighting
implements FieldEditor {
    Dimension PREFERRED_SIZE;
    JScrollPane sp;
    FieldNameLabel label;
    String fieldName;
    static final Pattern bull = Pattern.compile("\\s*[-\\*]+.*");
    static final Pattern indent = Pattern.compile("\\s+.*");
    private AutoCompleteListener autoCompleteListener = null;

    public FieldTextArea(String fieldName_, String content) {
        super(content);
        this.updateFont();
        this.addFocusListener(Globals.focusListener);
        this.addFocusListener(new FieldEditorFocusListener());
        this.sp = new JScrollPane(this, 20, 31);
        this.sp.setMinimumSize(new Dimension(200, 1));
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.fieldName = fieldName_;
        this.label = new FieldNameLabel(" " + Util.nCase(this.fieldName) + " ");
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
        this.setForeground(GUIGlobals.editorTextColor);
        FieldTextMenu popMenu = new FieldTextMenu(this);
        this.addMouseListener(popMenu);
        this.label.addMouseListener(popMenu);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String newName) {
        this.fieldName = newName;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color c) {
        this.label.setForeground(c);
    }

    @Override
    public JComponent getPane() {
        return this.sp;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public void setActiveBackgroundColor() {
        this.setBackground(GUIGlobals.activeBackground);
    }

    @Override
    public void setValidBackgroundColor() {
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
    }

    @Override
    public void setInvalidBackgroundColor() {
        this.setBackground(GUIGlobals.invalidFieldBackgroundColor);
    }

    @Override
    public void updateFontColor() {
        this.setForeground(GUIGlobals.editorTextColor);
    }

    @Override
    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
    }

    @Override
    public void paste(String textToInsert) {
        int sel = this.getSelectionEnd() - this.getSelectionStart();
        if (sel > 0) {
            this.replaceSelection(textToInsert);
        } else {
            int cPos = this.getCaretPosition();
            this.insert(textToInsert, cPos);
        }
    }

    @Override
    public boolean hasUndoInformation() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean hasRedoInformation() {
        return false;
    }

    @Override
    public void redo() {
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.getDocument().addUndoableEditListener(listener);
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener listener) {
        this.autoCompleteListener = listener;
    }

    @Override
    public void clearAutoCompleteSuggestion() {
        if (this.autoCompleteListener != null) {
            this.autoCompleteListener.clearCurrentSuggestion(this);
        }
    }
}

