/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.calendar.ui.basic;

import com.michaelbaranov.microba.calendar.CalendarPane;
import com.michaelbaranov.microba.calendar.HolidayPolicy;
import com.michaelbaranov.microba.calendar.VetoPolicy;
import com.michaelbaranov.microba.calendar.ui.CalendarPaneUI;
import com.michaelbaranov.microba.calendar.ui.basic.AuxPanel;
import com.michaelbaranov.microba.calendar.ui.basic.CalendarGridPanel;
import com.michaelbaranov.microba.calendar.ui.basic.CalendarHeader;
import com.michaelbaranov.microba.calendar.ui.basic.ClassicCalendarPanel;
import com.michaelbaranov.microba.calendar.ui.basic.ModernCalendarPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class BasicCalendarPaneUI
extends CalendarPaneUI
implements PropertyChangeListener,
FocusListener {
    protected static final String ESCAPE_KEY = "##CalendarPaneUI.escape##";
    protected static final String ENTER_KEY = "##CalendarPaneUI.enter##";
    protected CalendarPane peer;
    protected ClassicCalendarPanel classicPanel;
    protected ModernCalendarPanel modernPanel;
    protected AuxPanel auxPanel;
    protected CalendarGridPanel gridPanel;
    protected CalendarHeader headerPanel;
    protected Set focusableComponents = new HashSet();
    protected ComponentListener componentListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicCalendarPaneUI();
    }

    public void installUI(JComponent component) {
        this.peer = (CalendarPane)component;
        this.createNestedComponents();
        this.addNestedComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent component) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.removeNestedComponents();
        this.destroyNestedComponents();
        this.peer = null;
    }

    protected void uninstallKeyboardActions() {
        InputMap input = this.peer.getInputMap(1);
        ActionMap action = this.peer.getActionMap();
        input.remove(KeyStroke.getKeyStroke(10, 0));
        input.remove(KeyStroke.getKeyStroke(27, 0));
        action.remove(ENTER_KEY);
        action.remove(ESCAPE_KEY);
    }

    protected void installKeyboardActions() {
        InputMap input = this.peer.getInputMap(1);
        ActionMap action = this.peer.getActionMap();
        input.put(KeyStroke.getKeyStroke(10, 0), ENTER_KEY);
        input.put(KeyStroke.getKeyStroke(27, 0), ESCAPE_KEY);
        input.put(KeyStroke.getKeyStroke(33, 0), "pgupkey");
        input.put(KeyStroke.getKeyStroke(34, 0), "pgdownkey");
        action.put(ENTER_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BasicCalendarPaneUI.this.peer.commitEdit();
            }
        });
        action.put(ESCAPE_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BasicCalendarPaneUI.this.peer.revertEdit();
            }
        });
        action.put("pgupkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BasicCalendarPaneUI.this.classicPanel.addMonth(1);
            }
        });
        action.put("pgdownkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BasicCalendarPaneUI.this.classicPanel.addMonth(-1);
            }
        });
    }

    protected void uninstallListeners() {
        this.peer.removePropertyChangeListener(this);
        this.peer.removeFocusListener(this);
    }

    protected void installListeners() {
        this.peer.addPropertyChangeListener(this);
        this.peer.addFocusListener(this);
    }

    protected void createNestedComponents() {
        Date baseDate = this.peer.getDate() == null ? new Date() : this.peer.getDate();
        this.classicPanel = new ClassicCalendarPanel(baseDate, this.peer.getLocale(), this.peer.getZone());
        this.modernPanel = new ModernCalendarPanel(baseDate, this.peer.getLocale(), this.peer.getZone());
        this.headerPanel = new CalendarHeader(baseDate, this.peer.getLocale(), this.peer.getZone(), this.peer.getHolidayPolicy());
        this.auxPanel = new AuxPanel(this.peer.getLocale(), this.peer.getZone(), this.peer.getVetoPolicy(), this.peer.isShowTodayButton(), this.peer.isShowNoneButton(), this.peer.getResources());
        this.gridPanel = new CalendarGridPanel(this.peer.getDate(), this.peer.getLocale(), this.peer.getZone(), this.peer.getVetoPolicy(), this.peer.getHolidayPolicy());
        this.focusableComponents.addAll(this.classicPanel.getFocusableComponents());
        this.focusableComponents.addAll(this.modernPanel.getFocusableComponents());
        this.focusableComponents.addAll(this.auxPanel.getFocusableComponents());
        this.focusableComponents.addAll(this.gridPanel.getFocusableComponents());
        this.focusableComponents.addAll(this.auxPanel.getFocusableComponents());
        this.componentListener = new ComponentListener();
        for (int i = 0; i < this.focusableComponents.size(); ++i) {
            ((JComponent)this.focusableComponents.toArray()[i]).addFocusListener(this.componentListener);
        }
        this.gridPanel.addPropertyChangeListener(this.componentListener);
        this.modernPanel.addPropertyChangeListener(this.componentListener);
        this.classicPanel.addPropertyChangeListener(this.componentListener);
        this.auxPanel.addPropertyChangeListener(this.componentListener);
    }

    protected void destroyNestedComponents() {
        this.gridPanel.removePropertyChangeListener(this.componentListener);
        this.modernPanel.removePropertyChangeListener(this.componentListener);
        this.classicPanel.removePropertyChangeListener(this.componentListener);
        this.auxPanel.removePropertyChangeListener(this.componentListener);
        this.componentListener = null;
        for (int i = 0; i < this.focusableComponents.size(); ++i) {
            ((JComponent)this.focusableComponents.toArray()[i]).removeFocusListener(this.componentListener);
        }
        this.focusableComponents.clear();
        this.classicPanel = null;
        this.modernPanel = null;
        this.headerPanel = null;
        this.auxPanel = null;
        this.gridPanel = null;
    }

    protected void addNestedComponents() {
        this.peer.removeAll();
        this.peer.setLayout(new GridBagLayout());
        if ((this.peer.getStyle() & 0x20) > 0) {
            this.peer.add((Component)this.classicPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.peer.add((Component)this.modernPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.peer.add((Component)this.headerPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.peer.add((Component)this.gridPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.peer.isShowTodayButton()) {
            this.peer.add((Component)this.auxPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.peer.revalidate();
        this.peer.repaint();
    }

    protected void removeNestedComponents() {
        this.peer.removeAll();
    }

    protected void widgetDateChanged(Date date) {
        Date baseDate = date == null ? new Date() : date;
        this.headerPanel.setDate(baseDate);
        this.classicPanel.setDate(baseDate);
        this.modernPanel.setDate(baseDate);
        this.gridPanel.setBaseDate(baseDate);
        this.gridPanel.setDate(date);
    }

    protected void widgetLocaleChanged(Locale newValue) {
        this.classicPanel.setLocale(newValue);
        this.modernPanel.setLocale(newValue);
        this.gridPanel.setLocale(newValue);
        this.headerPanel.setLocale(newValue);
        this.auxPanel.setLocale(newValue);
    }

    protected void widgetZoneChanged(TimeZone zone) {
        this.classicPanel.setZone(zone);
        this.modernPanel.setZone(zone);
        this.gridPanel.setZone(zone);
        this.headerPanel.setZone(zone);
        this.auxPanel.setZone(zone);
    }

    protected void widgetResourceChanged() {
        this.auxPanel.setResources(this.peer.getResources());
    }

    public void commit() throws PropertyVetoException {
        this.peer.setDate(this.gridPanel.getDateToCommit());
    }

    public void revert() {
        this.widgetDateChanged(this.peer.getDate());
    }

    public void focusGained(FocusEvent e) {
        this.gridPanel.requestFocus(true);
    }

    public void focusLost(FocusEvent e) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("date")) {
            this.widgetDateChanged((Date)evt.getNewValue());
        } else if (evt.getPropertyName().equals("locale")) {
            this.widgetLocaleChanged((Locale)evt.getNewValue());
        } else if (evt.getPropertyName().equals("zone")) {
            this.widgetZoneChanged((TimeZone)evt.getNewValue());
        } else if (evt.getPropertyName().equals("vetoPlicy")) {
            this.gridPanel.setVetoPolicy((VetoPolicy)evt.getNewValue());
            this.auxPanel.setVetoModel((VetoPolicy)evt.getNewValue());
        } else if (evt.getPropertyName().equals("holidayPolicy")) {
            this.gridPanel.setHolidayPolicy((HolidayPolicy)evt.getNewValue());
            this.headerPanel.setHolidayPolicy((HolidayPolicy)evt.getNewValue());
        } else if (evt.getPropertyName().equals("enabled")) {
            boolean value = (Boolean)evt.getNewValue();
            this.classicPanel.setEnabled(value);
            this.modernPanel.setEnabled(value);
            this.headerPanel.setEnabled(value);
            this.gridPanel.setEnabled(value);
            this.auxPanel.setEnabled(value);
        } else if (evt.getPropertyName().equals("style")) {
            this.addNestedComponents();
        } else if (evt.getPropertyName().equals("showTodayButton")) {
            Boolean value = (Boolean)evt.getNewValue();
            this.auxPanel.setShowTodayBtn(value);
        } else if (evt.getPropertyName().equals("showNoneButton")) {
            boolean value = (Boolean)evt.getNewValue();
            this.auxPanel.setShowNoneButton(value);
        } else if (evt.getPropertyName().equals("focusable")) {
            Boolean value = (Boolean)evt.getNewValue();
            this.classicPanel.setFocusable(value);
            this.modernPanel.setFocusable(value);
            this.gridPanel.setFocusable(value);
            this.auxPanel.setFocusable(value);
        } else if (evt.getPropertyName().equals("resources")) {
            this.widgetResourceChanged();
        } else if (evt.getPropertyName().equals("enabled")) {
            Boolean value = (Boolean)evt.getNewValue();
            this.classicPanel.setEnabled(value);
            this.modernPanel.setEnabled(value);
            this.gridPanel.setEnabled(value);
            this.auxPanel.setEnabled(value);
        }
    }

    protected class ComponentListener
    implements FocusListener,
    PropertyChangeListener {
        protected ComponentListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            boolean isNonEmptyOpposite;
            boolean isFocusableComponent = BasicCalendarPaneUI.this.focusableComponents.contains(e.getSource());
            boolean bl = isNonEmptyOpposite = e.getOppositeComponent() != null;
            if (isFocusableComponent && isNonEmptyOpposite && !SwingUtilities.isDescendingFrom(e.getOppositeComponent(), BasicCalendarPaneUI.this.peer)) {
                BasicCalendarPaneUI.this.peer.commitOrRevert();
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Date newValue;
            if (evt.getSource() == BasicCalendarPaneUI.this.gridPanel && evt.getPropertyName().equals("date")) {
                newValue = (Date)evt.getNewValue();
                try {
                    BasicCalendarPaneUI.this.peer.setDate(newValue);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (evt.getSource() == BasicCalendarPaneUI.this.gridPanel && evt.getPropertyName().equals("baseDate")) {
                newValue = (Date)evt.getNewValue();
                BasicCalendarPaneUI.this.modernPanel.setDate(newValue);
                BasicCalendarPaneUI.this.classicPanel.setDate(newValue);
            }
            if (evt.getSource() == BasicCalendarPaneUI.this.modernPanel && evt.getPropertyName().equals("date")) {
                newValue = (Date)evt.getNewValue();
                BasicCalendarPaneUI.this.gridPanel.setBaseDate(newValue);
                BasicCalendarPaneUI.this.classicPanel.setDate(newValue);
            }
            if (evt.getSource() == BasicCalendarPaneUI.this.classicPanel && evt.getPropertyName().equals("date")) {
                newValue = (Date)evt.getNewValue();
                BasicCalendarPaneUI.this.gridPanel.setBaseDate(newValue);
                BasicCalendarPaneUI.this.modernPanel.setDate(newValue);
            }
            if (evt.getSource() == BasicCalendarPaneUI.this.auxPanel && evt.getPropertyName().equals("date")) {
                Date date = (Date)evt.getNewValue();
                BasicCalendarPaneUI.this.gridPanel.setDate(date);
                BasicCalendarPaneUI.this.peer.commitEdit();
            }
        }
    }
}

