/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.profiler4j.console.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleTableModel
extends AbstractTableModel {
    private List<Rule> rules = new ArrayList<Rule>();

    public void insert(int r, Rule rule) {
        if (r == -1) {
            this.rules.add(rule);
        } else {
            this.rules.add(r, rule);
        }
        this.fireTableDataChanged();
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void insert(Rule rule) {
        this.rules.add(rule);
        this.fireTableDataChanged();
    }

    public void remove(int r) {
        this.rules.remove(r);
        this.fireTableDataChanged();
    }

    public void moveUp(int r) {
        if (r == 0) {
            return;
        }
        Rule rule = this.rules.remove(r);
        this.rules.add(r - 1, rule);
        this.fireTableDataChanged();
    }

    public void moveDown(int r) {
        if (r + 1 >= this.rules.size()) {
            return;
        }
        Rule rule = this.rules.remove(r);
        this.rules.add(r + 1, rule);
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Rule.Action.class;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return "Method Pattern";
            }
            case 1: {
                return "Action";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.rules.size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        Rule rule = this.rules.get(r);
        switch (c) {
            case 0: {
                return rule.getPattern();
            }
            case 1: {
                return rule.getAction();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setValueAt(Object v, int r, int c) {
        Rule rule = this.rules.get(r);
        switch (c) {
            case 0: {
                rule.setPattern((String)v);
                this.fireTableCellUpdated(r, c);
                break;
            }
            case 1: {
                rule.setAction((Rule.Action)((Object)v));
                this.fireTableCellUpdated(r, c);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return true;
    }
}

