/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import net.sf.profiler4j.agent.Agent;
import net.sf.profiler4j.agent.Config;
import net.sf.profiler4j.agent.Log;
import net.sf.profiler4j.agent.ServerUtil;
import net.sf.profiler4j.agent.ThreadProfiler;
import net.sf.profiler4j.agent.Transformer;

class Server
extends Thread {
    private Config config;

    public Server(Config config) {
        super("P4J_SERVER");
        this.config = config;
        this.setDaemon(true);
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block9: while (true) {
            try {
                try {
                    while (true) {
                        Log.print(0, "Listening on port " + this.config.getPort() + "...");
                        ServerSocket srv = new ServerSocket(this.config.getPort());
                        Socket s = srv.accept();
                        Log.print(0, "Serving connection from " + s.getRemoteSocketAddress());
                        try {
                            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(s.getOutputStream()));
                            out.writeUTF("(SC integrated)");
                            out.flush();
                            ObjectInputStream in = new ObjectInputStream(s.getInputStream());
                            this.serveClient(in, out);
                            Thread.sleep(250L);
                        }
                        catch (SocketException e) {
                            if (e.getMessage().equals("Connection reset")) {
                                Log.print(0, "Connection closed by client");
                            } else {
                                Log.print(0, "Socket I/O error", e);
                            }
                        }
                        catch (Exception any) {
                            Log.print(0, "Error during request processing. Closing connection", any);
                        }
                        try {
                            if (s != null) {
                                s.close();
                            }
                            if (srv == null) continue block9;
                            srv.close();
                            continue block9;
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    Log.print(0, "Server exception", e);
                    if (this.config.isExitVmOnFailure()) {
                        Log.print(0, "Aborting JVM...");
                        System.exit(3);
                    }
                    Log.print(0, "Server exiting");
                    break;
                }
            }
            catch (Throwable throwable) {
                Log.print(0, "Server exiting");
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveClient(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            switch (in.readInt()) {
                case 1: {
                    System.gc();
                    out.writeInt(0);
                    out.flush();
                    break;
                }
                case 2: {
                    out.writeInt(0);
                    ThreadProfiler.createSnapshot(out);
                    out.flush();
                    break;
                }
                case 3: {
                    ThreadProfiler.resetStats();
                    out.writeInt(0);
                    out.flush();
                    break;
                }
                case 5: {
                    out.writeInt(0);
                    out.flush();
                    String opts = in.readUTF();
                    String rules = in.readUTF();
                    final int[] progress = new int[1];
                    Transformer.Callback callback = new Transformer.Callback(){

                        public void notifyClassTransformed(String className, int backSequence, int bachSize) {
                            progress[0] = backSequence;
                        }
                    };
                    int n = Agent.startNewSession(opts, rules, callback);
                    out.writeInt(n);
                    out.flush();
                    while (progress[0] < n) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        out.writeInt(progress[0]);
                        out.flush();
                    }
                    out.writeInt(-1);
                    out.flush();
                    Object e = Agent.waitConnectionLock;
                    synchronized (e) {
                        Agent.waitConnectionLock.notifyAll();
                        break;
                    }
                }
                case 6: {
                    out.writeInt(0);
                    Class[] classes = Agent.getLoadedClasses(true);
                    out.writeInt(classes.length);
                    Set<String> set = Agent.modifiedClassNames;
                    synchronized (set) {
                        for (int i = 0; i < classes.length; ++i) {
                            out.writeUTF(classes[i].getName());
                            boolean instrumented = Agent.modifiedClassNames.contains(classes[i].getName());
                            out.writeBoolean(instrumented);
                        }
                    }
                    out.flush();
                    break;
                }
                case 7: {
                    out.writeInt(0);
                    out.writeUTF(Agent.rtbean.getBootClassPath());
                    out.writeUTF(Agent.rtbean.getClassPath());
                    ServerUtil.writeStringList(out, Agent.rtbean.getInputArguments());
                    out.writeUTF(Agent.rtbean.getLibraryPath());
                    out.writeUTF(Agent.rtbean.getName());
                    out.writeUTF(Agent.rtbean.getVmName());
                    out.writeLong(Agent.rtbean.getStartTime());
                    out.writeLong(Agent.rtbean.getUptime());
                    ServerUtil.writeStringMap(out, Agent.rtbean.getSystemProperties());
                    out.flush();
                    break;
                }
                case 8: {
                    out.writeInt(0);
                    ServerUtil.writeMemoryUsage(out, Agent.membean.getHeapMemoryUsage());
                    ServerUtil.writeMemoryUsage(out, Agent.membean.getNonHeapMemoryUsage());
                    out.writeInt(Agent.membean.getObjectPendingFinalizationCount());
                    out.flush();
                    break;
                }
                case 9: {
                    out.writeInt(0);
                    out.flush();
                    long[] ids = (long[])in.readUnshared();
                    int maxDepth = in.readInt();
                    ids = ids == null ? Agent.threadbean.getAllThreadIds() : ids;
                    out.writeUnshared(ServerUtil.makeSerializable(Agent.threadbean.getThreadInfo(ids, maxDepth)));
                    out.flush();
                    break;
                }
                case 10: {
                    boolean[] flags = (boolean[])in.readUnshared();
                    boolean[] support = new boolean[]{Agent.threadbean.isThreadContentionMonitoringSupported(), Agent.threadbean.isThreadCpuTimeSupported()};
                    if (support[0]) {
                        Agent.threadbean.setThreadContentionMonitoringEnabled(flags[0]);
                    }
                    if (support[1]) {
                        Agent.threadbean.setThreadCpuTimeEnabled(flags[1]);
                    }
                    out.writeUnshared(support);
                    out.flush();
                    break;
                }
                case 4: {
                    out.writeInt(0);
                    out.flush();
                    return;
                }
                default: {
                    out.writeInt(2);
                }
            }
        }
    }
}

