/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Owned;
import javax.media.control.FormatControl;
import javax.media.control.QualityControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractPacketizer;
import net.sf.fmj.media.codec.video.jpeg.JpegRTPHeader;
import net.sf.fmj.media.codec.video.jpeg.JpegStripper;
import net.sf.fmj.media.codec.video.jpeg.RFC2035;
import net.sf.fmj.media.util.BufferToImage;
import net.sf.fmj.utility.ArrayUtility;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Packetizer
extends AbstractPacketizer {
    int j = 0;
    private byte typeSpecific = 0;
    private byte type = 1;
    private int quality = 75;
    private int currentQuality;
    private ImageWriter encoder;
    private JPEGHuffmanTable[] huffmanDCTables;
    private JPEGHuffmanTable[] huffmanACTables;
    private JPEGImageWriteParam param;
    private int dri = 0;
    private Buffer temporary = new Buffer();
    private ByteArrayOutputStream os = new ByteArrayOutputStream();
    private MemoryCacheImageOutputStream out = new MemoryCacheImageOutputStream(this.os);
    private int[] lumaQtable = RFC2035.jpeg_luma_quantizer_normal;
    private int[] chromaQtable = RFC2035.jpeg_chroma_quantizer_normal;
    private static final Logger logger = Logger.getLogger(Packetizer.class.getName());
    private BufferToImage bufferToImage;
    private final Format[] supportedInputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, -1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1)};
    private final Format[] supportedOutputFormats = new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)};
    private static final int PACKET_SIZE = 1000;
    private JPEGQTable[] qtable;
    private static final int RTP_JPEG_RESTART = 64;
    private Format outputVideoFormat;
    private VideoFormat currentFormat;
    private BufferedImage offscreenImage;
    private Graphics imageGraphics;
    private Buffer imageBuffer = new Buffer();

    private static Node createDri(Node n, int interval) {
        IIOMetadataNode dri = new IIOMetadataNode("dri");
        dri.setAttribute("interval", Integer.toString(interval));
        NodeList nl = n.getChildNodes();
        nl.item(1).insertBefore(dri, nl.item(1).getFirstChild());
        return n;
    }

    private static Node find(Node n, String s) {
        int i;
        String[] names = s.split("/");
        String[] current = names[0].split(":");
        if (names == null) {
            return null;
        }
        if (names.length == 1) {
            return n;
        }
        String newS = "";
        for (i = 1; i < names.length; ++i) {
            newS = newS + names[i] + (i == names.length - 1 ? "" : "/");
        }
        if (n.getNodeName().equalsIgnoreCase(current[0]) && (current.length <= 1 || current[1].equalsIgnoreCase(n.getNodeValue()))) {
            return Packetizer.find(n, newS);
        }
        for (i = 0; i < n.getChildNodes().getLength(); ++i) {
            Node child = n.getChildNodes().item(i);
            if (!child.getNodeName().equalsIgnoreCase(names[0]) || current.length > 1 && !current[1].equalsIgnoreCase(n.getNodeValue())) continue;
            return Packetizer.find(child, newS);
        }
        return null;
    }

    private static void outputMetadata(Node node, String delimiter) {
        System.out.println(delimiter + node.getNodeName());
        delimiter = "  " + delimiter;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.hasChildNodes()) {
                Packetizer.outputMetadata(n, delimiter);
            }
            System.out.println(delimiter + n.getNodeName());
            if (!list.item(i).hasAttributes()) continue;
            NamedNodeMap nnm = list.item(i).getAttributes();
            String ndel = "  " + delimiter + "-A:";
            for (int j = 0; j < nnm.getLength(); ++j) {
                System.out.println(ndel + nnm.item(j).getNodeName() + ":" + nnm.item(j).getNodeValue());
            }
        }
    }

    private static Node setSamplingFactor(Node n, int hSampleFactor, int vSampleFactor) {
        Node markerSeq = n.getChildNodes().item(1);
        Node lookingfor = Packetizer.find(markerSeq, "markerSequence/sof/componentSpec/HsamplingFactor:1");
        lookingfor.getAttributes().getNamedItem("HsamplingFactor").setNodeValue(Integer.toString(hSampleFactor));
        lookingfor.getAttributes().getNamedItem("VsamplingFactor").setNodeValue(Integer.toString(vSampleFactor));
        return n;
    }

    public Packetizer() {
        this.inputFormats = this.supportedInputFormats;
        this.addControl(new JPEGQualityControl());
        this.addControl(new FC());
    }

    public void close() {
        try {
            this.out.close();
            this.os.close();
            this.encoder.dispose();
        }
        catch (IOException e) {
            logger.throwing(this.getClass().getName(), "close", e.getCause());
        }
    }

    private JPEGHuffmanTable[] createACHuffmanTables() {
        JPEGHuffmanTable acChm = new JPEGHuffmanTable(RFC2035.chm_ac_codelens, RFC2035.chm_ac_symbols);
        JPEGHuffmanTable acLum = new JPEGHuffmanTable(RFC2035.lum_ac_codelens, RFC2035.lum_ac_symbols);
        JPEGHuffmanTable[] result = new JPEGHuffmanTable[]{acLum, acChm};
        return result;
    }

    private JPEGHuffmanTable[] createDCHuffmanTables() {
        JPEGHuffmanTable dcChm = new JPEGHuffmanTable(RFC2035.chm_dc_codelens, RFC2035.chm_dc_symbols);
        JPEGHuffmanTable dcLum = new JPEGHuffmanTable(RFC2035.lum_dc_codelens, RFC2035.lum_dc_symbols);
        JPEGHuffmanTable[] result = new JPEGHuffmanTable[]{dcLum, dcChm};
        return result;
    }

    private JPEGQTable[] createQTable(int q) {
        byte[] lumQ = new byte[64];
        byte[] chmQ = new byte[64];
        RFC2035.MakeTables(q, lumQ, chmQ, RFC2035.jpeg_luma_quantizer_normal, RFC2035.jpeg_chroma_quantizer_normal);
        JPEGQTable qtable_luma = new JPEGQTable(ArrayUtility.byteArrayToIntArray(lumQ));
        JPEGQTable qtable_chroma = new JPEGQTable(ArrayUtility.byteArrayToIntArray(chmQ));
        JPEGQTable[] result = new JPEGQTable[]{qtable_luma, qtable_chroma};
        return result;
    }

    protected int doBuildPacketHeader(Buffer inputBuffer, byte[] packetBuffer) {
        VideoFormat format = (VideoFormat)this.inputFormat;
        int width = format.getSize().width;
        int height = format.getSize().height;
        int length = 0;
        if (null != this.currentFormat) {
            width = this.currentFormat.getSize().width;
            height = this.currentFormat.getSize().height;
        }
        byte widthInBlocks = (byte)(width / 8);
        byte heightInBlocks = (byte)(height / 8);
        JpegRTPHeader jpegRTPHeader = new JpegRTPHeader(this.typeSpecific, inputBuffer.getOffset(), this.type, (byte)this.currentQuality, widthInBlocks, heightInBlocks);
        byte[] bytes = jpegRTPHeader.toBytes();
        System.arraycopy(bytes, 0, packetBuffer, length, bytes.length);
        return length += bytes.length;
    }

    private void dump(byte[] data, int length) {
        int index = 0;
        while (index < length) {
            String aString = "";
            for (int i = 0; i < 16; ++i) {
                String s = Integer.toHexString(data[index++] & 0xFF);
                aString = aString + (s.length() < 2 ? "0" + s : s);
                aString = aString + " ";
                if (index >= length) break;
            }
            System.out.println(aString);
        }
        System.out.println(" ");
    }

    public String getName() {
        return "JPEG/RTP Packetizer";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat inputCast = (VideoFormat)input;
        Format[] result = new Format[]{new VideoFormat("jpeg/rtp", inputCast.getSize(), -1, Format.byteArray, -1.0f)};
        return result;
    }

    public void open() {
        this.setPacketSize(1000);
        this.setDoNotSpanInputBuffers(true);
        this.temporary.setOffset(0);
        this.encoder = ImageIO.getImageWritersByFormatName("JPEG").next();
        this.param = new JPEGImageWriteParam(null);
        this.huffmanACTables = this.createACHuffmanTables();
        this.huffmanDCTables = this.createDCHuffmanTables();
        this.qtable = this.createQTable(this.quality);
        this.param.setEncodeTables(this.qtable, this.huffmanDCTables, this.huffmanACTables);
        try {
            this.encoder.setOutput(this.out);
            this.encoder.prepareWriteSequence(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer input, Buffer output) {
        if (!this.checkInputBuffer(input)) {
            return 1;
        }
        if (this.isEOM(input)) {
            this.propagateEOM(output);
            return 0;
        }
        BufferedImage image = (BufferedImage)this.bufferToImage.createImage(input);
        try {
            int result;
            if (this.temporary.getLength() == 0) {
                this.currentQuality = this.quality;
                this.currentFormat = (VideoFormat)this.outputVideoFormat;
                if (null != this.currentFormat && input.getFormat() instanceof RGBFormat) {
                    int width = this.currentFormat.getSize().width;
                    int height = this.currentFormat.getSize().height;
                    Buffer buffer = this.imageBuffer;
                    synchronized (buffer) {
                        if (null == this.offscreenImage) {
                            byte[] tempData = new byte[width * height * 3];
                            RGBFormat videoFormat = (RGBFormat)input.getFormat();
                            RGBFormat newVideoFormat = new RGBFormat(new Dimension(width, height), -1, null, -1.0f, -1, -1, -1, -1, -1, width * videoFormat.getPixelStride(), -1, -1);
                            RGBFormat vf = (RGBFormat)newVideoFormat.intersects(videoFormat);
                            this.imageBuffer.setData(tempData);
                            this.imageBuffer.setLength(tempData.length);
                            this.imageBuffer.setFormat(vf);
                            this.offscreenImage = (BufferedImage)this.bufferToImage.createImage(this.imageBuffer);
                            this.imageGraphics = this.offscreenImage.getGraphics();
                        }
                    }
                    this.imageGraphics.drawImage(image, 0, 0, width, height, null);
                    image = this.offscreenImage;
                }
                this.os.reset();
                this.param.setCompressionMode(2);
                this.param.setCompressionQuality((float)this.currentQuality / 100.0f);
                this.encoder.write(null, new IIOImage(image, null, null), this.param);
                byte[] ba = this.os.toByteArray();
                ba = JpegStripper.removeHeaders(ba);
                this.temporary.setData(ba);
                this.temporary.setLength(ba.length);
            }
            if ((result = super.process(this.temporary, output)) == 0) {
                this.temporary.setOffset(0);
                output.setFlags(output.getFlags() | 0x800);
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            output.setDiscard(true);
            output.setLength(0);
            return 1;
        }
    }

    public Format setInputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        if (videoFormat.getSize() == null) {
            return null;
        }
        this.bufferToImage = new BufferToImage((VideoFormat)format);
        return super.setInputFormat(format);
    }

    private void setType(int typeValue) {
        this.type = (byte)(typeValue | (this.dri != 0 ? 64 : 0));
    }

    static /* synthetic */ JPEGQTable[] access$502(Packetizer x0, JPEGQTable[] x1) {
        x0.qtable = x1;
        return x1;
    }

    class JPEGQualityControl
    implements QualityControl,
    Owned {
        JPEGQualityControl() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return Packetizer.this;
        }

        public float getPreferredQuality() {
            return 0.75f;
        }

        public float getQuality() {
            return (float)Packetizer.this.quality / 100.0f;
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return true;
        }

        public float setQuality(float newQuality) {
            Packetizer.this.quality = Math.round(newQuality * 100.0f);
            if (Packetizer.this.quality > 99) {
                Packetizer.this.quality = 99;
            } else if (Packetizer.this.quality < 1) {
                Packetizer.this.quality = 1;
            }
            Packetizer.access$502(Packetizer.this, Packetizer.this.createQTable(Packetizer.this.quality));
            Packetizer.this.param.setEncodeTables(Packetizer.this.qtable, Packetizer.this.huffmanDCTables, Packetizer.this.huffmanACTables);
            return Packetizer.this.quality;
        }
    }

    private class FC
    implements FormatControl,
    Owned {
        private FC() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Format getFormat() {
            return Packetizer.this.outputVideoFormat;
        }

        public Object getOwner() {
            return Packetizer.this;
        }

        public Format[] getSupportedFormats() {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean enabled) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Format setFormat(Format format) {
            Packetizer.this.outputVideoFormat = format;
            Buffer buffer = Packetizer.this.imageBuffer;
            synchronized (buffer) {
                Packetizer.this.offscreenImage = null;
                Packetizer.this.imageGraphics = null;
            }
            return Packetizer.this.outputVideoFormat;
        }
    }
}

