/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rv.RvSessionListener;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.CapabilityManager;
import net.kano.joustsim.oscar.DefaultEnabledCapabilityHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousCapabilityHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.IncomingDirectimConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.OutgoingDirectimConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingFileTransferImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.NewIncomingConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingFileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingFileTransferImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionEventListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionManagerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;

public class RvConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(RvConnectionManager.class.getName());
    private final IcbmService service;
    private CopyOnWriteArrayList<RvConnectionManagerListener> listeners = new CopyOnWriteArrayList();
    private RvConnectionEventListener incomingListener = new RvConnectionEventListener(){

        public void handleEventWithStateChange(RvConnection transfer, RvConnectionState state, RvConnectionEvent event) {
        }

        public void handleEvent(RvConnection transfer, RvConnectionEvent event) {
            if (event instanceof NewIncomingConnectionEvent) {
                NewIncomingConnectionEvent incomingev = (NewIncomingConnectionEvent)event;
                RvConnectionManager.this.fireNewIncomingConnection(incomingev.getConnection());
            }
        }
    };

    public RvConnectionManager(IcbmService service) {
        assert (service != null);
        this.service = service;
        CapabilityManager capMgr = service.getAimConnection().getCapabilityManager();
        capMgr.setCapabilityHandler(CapabilityBlock.BLOCK_FILE_SEND, new FileTransferCapabilityHandler());
        capMgr.setCapabilityHandler(CapabilityBlock.BLOCK_DIRECTIM, new DirectImCapabilityHandler());
    }

    public IcbmService getIcbmService() {
        return this.service;
    }

    public OutgoingFileTransfer createOutgoingFileTransfer(Screenname sn) {
        RvSession session = this.createSession(sn);
        AimConnection conn = this.getIcbmService().getAimConnection();
        OutgoingFileTransferImpl outgoingFileTransfer = new OutgoingFileTransferImpl(conn.getProxy(), conn.getScreenname(), session);
        session.addListener((RvSessionListener)outgoingFileTransfer.getRvSessionHandler());
        return outgoingFileTransfer;
    }

    public OutgoingDirectimConnectionImpl openDirectimConnection(Screenname sn) {
        RvSession session = this.createSession(sn);
        AimConnection conn = this.getIcbmService().getAimConnection();
        OutgoingDirectimConnectionImpl conno = new OutgoingDirectimConnectionImpl(conn.getProxy(), conn.getScreenname(), session);
        session.addListener((RvSessionListener)conno.getRvSessionHandler());
        return conno;
    }

    private RvSession createSession(Screenname sn) {
        return this.service.getRvProcessor().createRvSession(sn.getFormatted());
    }

    public void addConnectionManagerListener(RvConnectionManagerListener listener) {
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        this.listeners.addIfAbsent((Object)listener);
    }

    public void removeConnectionManagerListener(RvConnectionManagerListener listener) {
        DefensiveTools.checkNull((Object)listener, (String)"listener");
        this.listeners.remove((Object)listener);
    }

    private void fireNewIncomingConnection(IncomingRvConnection transfer) {
        assert (!Thread.holdsLock(this));
        for (RvConnectionManagerListener listener : this.listeners) {
            listener.handleNewIncomingConnection(this, transfer);
        }
    }

    private class DirectImCapabilityHandler
    extends DefaultEnabledCapabilityHandler
    implements RendezvousCapabilityHandler {
        private DirectImCapabilityHandler() {
        }

        public RendezvousSessionHandler handleSession(IcbmService service, RvSession session) {
            AimConnection conn = RvConnectionManager.this.getIcbmService().getAimConnection();
            IncomingDirectimConnectionImpl transfer = new IncomingDirectimConnectionImpl(conn.getProxy(), conn.getScreenname(), session);
            LOGGER.fine("Creating IncomingDirectimConnectionImpl for new session " + session);
            transfer.addEventListener(RvConnectionManager.this.incomingListener);
            return transfer.getRvSessionHandler();
        }
    }

    private class FileTransferCapabilityHandler
    extends DefaultEnabledCapabilityHandler
    implements RendezvousCapabilityHandler {
        private FileTransferCapabilityHandler() {
        }

        public RendezvousSessionHandler handleSession(IcbmService service, RvSession session) {
            AimConnection conn = RvConnectionManager.this.getIcbmService().getAimConnection();
            IncomingFileTransferImpl transfer = new IncomingFileTransferImpl(conn.getProxy(), conn.getScreenname(), session);
            LOGGER.fine("Creating IncomingFileTransferImpl for new session " + session);
            transfer.addEventListener(RvConnectionManager.this.incomingListener);
            return transfer.getRvSessionHandler();
        }
    }
}

