/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import mediathek.MediathekGui;
import mediathek.daten.Daten;
import mediathek.file.GetFile;
import mediathek.gui.MVFilter;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialog.DialogLeer;
import mediathek.gui.dialogEinstellungen.PanelBlacklist;
import mediathek.res.GetIcon;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVListeFilme;

public class MVFilterFrame
extends JFrame
implements MVFilter {
    Daten daten;
    static Point mouseDownCompCoords;
    JFrame parent;
    private int aktFilter = -1;
    public JButton jButtonFilterLoeschen;
    public JButton jButtonHilfe;
    private JButton jButtonOk;
    public JCheckBox jCheckBoxKeineAbos;
    public JCheckBox jCheckBoxKeineGesehenen;
    public JCheckBox jCheckBoxNurHd;
    private JCheckBox jCheckBoxNurNeue;
    public JComboBox<String> jComboBoxFilterSender;
    public JComboBox<String> jComboBoxFilterThema;
    public JComboBox<String> jComboBoxZeitraum;
    private JRadioButton jRadioButtonF1;
    private JRadioButton jRadioButtonF2;
    private JRadioButton jRadioButtonF3;
    private JRadioButton jRadioButtonF4;
    private JRadioButton jRadioButtonF5;
    private JRadioButton jRadioButtonIrgendwo;
    private JRadioButton jRadioButtonTT;
    public JSlider jSliderMinuten;
    public JTextField jTextFieldFilterMinuten;
    public JTextField jTextFieldFilterThemaTitel;
    public JTextField jTextFieldFilterTitel;
    private JToggleButton jToggleButtonBlacklist;
    private JToggleButton jToggleButtonHistory;
    public JToggleButton jToggleButtonLivestram;

    public MVFilterFrame(Daten d) {
        this.initComponents();
        this.parent = this;
        this.daten = d;
        if (SystemInfo.isWindows()) {
            InputMap im = this.jComboBoxFilterSender.getInputMap();
            im.put(KeyStroke.getKeyStroke(115, 0), "einstellungen");
            ActionMap am = this.jComboBoxFilterSender.getActionMap();
            am.put("einstellungen", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MVFilterFrame.this.daten.mediathekGui.showDialogPreferences();
                }
            });
            im = this.jComboBoxFilterThema.getInputMap();
            im.put(KeyStroke.getKeyStroke(115, 0), "einstellungen");
            am = this.jComboBoxFilterThema.getActionMap();
            am.put("einstellungen", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MVFilterFrame.this.daten.mediathekGui.showDialogPreferences();
                }
            });
            im = this.jComboBoxZeitraum.getInputMap();
            im.put(KeyStroke.getKeyStroke(115, 0), "einstellungen");
            am = this.jComboBoxZeitraum.getActionMap();
            am.put("einstellungen", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MVFilterFrame.this.daten.mediathekGui.showDialogPreferences();
                }
            });
        }
        mouseDownCompCoords = null;
        this.setBounds(0, 0, 400, 400);
        this.setDefaultCloseOperation(0);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                mouseDownCompCoords = null;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                mouseDownCompCoords = e.getPoint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Point currCoords = e.getLocationOnScreen();
                MVFilterFrame.this.parent.setLocation(currCoords.x - MVFilterFrame.mouseDownCompCoords.x, currCoords.y - MVFilterFrame.mouseDownCompCoords.y);
            }
        });
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MediathekGui.class.getResource("/mediathek/res/MediathekView_k.gif")));
        this.setTitle("Filter");
        GuiFunktionen.setSize("Groesse-Filter", this, (JFrame)this.daten.mediathekGui);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MVFilterFrame.this.dispose();
            }
        });
        this.jButtonFilterLoeschen.setIcon(GetIcon.getProgramIcon("clear_16.png"));
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVFilterFrame.this.dispose();
            }
        });
        this.setIconBlacklist();
        this.jToggleButtonBlacklist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Blacklist-ausgeschaltet", Boolean.toString(MVFilterFrame.this.jToggleButtonBlacklist.isSelected()));
                MVListeFilme.checkBlacklist();
                ListenerMediathekView.notify(39, MVFilterFrame.class.getSimpleName());
                MVFilterFrame.this.setIconBlacklist();
            }
        });
        this.jToggleButtonBlacklist.addMouseListener(new BeobMausBlacklist());
        ListenerMediathekView.addListener(new ListenerMediathekView(39, MVFilterFrame.class.getSimpleName()){

            @Override
            public void ping() {
                MVFilterFrame.this.setIconBlacklist();
            }
        });
        this.jButtonHilfe.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(MVFilterFrame.this.parent, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_FILTER)).setVisible(true);
            }
        });
        this.setIcon(false);
        this.jRadioButtonF1.addActionListener(new BeobRadio(0));
        this.jRadioButtonF2.addActionListener(new BeobRadio(1));
        this.jRadioButtonF3.addActionListener(new BeobRadio(2));
        this.jRadioButtonF4.addActionListener(new BeobRadio(3));
        this.jRadioButtonF5.addActionListener(new BeobRadio(4));
        this.jRadioButtonF1.addMouseListener(new BeobMaus(0));
        this.jRadioButtonF2.addMouseListener(new BeobMaus(1));
        this.jRadioButtonF3.addMouseListener(new BeobMaus(2));
        this.jRadioButtonF4.addMouseListener(new BeobMaus(3));
        this.jRadioButtonF5.addMouseListener(new BeobMaus(4));
        this.setFilterAnzahl();
        ListenerMediathekView.addListener(new ListenerMediathekView(34, MVFilterFrame.class.getSimpleName()){

            @Override
            public void ping() {
                MVFilterFrame.this.setFilterAnzahl();
            }
        });
        this.setToolTip();
        this.pack();
    }

    @Override
    public void setVisible(boolean setvisible) {
        super.setVisible(setvisible);
        this.setToolTip();
    }

    private void setToolTip() {
        if (Daten.mVConfig.get("filter-name", 0).isEmpty()) {
            this.jRadioButtonF1.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 1 speichern");
        } else {
            this.jRadioButtonF1.setToolTipText(Daten.mVConfig.get("filter-name", 0));
        }
        if (Daten.mVConfig.get("filter-name", 1).isEmpty()) {
            this.jRadioButtonF2.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 2 speichern");
        } else {
            this.jRadioButtonF2.setToolTipText(Daten.mVConfig.get("filter-name", 1));
        }
        if (Daten.mVConfig.get("filter-name", 2).isEmpty()) {
            this.jRadioButtonF3.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 3 speichern");
        } else {
            this.jRadioButtonF3.setToolTipText(Daten.mVConfig.get("filter-name", 2));
        }
        if (Daten.mVConfig.get("filter-name", 3).isEmpty()) {
            this.jRadioButtonF4.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 4 speichern");
        } else {
            this.jRadioButtonF4.setToolTipText(Daten.mVConfig.get("filter-name", 3));
        }
        if (Daten.mVConfig.get("filter-name", 4).isEmpty()) {
            this.jRadioButtonF5.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 5 speichern");
        } else {
            this.jRadioButtonF5.setToolTipText(Daten.mVConfig.get("filter-name", 4));
        }
    }

    private void setIconBlacklist() {
        if (Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-ausgeschaltet"))) {
            this.jToggleButtonBlacklist.setIcon(GetIcon.getProgramIcon("blacklist_ein_16.png"));
            this.jToggleButtonBlacklist.setSelected(true);
        } else {
            this.jToggleButtonBlacklist.setIcon(GetIcon.getProgramIcon("blacklist_aus_16.png"));
            this.jToggleButtonBlacklist.setSelected(false);
        }
    }

    private void setFilterAnzahl() {
        int i;
        try {
            i = Integer.parseInt(Daten.mVConfig.get("filter-anzahl"));
        }
        catch (Exception ex) {
            Daten.mVConfig.add("filter-anzahl", String.valueOf(3));
            i = 3;
        }
        this.jRadioButtonF2.setVisible(i >= 2);
        this.jRadioButtonF3.setVisible(i >= 3);
        this.jRadioButtonF4.setVisible(i >= 4);
        this.jRadioButtonF5.setVisible(i == 5);
    }

    private void setIcon(boolean on) {
        this.setIcon(on, -1);
    }

    private void setIcon(boolean on, int nr) {
        for (int i = 0; i < 5; ++i) {
            if (on && i == nr) {
                this.setIconOn(i);
                continue;
            }
            if (this.aktFilter == i) {
                this.setAktIcon(i);
                continue;
            }
            this.setIconOff(i);
        }
    }

    private void setIconOn(int filter) {
        switch (filter) {
            case 0: {
                this.jRadioButtonF1.setIcon(GetIcon.getProgramIcon("filter_on_1.png"));
                break;
            }
            case 1: {
                this.jRadioButtonF2.setIcon(GetIcon.getProgramIcon("filter_on_2.png"));
                break;
            }
            case 2: {
                this.jRadioButtonF3.setIcon(GetIcon.getProgramIcon("filter_on_3.png"));
                break;
            }
            case 3: {
                this.jRadioButtonF4.setIcon(GetIcon.getProgramIcon("filter_on_4.png"));
                break;
            }
            case 4: {
                this.jRadioButtonF5.setIcon(GetIcon.getProgramIcon("filter_on_5.png"));
            }
        }
    }

    private void setAktIcon(int filter) {
        switch (filter) {
            case 0: {
                this.jRadioButtonF1.setIcon(GetIcon.getProgramIcon("filter_akt_1.png"));
                break;
            }
            case 1: {
                this.jRadioButtonF2.setIcon(GetIcon.getProgramIcon("filter_akt_2.png"));
                break;
            }
            case 2: {
                this.jRadioButtonF3.setIcon(GetIcon.getProgramIcon("filter_akt_3.png"));
                break;
            }
            case 3: {
                this.jRadioButtonF4.setIcon(GetIcon.getProgramIcon("filter_akt_4.png"));
                break;
            }
            case 4: {
                this.jRadioButtonF5.setIcon(GetIcon.getProgramIcon("filter_akt_5.png"));
            }
        }
    }

    private void setIconOff(int filter) {
        switch (filter) {
            case 0: {
                this.jRadioButtonF1.setIcon(GetIcon.getProgramIcon("filter_off_1.png"));
                break;
            }
            case 1: {
                this.jRadioButtonF2.setIcon(GetIcon.getProgramIcon("filter_off_2.png"));
                break;
            }
            case 2: {
                this.jRadioButtonF3.setIcon(GetIcon.getProgramIcon("filter_off_3.png"));
                break;
            }
            case 3: {
                this.jRadioButtonF4.setIcon(GetIcon.getProgramIcon("filter_off_4.png"));
                break;
            }
            case 4: {
                this.jRadioButtonF5.setIcon(GetIcon.getProgramIcon("filter_off_5.png"));
            }
        }
    }

    @Override
    public void dispose() {
        GuiFunktionen.getSize("Groesse-Filter", this);
        Daten.mVConfig.add("Vis-Filter", Boolean.FALSE.toString());
        ListenerMediathekView.notify(23, MVFilterFrame.class.getName());
        super.dispose();
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jComboBoxZeitraum = new JComboBox();
        JLabel jLabel3 = new JLabel();
        this.jTextFieldFilterMinuten = new JTextField();
        this.jSliderMinuten = new JSlider();
        this.jToggleButtonLivestram = new JToggleButton();
        this.jCheckBoxKeineGesehenen = new JCheckBox();
        this.jCheckBoxKeineAbos = new JCheckBox();
        this.jCheckBoxNurHd = new JCheckBox();
        this.jToggleButtonHistory = new JToggleButton();
        this.jCheckBoxNurNeue = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.jComboBoxFilterSender = new JComboBox();
        JLabel jLabel4 = new JLabel();
        this.jComboBoxFilterThema = new JComboBox();
        JLabel jLabel5 = new JLabel();
        this.jTextFieldFilterTitel = new JTextField();
        this.jTextFieldFilterThemaTitel = new JTextField();
        this.jRadioButtonTT = new JRadioButton();
        this.jRadioButtonIrgendwo = new JRadioButton();
        this.jButtonHilfe = new JButton();
        this.jButtonOk = new JButton();
        this.jRadioButtonF1 = new JRadioButton();
        this.jRadioButtonF2 = new JRadioButton();
        this.jRadioButtonF3 = new JRadioButton();
        this.jRadioButtonF4 = new JRadioButton();
        this.jRadioButtonF5 = new JRadioButton();
        JLabel jLabel6 = new JLabel();
        this.jButtonFilterLoeschen = new JButton();
        this.jToggleButtonBlacklist = new JToggleButton();
        this.setDefaultCloseOperation(0);
        this.setUndecorated(true);
        this.setResizable(false);
        jPanel3.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        jPanel1.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        jLabel1.setText("Zeitraum:");
        jLabel3.setText("Mindestl\u00e4nge [min]:");
        this.jTextFieldFilterMinuten.setEditable(false);
        this.jToggleButtonLivestram.setText("Livestreams");
        this.jCheckBoxKeineGesehenen.setText("gesehene ausblenden");
        this.jCheckBoxKeineAbos.setText("Abos nicht anzeigen");
        this.jCheckBoxNurHd.setText("nur HD anzeigen");
        this.jToggleButtonHistory.setText("aktuelle History");
        this.jCheckBoxNurNeue.setText("nur neue");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxZeitraum, 0, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldFilterMinuten, -2, 34, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxNurNeue).addComponent(this.jCheckBoxNurHd).addComponent(this.jCheckBoxKeineAbos).addComponent(this.jCheckBoxKeineGesehenen).addComponent(jLabel1).addComponent(this.jSliderMinuten, -2, -1, -2).addComponent(this.jToggleButtonLivestram, -1, -1, Short.MAX_VALUE).addComponent(this.jToggleButtonHistory)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jToggleButtonHistory, this.jToggleButtonLivestram);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxZeitraum, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.jTextFieldFilterMinuten, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderMinuten, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jToggleButtonLivestram).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButtonHistory).addGap(14, 14, 14).addComponent(this.jCheckBoxKeineGesehenen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxKeineAbos).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxNurHd).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxNurNeue).addContainerGap(12, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jComboBoxZeitraum, this.jTextFieldFilterMinuten);
        jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        jLabel2.setText("Sender:");
        this.jComboBoxFilterSender.setMaximumRowCount(20);
        jLabel4.setText("Thema:");
        this.jComboBoxFilterThema.setMaximumRowCount(20);
        jLabel5.setText("Titel:");
        buttonGroup2.add(this.jRadioButtonTT);
        this.jRadioButtonTT.setSelected(true);
        this.jRadioButtonTT.setText("Thema / Titel:");
        buttonGroup2.add(this.jRadioButtonIrgendwo);
        this.jRadioButtonIrgendwo.setText("irgendwo:");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(16, 16, 16).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel5).addComponent(jLabel4).addComponent(jLabel2).addComponent(this.jRadioButtonTT).addComponent(this.jRadioButtonIrgendwo, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxFilterSender, 0, 360, Short.MAX_VALUE).addComponent(this.jComboBoxFilterThema, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldFilterTitel).addComponent(this.jTextFieldFilterThemaTitel)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jComboBoxFilterSender, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel4).addComponent(this.jComboBoxFilterThema, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.jTextFieldFilterTitel, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFilterThemaTitel, -2, -1, -2).addComponent(this.jRadioButtonTT)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonIrgendwo).addContainerGap(144, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jComboBoxFilterSender, this.jComboBoxFilterThema, this.jTextFieldFilterThemaTitel, this.jTextFieldFilterTitel);
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jButtonHilfe.setToolTipText("Hilfe");
        this.jButtonOk.setText("OK");
        buttonGroup1.add(this.jRadioButtonF1);
        this.jRadioButtonF1.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 1 speichern");
        this.jRadioButtonF1.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/filter_off_1.png")));
        buttonGroup1.add(this.jRadioButtonF2);
        this.jRadioButtonF2.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 2 speichern");
        this.jRadioButtonF2.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/filter_off_2.png")));
        buttonGroup1.add(this.jRadioButtonF3);
        this.jRadioButtonF3.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 3 speichern");
        this.jRadioButtonF3.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/filter_off_3.png")));
        buttonGroup1.add(this.jRadioButtonF4);
        this.jRadioButtonF4.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 4 speichern");
        this.jRadioButtonF4.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/filter_off_4.png")));
        buttonGroup1.add(this.jRadioButtonF5);
        this.jRadioButtonF5.setToolTipText("Filter-Einstellungen vornehmen und mit Rechtsklick als Profil 5 speichern");
        this.jRadioButtonF5.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/filter_off_5.png")));
        jLabel6.setText("Filterprofile:");
        this.jButtonFilterLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/clear_16.png")));
        this.jButtonFilterLoeschen.setToolTipText("Filter l\u00f6schen");
        this.jToggleButtonBlacklist.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/blacklist_aus_16.png")));
        this.jToggleButtonBlacklist.setToolTipText("Blacklist ein/aus (Rechtsklick um Blacklist zu bearbeiten)");
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonF1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonF2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonF3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonF4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonF5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHilfe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButtonBlacklist).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilterLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOk))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel6).addComponent(this.jRadioButtonF1).addComponent(this.jRadioButtonF2).addComponent(this.jRadioButtonF3).addComponent(this.jRadioButtonF4).addComponent(this.jRadioButtonF5).addComponent(this.jButtonOk).addComponent(this.jButtonFilterLoeschen).addComponent(this.jButtonHilfe).addComponent(this.jToggleButtonBlacklist)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel3, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel3, -2, -1, -2));
        this.pack();
    }

    @Override
    public void mvFdeleteFilter(int i) {
    }

    @Override
    public void mvFsaveFilter(int i) {
    }

    @Override
    public void mvFfilter(int i) {
    }

    @Override
    public void enableFilter(boolean enable) {
        this.jRadioButtonF1.setEnabled(enable);
        this.jRadioButtonF2.setEnabled(enable);
        this.jRadioButtonF3.setEnabled(enable);
        this.jRadioButtonF4.setEnabled(enable);
        this.jRadioButtonF5.setEnabled(enable);
    }

    @Override
    public JButton get_jButtonFilterLoeschen() {
        return this.jButtonFilterLoeschen;
    }

    @Override
    public JCheckBox get_jCheckBoxKeineAbos() {
        return this.jCheckBoxKeineAbos;
    }

    @Override
    public JCheckBox get_jCheckBoxKeineGesehenen() {
        return this.jCheckBoxKeineGesehenen;
    }

    @Override
    public JCheckBox get_jCheckBoxNurHd() {
        return this.jCheckBoxNurHd;
    }

    @Override
    public JComboBox<String> get_jComboBoxFilterSender() {
        return this.jComboBoxFilterSender;
    }

    @Override
    public boolean getThemaTitel() {
        return this.jRadioButtonTT.isSelected();
    }

    @Override
    public void setThemaTitel(boolean set) {
        this.jRadioButtonTT.setSelected(set);
        this.jRadioButtonIrgendwo.setSelected(!set);
    }

    @Override
    public JRadioButton get_jRadioButtonTT() {
        return this.jRadioButtonTT;
    }

    @Override
    public JRadioButton get_JRadioButtonIrgendwo() {
        return this.jRadioButtonIrgendwo;
    }

    @Override
    public JComboBox<String> get_jComboBoxFilterThema() {
        return this.jComboBoxFilterThema;
    }

    @Override
    public JComboBox<String> get_jComboBoxZeitraum() {
        return this.jComboBoxZeitraum;
    }

    @Override
    public JSlider get_jSliderMinuten() {
        return this.jSliderMinuten;
    }

    @Override
    public JTextField get_jTextFieldFilterMinuten() {
        return this.jTextFieldFilterMinuten;
    }

    @Override
    public JTextField get_jTextFieldFilterThemaTitel() {
        return this.jTextFieldFilterThemaTitel;
    }

    @Override
    public JTextField get_jTextFieldFilterTitel() {
        return this.jTextFieldFilterTitel;
    }

    @Override
    public JToggleButton get_jToggleButtonLivestram() {
        return this.jToggleButtonLivestram;
    }

    @Override
    public JCheckBox get_jCheckBoxNeue() {
        return this.jCheckBoxNurNeue;
    }

    @Override
    public JToggleButton get_jToggleButtonHistory() {
        return this.jToggleButtonHistory;
    }

    @Override
    public void removeAllListener() {
        this.aktFilter = -1;
        this.setIcon(false);
        for (ActionListener actionListener : this.jButtonFilterLoeschen.getActionListeners()) {
            this.jButtonFilterLoeschen.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.jCheckBoxKeineAbos.getActionListeners()) {
            this.jCheckBoxKeineAbos.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.jCheckBoxKeineGesehenen.getActionListeners()) {
            this.jCheckBoxKeineGesehenen.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.jCheckBoxNurHd.getActionListeners()) {
            this.jCheckBoxNurHd.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.jComboBoxFilterSender.getActionListeners()) {
            this.jComboBoxFilterSender.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.jComboBoxFilterThema.getActionListeners()) {
            this.jComboBoxFilterThema.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.jComboBoxZeitraum.getActionListeners()) {
            this.jComboBoxZeitraum.removeActionListener(actionListener);
        }
        for (EventListener eventListener : this.jSliderMinuten.getChangeListeners()) {
            this.jSliderMinuten.removeChangeListener((ChangeListener)eventListener);
        }
        for (EventListener eventListener : this.jTextFieldFilterMinuten.getActionListeners()) {
            this.jTextFieldFilterMinuten.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : this.jTextFieldFilterThemaTitel.getActionListeners()) {
            this.jTextFieldFilterThemaTitel.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : this.jTextFieldFilterTitel.getActionListeners()) {
            this.jTextFieldFilterTitel.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : this.jToggleButtonLivestram.getActionListeners()) {
            this.jToggleButtonLivestram.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : this.jCheckBoxNurNeue.getActionListeners()) {
            this.jCheckBoxNurNeue.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : this.jToggleButtonHistory.getActionListeners()) {
            this.jToggleButtonHistory.removeActionListener((ActionListener)eventListener);
        }
    }

    public class BeobMausBlacklist
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Blacklist bearbeiten");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogLeer dialog = new DialogLeer((Frame)MVFilterFrame.this.parent, true);
                    dialog.init("Blacklist", new PanelBlacklist(MVFilterFrame.this.daten, MVFilterFrame.this.parent, PanelBlacklist.class.getName() + "_4"));
                    dialog.setVisible(true);
                }
            });
            jPopupMenu.add(item);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public class BeobMaus
    extends MouseAdapter {
        int filter;
        JRadioButtonMenuItem r1 = new JRadioButtonMenuItem("Blacklist f\u00fcr Filter einschalten");
        JRadioButtonMenuItem r2 = new JRadioButtonMenuItem("Blacklist f\u00fcr Filter ausschalten");

        public BeobMaus(int f) {
            this.filter = f;
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            MVFilterFrame.this.setIcon(true, this.filter);
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            MVFilterFrame.this.setIcon(false);
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            int i;
            final JPopupMenu jPopupMenu = new JPopupMenu();
            final JTextField name = new JTextField("");
            JPanel pName = new JPanel(new FlowLayout());
            JLabel lbl = new JLabel("Name: ");
            name.setMinimumSize(new Dimension(100, name.getMinimumSize().height));
            name.setPreferredSize(new Dimension(150, name.getPreferredSize().height));
            name.setText(Daten.mVConfig.get("filter-name", this.filter));
            name.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Daten.mVConfig.add("filter-name", name.getText(), BeobMaus.this.filter, 5);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    Daten.mVConfig.add("filter-name", name.getText(), BeobMaus.this.filter, 5);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Daten.mVConfig.add("filter-name", name.getText(), BeobMaus.this.filter, 5);
                }
            });
            name.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    jPopupMenu.setVisible(false);
                }
            });
            pName.add(lbl);
            pName.add(name);
            jPopupMenu.add(pName);
            jPopupMenu.addSeparator();
            JMenuItem item = new JMenuItem("Filterprofil speichern");
            item.setIcon(GetIcon.getProgramIcon("filter_speichern_16.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MVFilterFrame.this.mvFsaveFilter(BeobMaus.this.filter);
                }
            });
            jPopupMenu.add(item);
            item = new JMenuItem("Filterprofil l\u00f6schen");
            item.setIcon(GetIcon.getProgramIcon("filter_loeschen_16.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MVFilterFrame.this.mvFdeleteFilter(BeobMaus.this.filter);
                }
            });
            jPopupMenu.add(item);
            jPopupMenu.addSeparator();
            ButtonGroup bG = new ButtonGroup();
            bG.add(this.r1);
            bG.add(this.r2);
            jPopupMenu.add(this.r1);
            jPopupMenu.add(this.r2);
            if (Boolean.parseBoolean(Daten.mVConfig.get("filter-blacklist-aus", this.filter))) {
                this.r1.setSelected(true);
            } else {
                this.r2.setSelected(true);
            }
            this.r1.addActionListener(new BeobRa(this.filter));
            this.r2.addActionListener(new BeobRa(this.filter));
            jPopupMenu.addSeparator();
            JPanel p = new JPanel(new FlowLayout());
            final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 5, 1));
            try {
                i = Integer.parseInt(Daten.mVConfig.get("filter-anzahl"));
            }
            catch (Exception ex) {
                Daten.mVConfig.add("filter-anzahl", String.valueOf(3));
                i = 3;
            }
            jSpinner.setValue(i);
            jSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Daten.mVConfig.add("filter-anzahl", String.valueOf(((Number)jSpinner.getModel().getValue()).intValue()));
                    MVFilterFrame.this.setFilterAnzahl();
                    ListenerMediathekView.notify(34, MVFilterFrame.class.getSimpleName());
                }
            });
            JLabel label = new JLabel("Anzahl Filter anzeigen:");
            p.add(label);
            p.add(jSpinner);
            jPopupMenu.add(p);
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    MVFilterFrame.this.setIcon(false);
                    MVFilterFrame.this.setToolTip();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    MVFilterFrame.this.setIcon(false);
                    MVFilterFrame.this.setToolTip();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobRa
        implements ActionListener {
            int filter;

            public BeobRa(int f) {
                this.filter = f;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BeobMaus.this.r1.isSelected()) {
                    Daten.mVConfig.add("filter-blacklist-aus", Boolean.TRUE.toString(), this.filter, 5);
                } else if (BeobMaus.this.r2.isSelected()) {
                    Daten.mVConfig.add("filter-blacklist-aus", Boolean.FALSE.toString(), this.filter, 5);
                }
            }
        }
    }

    private class BeobRadio
    implements ActionListener {
        int filter;

        public BeobRadio(int f) {
            this.filter = f;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MVFilterFrame.this.aktFilter = this.filter;
            MVFilterFrame.this.mvFfilter(this.filter);
        }
    }
}

