/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import com.jidesoft.utils.SystemInfo;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import mediathek.MediathekGui;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.MVStatusBar;
import mediathek.gui.PanelInfoStarts;
import mediathek.gui.dialogEinstellungen.PanelFilmlisten;
import mediathek.tool.Duration;
import mediathek.tool.ListenerMediathekView;
import msearch.daten.DatenFilm;
import msearch.daten.ListeFilme;
import msearch.filmlisten.MSFilmlisteLesen;

public class GuiDebug
extends JPanel {
    private final JButton[] buttonSender;
    private final String[] sender;
    private Daten daten;
    private JButton jButtonAllesSpeichern;
    private JButton jButtonCheck;
    private JButton jButtonCheckUrl;
    private JButton jButtonClean;
    private JButton jButtonDir;
    private JButton jButtonDoppelteUrls;
    private JButton jButtonFehler;
    private JButton jButtonFilmlisteLoeschen;
    private JButton jButtonGc;
    private JButton jButtonNeuLaden;
    private JButton jButtonOld;
    private JButton jButtonSearchUrl;
    private JButton jButtonSize;
    private JButton jButtonTest;
    private JPanel jPanelFilmlisteLaden;
    private JPanel jPanelLoeschen;
    private JPanel jPanelStarts;
    private JTextField jTextFieldOld;
    private JTextField jTextFieldPath;
    private JTextField jTextFieldSearchUrl;
    private JTextField jTextFieldUrl;
    private JToggleButton jToggleButtonFastAuto;

    public GuiDebug(Daten d) {
        this.initComponents();
        this.daten = d;
        this.sender = Daten.filmeLaden.getSenderNamen();
        this.buttonSender = new JButton[this.sender.length];
        this.jPanelFilmlisteLaden.setLayout(new GridLayout(1, 1));
        this.jPanelFilmlisteLaden.add(new PanelFilmlisten(d, this.daten.mediathekGui));
        this.jPanelStarts.setLayout(new GridLayout(1, 1));
        this.jPanelStarts.add(new PanelInfoStarts());
        for (int i = 0; i < Daten.filmeLaden.getSenderNamen().length; ++i) {
            this.buttonSender[i] = new JButton(this.sender[i]);
            this.buttonSender[i].addActionListener(new BeobSenderLoeschen(this.sender[i]));
        }
        this.addSender();
        this.jButtonNeuLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.listeFilme.clear();
                Duration duration = new Duration(MediathekGui.class.getSimpleName());
                duration.ping("Start");
                new MSFilmlisteLesen().readFilmListe(Daten.getDateiFilmliste(), Daten.listeFilme, Integer.parseInt(Daten.mVConfig.get("system-anz-tage-filmilste")));
                duration.ping("Fertig");
                Daten.listeFilme.themenLaden();
                Daten.listeAbo.setAboFuerFilm(Daten.listeFilme, false);
                ListenerMediathekView.notify(5, MediathekGui.class.getSimpleName());
            }
        });
        this.jButtonAllesSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiDebug.this.daten.allesSpeichern();
                Daten.filmlisteSpeichern();
            }
        });
        this.jButtonFilmlisteLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.listeFilme.clear();
                ListenerMediathekView.notify(5, MediathekGui.class.getSimpleName());
            }
        });
        this.jButtonFehler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.printEndeMeldung();
            }
        });
        this.jButtonCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.listeFilme.check();
            }
        });
        this.jButtonCheckUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long l = 0L;
                try {
                    URLConnection co = new URL(GuiDebug.this.jTextFieldUrl.getText()).openConnection();
                    l = co.getContentLengthLong();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.out.println("Byte: " + l);
            }
        });
        this.jButtonGc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.listeFilme.cleanList();
            }
        });
        this.jToggleButtonFastAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (GuiDebug.this.jToggleButtonFastAuto.isSelected()) {
                    MSFilmlisteLesen.setWorkMode((MSFilmlisteLesen.WorkMode)MSFilmlisteLesen.WorkMode.FASTAUTO);
                } else {
                    MSFilmlisteLesen.setWorkMode((MSFilmlisteLesen.WorkMode)MSFilmlisteLesen.WorkMode.NORMAL);
                }
            }
        });
        this.jButtonDir.addActionListener(new BeobPfad());
        this.jButtonSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = GuiDebug.this.jTextFieldPath.getText();
                try {
                    System.out.println("");
                    System.out.println("=============================");
                    File file = new File(path);
                    long i = file.getFreeSpace();
                    System.out.println("getFreeSpace " + i);
                    System.out.println(" " + i / 1000L / 1000L / 1000L);
                    i = file.getTotalSpace();
                    System.out.println("=============================");
                    System.out.println("getTotalSpace " + i);
                    System.out.println(" " + i / 1000L / 1000L / 1000L);
                    i = file.getUsableSpace();
                    System.out.println("=============================");
                    System.out.println("getUsableSpace " + i);
                    System.out.println(" " + i / 1000L / 1000L / 1000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.jButtonSearchUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GuiDebug.this.jTextFieldSearchUrl.getText().isEmpty()) {
                    ((GuiDebug)GuiDebug.this).daten.guiFilme.searchUrl(GuiDebug.this.jTextFieldSearchUrl.getText());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ((GuiDebug)GuiDebug.this).daten.mediathekGui.setToolbar("");
                ((GuiDebug)GuiDebug.this).daten.mediathekGui.getStatusBar().setIndexForLeftDisplay(MVStatusBar.StatusbarIndex.FILME);
            }
        });
        this.jButtonTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> liste = new ArrayList<String>();
                for (DatenFilm film : Daten.listeFilme) {
                    film.arr[14] = GuiDebug.this.getHost(film.arr[12]);
                    if (liste.contains(film.arr[14])) continue;
                    liste.add(film.arr[14]);
                }
                ListenerMediathekView.notify(5, MediathekGui.class.getSimpleName());
                for (String s : liste) {
                    System.out.println(s);
                }
            }
        });
        this.jButtonDoppelteUrls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeFilme listeFilme = new ListeFilme();
                ArrayList<String> listUrl = new ArrayList<String>();
                for (DatenFilm film : Daten.listeFilme) {
                    if (listUrl.contains(film.arr[12])) continue;
                    listeFilme.add((Object)film);
                    listUrl.add(film.arr[12]);
                }
                System.out.println("---------------------");
                System.out.println("vorher: " + Daten.listeFilme.size());
                Daten.listeFilme = listeFilme;
                System.out.println("danach: " + Daten.listeFilme.size());
                Daten.filmlisteSpeichern();
            }
        });
        this.jButtonOld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = GuiDebug.this.jTextFieldOld.getText();
                ListeFilme tmpListe = new ListeFilme();
                new MSFilmlisteLesen().readFilmListe(url, tmpListe, 0);
                Daten.listeFilme.updateListeOld(tmpListe);
                tmpListe.clear();
                System.gc();
                Daten.listeFilme.sort();
                ListenerMediathekView.notify(5, MediathekGui.class.getSimpleName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHost(String uurl) {
        String host = "";
        try {
            try {
                URL url;
                String tmp;
                if (uurl.startsWith("rtmpt:")) {
                    uurl = uurl.toLowerCase().replace("rtmpt:", "http:");
                }
                if (uurl.startsWith("rtmp:")) {
                    uurl = uurl.toLowerCase().replace("rtmp:", "http:");
                }
                if (uurl.startsWith("mms:")) {
                    uurl = uurl.toLowerCase().replace("mms:", "http:");
                }
                if ((tmp = (url = new URL(uurl)).getHost()).contains(".")) {
                    host = tmp.substring(tmp.lastIndexOf(46));
                    host = (tmp = tmp.substring(0, tmp.lastIndexOf(46))).contains(".") ? tmp.substring(tmp.lastIndexOf(46) + 1) + host : (tmp.contains("/") ? tmp.substring(tmp.lastIndexOf(47) + 1) + host : "host");
                }
            }
            catch (Exception ex) {
                host = "host";
            }
            finally {
                if (host.equals("")) {
                    host = "host";
                }
            }
        }
        catch (Exception ex) {
            host = "exception";
        }
        return host;
    }

    private void addSender() {
        this.jPanelLoeschen.removeAll();
        this.jPanelLoeschen.setLayout(new GridLayout(0, 5));
        int nr = 0;
        for (String aSender : this.sender) {
            JButton btn = this.buttonSender[nr];
            btn.setText(aSender);
            this.jPanelLoeschen.add(btn);
            ++nr;
        }
        this.jPanelLoeschen.repaint();
    }

    private void initComponents() {
        JTabbedPane jTabbedSender = new JTabbedPane();
        this.jPanelFilmlisteLaden = new JPanel();
        JPanel jPanelFilmliste = new JPanel();
        JPanel jPanelSender = new JPanel();
        this.jPanelLoeschen = new JPanel();
        this.jButtonFilmlisteLoeschen = new JButton();
        this.jButtonNeuLaden = new JButton();
        this.jButtonCheck = new JButton();
        this.jButtonClean = new JButton();
        JPanel jPanelTools = new JPanel();
        this.jButtonCheckUrl = new JButton();
        this.jTextFieldUrl = new JTextField();
        this.jButtonGc = new JButton();
        this.jButtonFehler = new JButton();
        this.jButtonAllesSpeichern = new JButton();
        this.jToggleButtonFastAuto = new JToggleButton();
        this.jButtonSize = new JButton();
        this.jTextFieldPath = new JTextField();
        this.jButtonDir = new JButton();
        this.jButtonSearchUrl = new JButton();
        this.jTextFieldSearchUrl = new JTextField();
        this.jButtonTest = new JButton();
        this.jButtonDoppelteUrls = new JButton();
        this.jButtonOld = new JButton();
        this.jTextFieldOld = new JTextField();
        this.jPanelStarts = new JPanel();
        GroupLayout jPanelFilmlisteLadenLayout = new GroupLayout(this.jPanelFilmlisteLaden);
        this.jPanelFilmlisteLaden.setLayout(jPanelFilmlisteLadenLayout);
        jPanelFilmlisteLadenLayout.setHorizontalGroup(jPanelFilmlisteLadenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 826, Short.MAX_VALUE));
        jPanelFilmlisteLadenLayout.setVerticalGroup(jPanelFilmlisteLadenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 489, Short.MAX_VALUE));
        jTabbedSender.addTab("Filmliste laden", this.jPanelFilmlisteLaden);
        jPanelSender.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Sender l\u00f6schen"));
        GroupLayout jPanelLoeschenLayout = new GroupLayout(this.jPanelLoeschen);
        this.jPanelLoeschen.setLayout(jPanelLoeschenLayout);
        jPanelLoeschenLayout.setHorizontalGroup(jPanelLoeschenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 35, Short.MAX_VALUE));
        jPanelLoeschenLayout.setVerticalGroup(jPanelLoeschenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 111, Short.MAX_VALUE));
        GroupLayout jPanelSenderLayout = new GroupLayout(jPanelSender);
        jPanelSender.setLayout(jPanelSenderLayout);
        jPanelSenderLayout.setHorizontalGroup(jPanelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSenderLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelLoeschen, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSenderLayout.setVerticalGroup(jPanelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSenderLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelLoeschen, -2, -1, -2).addContainerGap(240, Short.MAX_VALUE)));
        this.jButtonFilmlisteLoeschen.setText("gesamte Filmliste l\u00f6schen");
        this.jButtonNeuLaden.setText("gespeicherte Filmliste neu laden");
        this.jButtonCheck.setText("Check Filmliste");
        this.jButtonClean.setText("Clean Filmliste");
        GroupLayout jPanelFilmlisteLayout = new GroupLayout(jPanelFilmliste);
        jPanelFilmliste.setLayout(jPanelFilmlisteLayout);
        jPanelFilmlisteLayout.setHorizontalGroup(jPanelFilmlisteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilmlisteLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFilmlisteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanelSender, -1, -1, Short.MAX_VALUE).addGroup(jPanelFilmlisteLayout.createSequentialGroup().addGroup(jPanelFilmlisteLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelFilmlisteLayout.createSequentialGroup().addComponent(this.jButtonFilmlisteLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonNeuLaden)).addGroup(jPanelFilmlisteLayout.createSequentialGroup().addComponent(this.jButtonCheck).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClean, -1, -1, Short.MAX_VALUE))).addGap(0, 258, Short.MAX_VALUE))).addContainerGap()));
        jPanelFilmlisteLayout.linkSize(0, this.jButtonCheck, this.jButtonFilmlisteLoeschen, this.jButtonNeuLaden);
        jPanelFilmlisteLayout.setVerticalGroup(jPanelFilmlisteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelFilmlisteLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFilmlisteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonFilmlisteLoeschen).addComponent(this.jButtonNeuLaden)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelFilmlisteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCheck).addComponent(this.jButtonClean)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanelSender, -2, -1, -2).addContainerGap()));
        jTabbedSender.addTab("Filmliste", jPanelFilmliste);
        this.jButtonCheckUrl.setText("get URL Filesize:");
        this.jButtonGc.setText("Gc");
        this.jButtonFehler.setText("Fehler ausgeben");
        this.jButtonAllesSpeichern.setText("alles speichern");
        this.jToggleButtonFastAuto.setText("-FASTAUTO");
        this.jButtonSize.setText("getTotalSpace");
        this.jTextFieldPath.setText("/");
        this.jButtonDir.setText(":::");
        this.jButtonSearchUrl.setText("URL suchen");
        this.jButtonTest.setText("Test");
        this.jButtonDoppelteUrls.setText("doppelte URLs l\u00f6schen");
        this.jButtonOld.setText("Alte Filmliste");
        this.jTextFieldOld.setText("/tmp/usb/filme.xz");
        GroupLayout jPanelToolsLayout = new GroupLayout(jPanelTools);
        jPanelTools.setLayout(jPanelToolsLayout);
        jPanelToolsLayout.setHorizontalGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelToolsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelToolsLayout.createSequentialGroup().addComponent(this.jButtonCheckUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUrl)).addGroup(jPanelToolsLayout.createSequentialGroup().addComponent(this.jButtonDoppelteUrls).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonTest, -1, -1, Short.MAX_VALUE).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanelToolsLayout.createSequentialGroup().addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonOld, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAllesSpeichern, GroupLayout.Alignment.LEADING, -1, 154, Short.MAX_VALUE).addComponent(this.jButtonSize, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSearchUrl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldSearchUrl).addGroup(jPanelToolsLayout.createSequentialGroup().addComponent(this.jButtonGc, -2, 154, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFehler).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButtonFastAuto, -2, 154, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelToolsLayout.createSequentialGroup().addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldOld, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDir))))).addContainerGap()));
        jPanelToolsLayout.linkSize(0, this.jButtonAllesSpeichern, this.jButtonCheckUrl, this.jButtonDoppelteUrls, this.jButtonFehler, this.jButtonGc, this.jButtonSearchUrl, this.jButtonSize, this.jButtonTest, this.jToggleButtonFastAuto);
        jPanelToolsLayout.setVerticalGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelToolsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAllesSpeichern).addComponent(this.jButtonGc).addComponent(this.jButtonFehler).addComponent(this.jToggleButtonFastAuto)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDoppelteUrls).addComponent(this.jButtonTest)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 255, Short.MAX_VALUE).addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOld).addComponent(this.jTextFieldOld, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSize).addComponent(this.jTextFieldPath, -2, -1, -2).addComponent(this.jButtonDir)).addGap(18, 18, 18).addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSearchUrl).addComponent(this.jTextFieldSearchUrl, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanelToolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCheckUrl).addComponent(this.jTextFieldUrl, -2, -1, -2)).addContainerGap()));
        jPanelToolsLayout.linkSize(1, this.jButtonCheckUrl, this.jTextFieldUrl);
        jPanelToolsLayout.linkSize(1, this.jButtonDir, this.jTextFieldPath);
        jPanelToolsLayout.linkSize(1, this.jButtonSearchUrl, this.jTextFieldSearchUrl);
        jPanelToolsLayout.linkSize(1, this.jButtonOld, this.jTextFieldOld);
        jTabbedSender.addTab("Tool", jPanelTools);
        GroupLayout jPanelStartsLayout = new GroupLayout(this.jPanelStarts);
        this.jPanelStarts.setLayout(jPanelStartsLayout);
        jPanelStartsLayout.setHorizontalGroup(jPanelStartsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 826, Short.MAX_VALUE));
        jPanelStartsLayout.setVerticalGroup(jPanelStartsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 485, Short.MAX_VALUE));
        jTabbedSender.addTab("Starts", this.jPanelStarts);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jTabbedSender).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(jTabbedSender).addContainerGap()));
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                FileDialog chooser = new FileDialog((Frame)((GuiDebug)GuiDebug.this).daten.mediathekGui, "Pfad");
                chooser.setMode(1);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        GuiDebug.this.jTextFieldPath.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(679890147, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!GuiDebug.this.jTextFieldPath.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(GuiDebug.this.jTextFieldPath.getText()));
                }
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        GuiDebug.this.jTextFieldPath.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(911025463, ex);
                    }
                }
            }
        }
    }

    private class BeobSenderLoeschen
    implements ActionListener {
        private final String sender;

        public BeobSenderLoeschen(String ssender) {
            this.sender = ssender;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Daten.listeFilme.deleteAllFilms(this.sender);
            ListenerMediathekView.notify(5, MediathekGui.class.getSimpleName());
        }
    }
}

