/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TextStyle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final float fontSize;
    private final boolean bold;
    private final boolean italic;
    private static final Map<TextStyle, TextStyle> textStylesCache = new HashMap<TextStyle, TextStyle>();

    public TextStyle(float f) {
        this(f, false, false);
    }

    public TextStyle(float f, boolean bl, boolean bl2) {
        this.fontSize = f;
        this.bold = bl;
        this.italic = bl2;
        textStylesCache.put(this, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        textStylesCache.put(this, this);
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public TextStyle deriveStyle(float f) {
        if (this.getFontSize() == f) {
            return this;
        }
        return this.getCachedTextStyle(new TextStyle(f, this.isBold(), this.isItalic()));
    }

    public TextStyle deriveBoldStyle(boolean bl) {
        if (this.isBold() == bl) {
            return this;
        }
        return this.getCachedTextStyle(new TextStyle(this.getFontSize(), bl, this.isItalic()));
    }

    public TextStyle deriveItalicStyle(boolean bl) {
        if (this.isItalic() == bl) {
            return this;
        }
        return this.getCachedTextStyle(new TextStyle(this.getFontSize(), this.isBold(), bl));
    }

    private TextStyle getCachedTextStyle(TextStyle textStyle) {
        TextStyle textStyle2 = textStylesCache.get(textStyle);
        if (textStyle2 != null) {
            return textStyle2;
        }
        textStylesCache.put(textStyle, textStyle);
        return textStyle;
    }

    public boolean equals(Object object) {
        if (object instanceof TextStyle) {
            TextStyle textStyle = (TextStyle)object;
            return textStyle.fontSize == this.fontSize && textStyle.bold == this.bold && textStyle.italic == this.italic;
        }
        return false;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.fontSize);
        if (this.bold) {
            ++n;
        }
        if (this.italic) {
            ++n;
        }
        return n;
    }
}

