/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.pojson.Pojson;
import org.codeviation.pojson.StoreInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileNameFactory<T>
implements Factory<String, T> {
    private String fileNameFormat;
    private List<Field> idParts;

    public FileNameFactory(Class<T> clazz, Collection<Field> collection) {
        this.idParts = this.getIdParts(collection);
        Pojson.FileNameFormat fileNameFormat = clazz.getAnnotation(Pojson.FileNameFormat.class);
        this.fileNameFormat = fileNameFormat == null ? null : fileNameFormat.value();
    }

    @Override
    public String create(T t) {
        Object object;
        Object[] objectArray = new Object[this.idParts.size()];
        for (int i = 0; i < this.idParts.size(); ++i) {
            try {
                object = this.idParts.get(i);
                ((Field)object).setAccessible(true);
                objectArray[i] = ((Field)object).get(t);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(StoreInfo.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(StoreInfo.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fileNameFormat == null) {
            for (Object object2 : objectArray) {
                stringBuilder.append(object2 == null ? "null" : object2.toString());
            }
            stringBuilder.append(".json");
        } else {
            object = new Formatter();
            ((Formatter)object).format(this.fileNameFormat, objectArray);
            stringBuilder.append(((Formatter)object).toString());
        }
        return stringBuilder.toString();
    }

    public List<Field> getIdParts(Collection<Field> collection) {
        TreeMap<Integer, Field> treeMap = new TreeMap<Integer, Field>();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Field field = null;
        for (Field object2 : collection) {
            Pojson.IdPart idPart;
            if (field == null) {
                field = object2;
            }
            if ((idPart = object2.getAnnotation(Pojson.IdPart.class)) == null) continue;
            int n = idPart.value();
            if (n == -1) {
                arrayList.add(object2);
                continue;
            }
            treeMap.put(n, object2);
        }
        int n = treeMap.size() + arrayList.size();
        ArrayList<Field> arrayList2 = new ArrayList<Field>(n == 0 ? 1 : n);
        if (n == 0) {
            if (field != null) {
                arrayList2.add(field);
            }
        } else {
            arrayList2.addAll(treeMap.values());
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }
}

