/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.remote.sync.Zipper;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ZipSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker {
    private TimestampAndSharabilityFilter filter;
    private int totalCount;
    private int uploadCount;
    private long totalSize;
    private long uploadSize;

    public ZipSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter printWriter, PrintWriter printWriter2, File file, File ... fileArray) {
        super(executionEnvironment, printWriter, printWriter2, file, fileArray);
    }

    private static File getTemp() {
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(string);
        return file.exists() ? file : null;
    }

    private StringBuilder getLocalFilesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : this.files) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(file.getAbsolutePath());
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeImpl(String string) throws InterruptedException, ExecutionException, IOException {
        Object object;
        Object object2;
        this.uploadCount = 0;
        this.totalCount = 0;
        this.uploadSize = 0L;
        this.totalSize = 0L;
        long l = 0L;
        if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
            System.out.printf("Uploading %s to %s ...\n", this.getLocalFilesString(), this.executionEnvironment);
            l = System.currentTimeMillis();
        }
        this.filter = new TimestampAndSharabilityFilter(this.privProjectStorageDir, this.executionEnvironment);
        StringBuilder stringBuilder = new StringBuilder("sh -c \"");
        for (int i = 0; i < this.files.length; ++i) {
            object2 = RemotePathMap.getPathMap(this.executionEnvironment).getRemotePath(this.files[i].getAbsolutePath(), true);
            if (!this.files[i].isDirectory()) continue;
            stringBuilder.append(String.format("test -d %s  || echo %s; ", object2, object2));
        }
        stringBuilder.append("\"");
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(this.executionEnvironment, stringBuilder.toString());
        if (remoteCommandSupport.run() != 0) {
            throw new IOException("Can not check remote directories");
        }
        object2 = new ArrayList();
        String string2 = remoteCommandSupport.getOutput().trim();
        if (string2.length() > 0) {
            String[] stringArray = string2.split("\n");
            this.filter.clear();
            for (int i = 0; i < stringArray.length; ++i) {
                object2.add(CommonTasksSupport.mkDir((ExecutionEnvironment)this.executionEnvironment, (String)stringArray[i], (Writer)this.err));
            }
        }
        boolean bl = false;
        File file = null;
        try {
            String string3 = this.files[0].getName();
            if (string3.length() < 3) {
                string3 = string3 + (string3.length() == 1 ? "_" : "__");
            }
            file = File.createTempFile(string3, ".zip", ZipSyncWorker.getTemp());
            Zipper zipper = new Zipper(file);
            if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                System.out.printf("\tZipping %s to %s...\n", this.getLocalFilesString(), file);
            }
            long l2 = System.currentTimeMillis();
            object = RemotePathMap.getPathMap(this.executionEnvironment);
            for (File object3 : this.files) {
                String string4 = object.getRemotePath(object3.getAbsolutePath(), false);
                if (string4 == null) {
                    throw new IOException("Can not find remote path for " + object3.getAbsolutePath());
                }
                if (!string4.startsWith(string)) {
                    throw new IOException(string4 + " should start with " + string);
                }
                String string5 = string4.substring(string.length() + 1);
                zipper.add(object3, this.filter, string5);
            }
            zipper.close();
            float f = (float)(System.currentTimeMillis() - l2) / 1000.0f;
            if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                System.out.printf("\t%d files zipped; file size is %d\n", zipper.getFileCount(), file.length());
            }
            if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                System.out.printf("\tZipping %s to %s took %f s\n", this.getLocalFilesString(), file, Float.valueOf(f));
            }
            if (zipper.getFileCount() == 0) {
                bl = true;
            } else {
                String string6;
                Object object4 = object2.iterator();
                while (object4.hasNext()) {
                    Future string7 = (Future)object4.next();
                    if ((Integer)string7.get() == 0) continue;
                    throw new IOException("Can not create directory " + string);
                }
                object4 = string + '/' + file.getName();
                long l3 = System.currentTimeMillis();
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                    System.out.printf("\tZSCP: uploading %s to %s:%s ...\n", file, this.executionEnvironment, object4);
                }
                Future future = CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)this.executionEnvironment, (String)object4, (int)511, (Writer)this.err);
                int n = (Integer)future.get();
                float f2 = (float)(System.currentTimeMillis() - l3) / 1000.0f;
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                    System.out.printf("\tZSCP: uploading %s to %s:%s finished in %f s with rc=%d\n", file, this.executionEnvironment, object4, Float.valueOf(f2), n);
                }
                if (n != 0) {
                    throw new IOException("uploading " + file + " to " + this.executionEnvironment + ':' + (String)object4 + " finished with error code " + n);
                }
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                    System.out.printf("\tZSCP: unzipping %s:%s ...\n", this.executionEnvironment, object4);
                }
                l3 = System.currentTimeMillis();
                future = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                future.setCommandLine("unzip -o " + (String)object4 + " > /dev/null");
                future.setWorkingDirectory(string);
                future.redirectError();
                NativeProcess nativeProcess = future.call();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null) {
                    if (!RemoteUtil.LOGGER.isLoggable(Level.FINEST)) continue;
                    System.err.printf("\t%s\n", string6);
                }
                int n2 = nativeProcess.waitFor();
                float f3 = (float)(System.currentTimeMillis() - l3) / 1000.0f;
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                    System.out.printf("\tZSCP: unzipping %s:%s finished in %f s; rc=%d\n", this.executionEnvironment, object4, Float.valueOf(f3), n2);
                }
                if (n2 != 0) {
                    throw new IOException("unzipping " + (String)object4 + " at " + this.executionEnvironment + " finished with error code " + n2);
                }
                bl = true;
                CommonTasksSupport.rmFile((ExecutionEnvironment)this.executionEnvironment, (String)object4, (Writer)this.err);
                this.filter.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (file != null && file.exists() && !file.delete()) {
                RemoteUtil.LOGGER.info("Can not delete temporary file " + file.getAbsolutePath());
            }
        }
        if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis() - l;
            long l4 = this.uploadSize * 1000L / l;
            String string6 = l4 < 8192L ? l4 + " b/s" : l4 / 1024L + " Kb/s";
            String string7 = this.totalSize < 1024L ? this.totalSize + " bytes" : this.totalSize / 1024L + " K";
            object = this.uploadSize < 1024L ? this.uploadSize + " bytes" : this.uploadSize / 1024L + " K";
            System.out.printf("Total: %s in %d files. Copied to %s:%s: %s in %d files. Time: %d ms. %s. Avg. speed: %s\n", string7, this.totalCount, this.executionEnvironment, string, object, this.uploadCount, l, bl ? "OK" : "FAILURE", string6);
        }
    }

    public boolean startup(Map<String, String> map) {
        boolean bl;
        block9: {
            String string = RemotePathMap.getRemoteSyncRoot(this.executionEnvironment);
            if (string == null) {
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                return false;
            }
            bl = false;
            try {
                if (this.out != null) {
                    this.out.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)string, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                RemotePathMap remotePathMap = RemotePathMap.getPathMap(this.executionEnvironment);
                this.synchronizeImpl(string);
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                RemoteUtil.LOGGER.finest(interruptedException.getMessage());
            }
            catch (InterruptedIOException interruptedIOException) {
                RemoteUtil.LOGGER.finest(interruptedIOException.getMessage());
            }
            catch (ExecutionException executionException) {
                RemoteUtil.LOGGER.log(Level.FINE, null, executionException);
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)string, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)executionException.getLocalizedMessage()));
                }
            }
            catch (IOException iOException) {
                RemoteUtil.LOGGER.log(Level.FINE, null, iOException);
                if (this.err == null) break block9;
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)string, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)iOException.getLocalizedMessage()));
            }
        }
        return bl;
    }

    public void shutdown() {
    }

    public boolean cancel() {
        return false;
    }

    private void refreshStatistics(File file, boolean bl) {
        ++this.totalCount;
        this.totalSize += file.length();
        if (bl) {
            ++this.uploadCount;
            this.uploadSize += file.length();
        }
    }

    private class TimestampAndSharabilityFilter
    implements FileFilter {
        private final FileData fileData;
        private final SharabilityFilter delegate;

        public TimestampAndSharabilityFilter(File file, ExecutionEnvironment executionEnvironment) {
            this.fileData = new FileData(file, executionEnvironment);
            this.delegate = new SharabilityFilter();
        }

        public boolean accept(File file) {
            boolean bl = this.delegate.accept(file);
            if (bl && !file.isDirectory()) {
                bl = this.needsCopying(file);
                if (bl) {
                    this.fileData.setState(file, FileState.COPIED);
                } else {
                    bl = false;
                }
            }
            ZipSyncWorker.this.refreshStatistics(file, bl);
            return bl;
        }

        public void flush() {
            this.fileData.store();
        }

        private void clear() {
            this.fileData.clear();
        }

        private boolean needsCopying(File file) {
            FileData.FileInfo fileInfo = this.fileData.getFileInfo(file);
            FileState fileState = fileInfo == null ? FileState.INITIAL : fileInfo.state;
            switch (fileState) {
                case INITIAL: {
                    return true;
                }
                case TOUCHED: {
                    return true;
                }
                case COPIED: {
                    return false;
                }
                case ERROR: {
                    return true;
                }
                case UNCONTROLLED: {
                    return false;
                }
            }
            CndUtils.assertTrue((boolean)false, (String)("Unexpected state: " + (Object)((Object)fileState)));
            return false;
        }
    }
}

