/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.SftpSupport;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.SignalSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonTasksSupport {
    private static final HashMap<ExecutionEnvironment, SignalSupport> ssMap = new HashMap();

    private CommonTasksSupport() {
    }

    private static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public static Future<Integer> downloadFile(String string, ExecutionEnvironment executionEnvironment, String string2, Writer writer) {
        return SftpSupport.downloadFile(string, executionEnvironment, string2, writer);
    }

    public static Future<Integer> uploadFile(String string, ExecutionEnvironment executionEnvironment, String string2, int n, Writer writer) {
        return SftpSupport.uploadFile(string, executionEnvironment, string2, n, writer);
    }

    public static Future<Integer> rmFile(ExecutionEnvironment executionEnvironment, String string, Writer writer) {
        return NativeTaskExecutorService.submit(new CommandRunner(executionEnvironment, writer, "rm", "-f", string), "rm -f " + string);
    }

    public static Future<Integer> chmod(ExecutionEnvironment executionEnvironment, String string, int n, Writer writer) {
        return NativeTaskExecutorService.submit(new CommandRunner(executionEnvironment, writer, "chmod", String.format("0%03o", n), string), "chmod " + String.format("0%03o ", n) + string);
    }

    public static Future<Integer> rmDir(ExecutionEnvironment executionEnvironment, String string, boolean bl, Writer writer) {
        Object[] objectArray;
        String string2;
        String string3 = string2 = bl ? "rm" : "rmdir";
        if (bl) {
            Object[] objectArray2 = new String[2];
            objectArray2[0] = "-rf";
            objectArray = objectArray2;
            objectArray2[1] = string;
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = "-f";
            objectArray = stringArray;
            stringArray[1] = string;
        }
        Object[] objectArray3 = objectArray;
        return NativeTaskExecutorService.submit(new CommandRunner(executionEnvironment, writer, string2, (String[])objectArray3), string2 + ' ' + Arrays.toString(objectArray3));
    }

    public static Future<Integer> mkDir(ExecutionEnvironment executionEnvironment, String string, Writer writer) {
        return NativeTaskExecutorService.submit(new CommandRunner(executionEnvironment, writer, "mkdir", "-p", string), "mkdir -p " + string);
    }

    public static Future<Integer> sendSignal(final ExecutionEnvironment executionEnvironment, final int n, final Signal signal, Writer writer) {
        String string = "Sending signal " + (Object)((Object)signal) + " to " + n;
        return NativeTaskExecutorService.submit(new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                SignalSupport signalSupport = null;
                HashMap hashMap = ssMap;
                synchronized (hashMap) {
                    signalSupport = (SignalSupport)ssMap.get(executionEnvironment);
                    if (signalSupport == null) {
                        signalSupport = new SignalSupport(executionEnvironment);
                        ssMap.put(executionEnvironment, signalSupport);
                    }
                }
                return signalSupport.kill(signal, n);
            }
        }, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int transferFileContent(File file, OutputStream outputStream) {
        int n;
        block27: {
            Exception exception3222;
            Channel channel;
            boolean bl;
            WritableByteChannel writableByteChannel;
            block25: {
                writableByteChannel = null;
                ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                bl = false;
                channel = null;
                n = 1;
                writableByteChannel = Channels.newChannel(outputStream);
                FileInputStream fileInputStream = new FileInputStream(file);
                channel = Channels.newChannel(fileInputStream);
                while (channel.read(byteBuffer) > 0) {
                    byteBuffer.flip();
                    try {
                        writableByteChannel.write(byteBuffer);
                    }
                    catch (Exception exception2) {
                        throw new InterruptedException();
                    }
                    byteBuffer.clear();
                }
                n = 0;
                Object var10_11 = null;
                if (channel == null) break block25;
                try {
                    channel.close();
                }
                catch (IOException exception3222) {
                    // empty catch block
                }
            }
            if (!bl && writableByteChannel != null) {
                try {
                    writableByteChannel.close();
                }
                catch (Exception exception3222) {}
            }
            break block27;
            {
                catch (InterruptedException interruptedException) {
                    Exception exception42222;
                    bl = true;
                    Object var10_12 = null;
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException exception42222) {
                            // empty catch block
                        }
                    }
                    if (!bl && writableByteChannel != null) {
                        try {
                            writableByteChannel.close();
                        }
                        catch (Exception exception42222) {}
                    }
                    break block27;
                }
                catch (IOException iOException) {
                    Exception exception52222;
                    Object var10_13 = null;
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException exception52222) {
                            // empty catch block
                        }
                    }
                    if (!bl && writableByteChannel != null) {
                        try {
                            writableByteChannel.close();
                        }
                        catch (Exception exception52222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception exception62222;
                Object var10_14 = null;
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException exception62222) {
                        // empty catch block
                    }
                }
                if (!bl && writableByteChannel != null) {
                    try {
                        writableByteChannel.close();
                    }
                    catch (Exception exception62222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandRunner
    implements Callable<Integer> {
        private static final java.util.logging.Logger log = Logger.getInstance();
        private final ExecutionEnvironment execEnv;
        private final String cmd;
        private final String[] args;
        private final Writer error;

        public CommandRunner(ExecutionEnvironment executionEnvironment, Writer writer, String string, String ... stringArray) {
            this.execEnv = executionEnvironment;
            this.cmd = string;
            this.args = stringArray;
            this.error = writer;
        }

        @Override
        public Integer call() throws Exception {
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder(this.execEnv);
            nativeProcessBuilder.setExecutable(this.cmd).setArguments(this.args);
            NativeProcess nativeProcess = nativeProcessBuilder.call();
            int n = nativeProcess.waitFor();
            if (n != 0) {
                if (this.error != null) {
                    ProcessUtils.writeError(this.error, nativeProcess);
                } else {
                    ProcessUtils.logError(Level.FINE, log, nativeProcess);
                }
            }
            return n;
        }
    }
}

