/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.ProcessInfo;
import org.netbeans.modules.nativeexecution.api.ProcessInfoProviderFactory;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.spi.ProcessInfoProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class AbstractNativeProcess
extends NativeProcess {
    protected static final java.util.logging.Logger LOG = Logger.getInstance();
    private static final Integer PID_TIMEOUT = Integer.valueOf(System.getProperty("dlight.nativeexecutor.pidtimeout", "70"));
    protected final NativeProcessInfo info;
    protected final HostInfo hostInfo;
    protected long creation_ts = -1L;
    private final String id;
    private final ExecutionEnvironment execEnv;
    private final Collection<ChangeListener> listeners;
    private final Object stateLock;
    private volatile NativeProcess.State state;
    private volatile int pid = 0;
    private volatile Integer exitValue = null;
    private volatile boolean isInterrupted;
    private boolean cancelled = false;
    private Future<ProcessInfoProvider> infoProviderSearchTask;

    public AbstractNativeProcess(NativeProcessInfo nativeProcessInfo) {
        this.info = nativeProcessInfo;
        this.isInterrupted = false;
        this.state = NativeProcess.State.INITIAL;
        this.execEnv = nativeProcessInfo.getExecutionEnvironment();
        String string = nativeProcessInfo.getCommandLineForShell();
        if (string == null) {
            string = Arrays.toString(nativeProcessInfo.getCommand().toArray(new String[0]));
        }
        this.id = ((Object)this.execEnv).toString() + ' ' + string;
        this.stateLock = "StateLock: " + this.id;
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo(this.execEnv);
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.hostInfo = hostInfo;
        Collection<ChangeListener> collection = nativeProcessInfo.getListeners();
        this.listeners = collection == null || collection.isEmpty() ? null : Collections.unmodifiableList(new ArrayList<ChangeListener>(collection));
    }

    public final NativeProcess createAndStart() throws IOException {
        try {
            if (this.hostInfo == null) {
                throw new IllegalStateException("Unable to create process - no HostInfo available");
            }
            this.setState(NativeProcess.State.STARTING);
            this.create();
            this.setState(NativeProcess.State.RUNNING);
            this.findInfoProvider();
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, AbstractNativeProcess.loc("NativeProcess.exceptionOccured.text", new String[0]), throwable.toString());
            this.setState(NativeProcess.State.ERROR);
        }
        return this;
    }

    protected abstract void create() throws Throwable;

    protected final boolean isInterrupted() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            this.isInterrupted = true;
            Thread.currentThread().interrupt();
        }
        this.isInterrupted |= Thread.currentThread().isInterrupted();
        return this.isInterrupted;
    }

    protected final void interrupt() {
        this.isInterrupted = true;
        this.destroy();
    }

    public final ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPID() throws IOException {
        AbstractNativeProcess abstractNativeProcess = this;
        synchronized (abstractNativeProcess) {
            if (this.pid == 0) {
                if (this.isInterrupted()) {
                    this.destroy();
                    throw new InterruptedIOException();
                }
                throw new IOException("PID of process '" + this.id + "' is not received!");
            }
            return this.pid;
        }
    }

    protected abstract void cancel();

    protected abstract int waitResult() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NativeProcess.State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    public final String toString() {
        return this.id == null ? super.toString() : this.id.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        Object object = this;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
        }
        object = this.stateLock;
        synchronized (object) {
            this.cancel();
            this.setState(NativeProcess.State.CANCELLED);
        }
    }

    public final int waitFor() throws InterruptedException {
        this.setExitValue(this.waitResult());
        if (this.exitValue == null) {
            throw new InterruptedException("Process has been cancelled.");
        }
        return this.exitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int exitValue() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.exitValue == null) {
                if (this.state == NativeProcess.State.CANCELLED) {
                    return -1;
                }
                throw new IllegalThreadStateException();
            }
        }
        return this.exitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExitValue(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.exitValue != null) {
                return;
            }
            if (this.state == NativeProcess.State.CANCELLED || this.state == NativeProcess.State.ERROR) {
                return;
            }
            this.exitValue = n;
            this.setState(NativeProcess.State.FINISHED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setState(NativeProcess.State state) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == state) {
                return;
            }
            if (this.state == NativeProcess.State.CANCELLED || this.state == NativeProcess.State.ERROR || this.state == NativeProcess.State.FINISHED) {
                return;
            }
            try {
                if (this.isInterrupted()) {
                    Thread.interrupted();
                }
                if (!this.isInterrupted()) {
                    LOG.finest(this.toString() + " State change: " + (Object)((Object)this.state) + " -> " + (Object)((Object)state));
                }
                this.state = state;
                if (this.listeners == null) {
                    return;
                }
                NativeProcessChangeEvent nativeProcessChangeEvent = new NativeProcessChangeEvent(this, state, this.pid);
                for (ChangeListener changeListener : this.listeners) {
                    changeListener.stateChanged(nativeProcessChangeEvent);
                }
            }
            finally {
                if (this.isInterrupted()) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected final void readPID(InputStream inputStream) throws IOException {
        int n = -1;
        this.pid = 0;
        while ((n = inputStream.read()) >= 48 && n <= 57) {
            this.pid = this.pid * 10 + (n - 48);
        }
    }

    public ProcessInfo getProcessInfo() {
        ProcessInfoProvider processInfoProvider = null;
        try {
            processInfoProvider = this.infoProviderSearchTask.get();
        }
        catch (Throwable throwable) {
            LOG.finest(throwable.getMessage());
        }
        return processInfoProvider == null ? new ProcessInfo(){

            public long getCreationTimestamp(TimeUnit timeUnit) {
                return timeUnit.convert(AbstractNativeProcess.this.creation_ts, TimeUnit.NANOSECONDS);
            }
        } : processInfoProvider.getProcessInfo();
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(AbstractNativeProcess.class, (String)string, (Object[])stringArray);
    }

    private void findInfoProvider() {
        Callable<ProcessInfoProvider> callable = new Callable<ProcessInfoProvider>(){

            @Override
            public ProcessInfoProvider call() throws Exception {
                ProcessInfoProviderFactory processInfoProviderFactory;
                Collection collection = Lookup.getDefault().lookupAll(ProcessInfoProviderFactory.class);
                ProcessInfoProvider processInfoProvider = null;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && (processInfoProvider = (processInfoProviderFactory = (ProcessInfoProviderFactory)iterator.next()).getProvider(AbstractNativeProcess.this.execEnv, AbstractNativeProcess.this.pid)) == null) {
                }
                return processInfoProvider;
            }
        };
        this.infoProviderSearchTask = NativeTaskExecutorService.submit(callable, "get info provider for process " + this.pid);
    }
}

