/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAClassPathHelper {
    private final Set<ClassPath> boot;
    private final Set<ClassPath> compile;
    private final Set<ClassPath> source;

    public JPAClassPathHelper(Set<ClassPath> set, Set<ClassPath> set2, Set<ClassPath> set3) {
        Parameters.notNull((CharSequence)"boot", set);
        Parameters.notNull((CharSequence)"compile", set2);
        Parameters.notNull((CharSequence)"source", set3);
        this.boot = new HashSet<ClassPath>(set);
        this.compile = new HashSet<ClassPath>(set2);
        this.source = new HashSet<ClassPath>(set3);
    }

    public ClasspathInfo createClasspathInfo() {
        if (!this.ensureJPA()) {
            throw new IllegalStateException("Cannot find a Java Persistence API library");
        }
        return ClasspathInfo.create((ClassPath)this.createProxyClassPath(this.boot), (ClassPath)this.createProxyClassPath(this.compile), (ClassPath)this.createProxyClassPath(this.source));
    }

    private boolean ensureJPA() {
        for (ClassPath classPath : this.compile) {
            if (classPath.findResource("javax/persistence/Entity.class") == null) continue;
            return true;
        }
        ClassPath classPath = this.findJPALibrary();
        if (classPath != null) {
            this.compile.add(classPath);
            return true;
        }
        return false;
    }

    private ClassPath findJPALibrary() {
        Library library = PersistenceLibrarySupport.getFirstProviderLibrary();
        if (library == null) {
            return null;
        }
        List list = library.getContent("classpath");
        return ClassPathSupport.createClassPath((URL[])list.toArray(new URL[list.size()]));
    }

    private ClassPath createProxyClassPath(Set<ClassPath> set) {
        return ClassPathSupport.createProxyClassPath((ClassPath[])set.toArray(new ClassPath[set.size()]));
    }
}

