/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.GeneratedTables;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSchemaEjbGenerator {
    private GeneratedTables genTables;
    private Map beans = new HashMap();
    private List relations = new ArrayList();
    private SchemaElement schemaElement;
    private Set<String> tablesReferecedByOtherTables;
    private final EntityRelation.CollectionType colectionType;
    private static final Logger LOGGER = Logger.getLogger(DbSchemaEjbGenerator.class.getName());

    public DbSchemaEjbGenerator(GeneratedTables generatedTables, SchemaElement schemaElement) {
        this(generatedTables, schemaElement, EntityRelation.CollectionType.COLLECTION);
    }

    public DbSchemaEjbGenerator(GeneratedTables generatedTables, SchemaElement schemaElement, EntityRelation.CollectionType collectionType) {
        this.schemaElement = schemaElement;
        this.genTables = generatedTables;
        this.colectionType = collectionType;
        this.tablesReferecedByOtherTables = DbSchemaEjbGenerator.getTablesReferecedByOtherTables(schemaElement);
        this.buildCMPSet();
    }

    public static Set<String> getTablesReferecedByOtherTables(SchemaElement schemaElement) {
        HashSet<String> hashSet = new HashSet<String>();
        TableElement[] tableElementArray = schemaElement.getTables();
        for (int i = 0; i < tableElementArray.length; ++i) {
            ForeignKeyElement[] foreignKeyElementArray = tableElementArray[i].getForeignKeys();
            for (int j = 0; j < foreignKeyElementArray.length; ++j) {
                hashSet.add(foreignKeyElementArray[j].getReferencedTable().getName().getName());
            }
        }
        return hashSet;
    }

    public static boolean isJoinTable(TableElement tableElement, Set<String> set) {
        ForeignKeyElement[] foreignKeyElementArray = tableElement.getForeignKeys();
        if (foreignKeyElementArray == null || foreignKeyElementArray.length != 2) {
            return false;
        }
        int n = foreignKeyElementArray[0].getColumns().length + foreignKeyElementArray[1].getColumns().length;
        if (n < tableElement.getColumns().length) {
            return false;
        }
        String string = tableElement.getName().getName();
        for (int i = 0; i < 2; ++i) {
            if (!string.equals(foreignKeyElementArray[i].getReferencedTable().getName().getName())) continue;
            return false;
        }
        if (DbSchemaEjbGenerator.isFkUnique(foreignKeyElementArray[0]) || DbSchemaEjbGenerator.isFkUnique(foreignKeyElementArray[1])) {
            return false;
        }
        return !set.contains(tableElement.getName().getName());
    }

    private boolean isForeignKey(ForeignKeyElement[] foreignKeyElementArray, ColumnElement columnElement) {
        if (foreignKeyElementArray == null) {
            return false;
        }
        for (int i = 0; i < foreignKeyElementArray.length; ++i) {
            if (foreignKeyElementArray[i].getColumn(columnElement.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public EntityClass[] getBeans() {
        return this.beans.values().toArray(new EntityClass[this.beans.size()]);
    }

    public EntityRelation[] getRelations() {
        return this.relations.toArray(new EntityRelation[this.relations.size()]);
    }

    private EntityClass getBean(String string) {
        return (EntityClass)this.beans.get(string);
    }

    private EntityClass addBean(String string) {
        EntityClass entityClass = this.getBean(string);
        if (entityClass != null) {
            return entityClass;
        }
        entityClass = new EntityClass(this.genTables.getCatalog(), this.genTables.getSchema(), string, this.genTables.getRootFolder(string), this.genTables.getPackageName(string), this.genTables.getClassName(string), this.genTables.getUniqueConstraints(string));
        this.beans.put(string, entityClass);
        return entityClass;
    }

    private void addAllTables() {
        LinkedList<TableElement> linkedList = new LinkedList<TableElement>();
        for (String string : this.genTables.getTableNames()) {
            TableElement tableElement = this.schemaElement.getTable(DBIdentifier.create((String)string));
            if (DbSchemaEjbGenerator.isJoinTable(tableElement, this.tablesReferecedByOtherTables)) {
                linkedList.add(tableElement);
                continue;
            }
            this.addBean(string);
        }
        for (TableElement tableElement : linkedList) {
            this.addJoinTable(tableElement);
        }
    }

    private CMPMappingModel.ColumnData[] getLocalColumnData(ForeignKeyElement foreignKeyElement) {
        ColumnPairElement[] columnPairElementArray = foreignKeyElement.getColumnPairs();
        CMPMappingModel.ColumnData[] columnDataArray = new CMPMappingModel.ColumnData[columnPairElementArray.length];
        for (int i = 0; i < columnPairElementArray.length; ++i) {
            columnDataArray[i] = new CMPMappingModel.ColumnData(columnPairElementArray[i].getLocalColumn().getName().getName(), columnPairElementArray[i].getLocalColumn().isNullable());
        }
        return columnDataArray;
    }

    private CMPMappingModel.ColumnData[] getReferencedColumnData(ForeignKeyElement foreignKeyElement) {
        ColumnPairElement[] columnPairElementArray = foreignKeyElement.getColumnPairs();
        CMPMappingModel.ColumnData[] columnDataArray = new CMPMappingModel.ColumnData[columnPairElementArray.length];
        for (int i = 0; i < columnPairElementArray.length; ++i) {
            columnDataArray[i] = new CMPMappingModel.ColumnData(columnPairElementArray[i].getReferencedColumn().getName().getName(), columnPairElementArray[i].getReferencedColumn().isNullable());
        }
        return columnDataArray;
    }

    private String getRoleName(ForeignKeyElement foreignKeyElement, String string) {
        ColumnPairElement[] columnPairElementArray = foreignKeyElement.getColumnPairs();
        if (columnPairElementArray == null || columnPairElementArray.length > 1) {
            return string;
        }
        return EntityMember.makeClassName(columnPairElementArray[0].getLocalColumn().getName().getName());
    }

    private void addJoinTable(TableElement tableElement) {
        String string;
        ForeignKeyElement[] foreignKeyElementArray = tableElement.getForeignKeys();
        String string2 = foreignKeyElementArray[0].getReferencedTable().getName().getName();
        String string3 = foreignKeyElementArray[1].getReferencedTable().getName().getName();
        EntityClass entityClass = this.getBean(string2);
        EntityClass entityClass2 = this.getBean(string3);
        String string4 = entityClass != null ? entityClass.getClassName() : null;
        String string5 = string = entityClass2 != null ? entityClass2.getClassName() : null;
        if (string4 == null || string == null) {
            LOGGER.log(Level.INFO, "Skip relationships generation for \"" + tableElement.getName().getName() + "\" join table, next referenced tables was not selected in new wizard: " + (string4 == null ? string2 : "") + (string4 == null && string == null ? ", " : "") + (string == null ? string3 : ""));
            return;
        }
        String string6 = this.getRoleName(foreignKeyElementArray[0], string4);
        String string7 = this.getRoleName(foreignKeyElementArray[1], string);
        String string8 = EntityMember.makeRelationshipFieldName(string, this.colectionType, true);
        String string9 = EntityMember.makeRelationshipFieldName(string4, this.colectionType, true);
        string8 = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(entityClass), string8, null);
        List list = this.getFieldNames(entityClass2);
        if (string2.equals(string3)) {
            list.add(string8);
        }
        string9 = DbSchemaEjbGenerator.uniqueAlgorithm(list, string9, null);
        RelationshipRole relationshipRole = new RelationshipRole(string6, entityClass.getClassName(), string8, true, true, false);
        relationshipRole.setEntityPkgName(entityClass.getPackage());
        entityClass.addRole(relationshipRole);
        RelationshipRole relationshipRole2 = new RelationshipRole(string7, entityClass2.getClassName(), string9, true, true, false);
        relationshipRole2.setEntityPkgName(entityClass2.getPackage());
        entityClass2.addRole(relationshipRole2);
        EntityRelation entityRelation = new EntityRelation(relationshipRole, relationshipRole2);
        this.relations.add(entityRelation);
        entityRelation.setRelationName(EntityMember.makeClassName(tableElement.getName().getName()));
        entityClass.getCMPMapping().getJoinTableMapping().put(string8, tableElement.getName().getName());
        CMPMappingModel.JoinTableColumnMapping joinTableColumnMapping = new CMPMappingModel.JoinTableColumnMapping();
        joinTableColumnMapping.setColumns(this.getColumnData(foreignKeyElementArray[0].getColumns()));
        joinTableColumnMapping.setReferencedColumns(this.getColumnData(foreignKeyElementArray[0].getReferencedColumns()));
        joinTableColumnMapping.setInverseColumns(this.getColumnData(foreignKeyElementArray[1].getColumns()));
        joinTableColumnMapping.setReferencedInverseColumns(this.getColumnData(foreignKeyElementArray[1].getReferencedColumns()));
        entityClass.getCMPMapping().getJoinTableColumnMppings().put(string8, joinTableColumnMapping);
        entityClass2.getCMPMapping().getJoinTableMapping().put(string9, tableElement.getName().getName());
        CMPMappingModel.JoinTableColumnMapping joinTableColumnMapping2 = new CMPMappingModel.JoinTableColumnMapping();
        joinTableColumnMapping2.setColumns(this.getColumnData(foreignKeyElementArray[1].getColumns()));
        joinTableColumnMapping2.setReferencedColumns(this.getColumnData(foreignKeyElementArray[1].getReferencedColumns()));
        joinTableColumnMapping2.setInverseColumns(this.getColumnData(foreignKeyElementArray[0].getColumns()));
        joinTableColumnMapping2.setReferencedInverseColumns(this.getColumnData(foreignKeyElementArray[0].getReferencedColumns()));
        entityClass2.getCMPMapping().getJoinTableColumnMppings().put(string9, joinTableColumnMapping2);
    }

    private CMPMappingModel.ColumnData[] getColumnData(ColumnElement[] columnElementArray) {
        CMPMappingModel.ColumnData[] columnDataArray = new CMPMappingModel.ColumnData[columnElementArray.length];
        for (int i = 0; i < columnElementArray.length; ++i) {
            columnDataArray[i] = new CMPMappingModel.ColumnData(columnElementArray[i].getName().getName(), columnElementArray[i].isNullable());
        }
        return columnDataArray;
    }

    private static boolean containsSameColumns(ColumnElement[] columnElementArray, UniqueKeyElement uniqueKeyElement) {
        if (columnElementArray.length == uniqueKeyElement.getColumns().length) {
            for (int i = 0; i < columnElementArray.length; ++i) {
                if (uniqueKeyElement.getColumn(columnElementArray[i].getName()) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean containsColumns(ColumnElement[] columnElementArray, UniqueKeyElement uniqueKeyElement) {
        if (uniqueKeyElement == null) {
            return false;
        }
        for (int i = 0; i < columnElementArray.length; ++i) {
            if (uniqueKeyElement.getColumn(columnElementArray[i].getName()) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isFkUnique(ForeignKeyElement foreignKeyElement) {
        UniqueKeyElement[] uniqueKeyElementArray = foreignKeyElement.getDeclaringTable().getUniqueKeys();
        if (uniqueKeyElementArray == null) {
            return false;
        }
        ColumnElement[] columnElementArray = foreignKeyElement.getColumns();
        for (int i = 0; i < uniqueKeyElementArray.length; ++i) {
            if (!DbSchemaEjbGenerator.containsSameColumns(columnElementArray, uniqueKeyElementArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isNullable(ForeignKeyElement foreignKeyElement) {
        ColumnElement[] columnElementArray = foreignKeyElement.getColumns();
        int n = columnElementArray != null ? columnElementArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (columnElementArray[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    private static UniqueKeyElement getPrimaryOrCandidateKey(TableElement tableElement) {
        UniqueKeyElement uniqueKeyElement = tableElement.getPrimaryKey();
        if (uniqueKeyElement != null) {
            return uniqueKeyElement;
        }
        UniqueKeyElement[] uniqueKeyElementArray = tableElement.getUniqueKeys();
        if (uniqueKeyElementArray == null || uniqueKeyElementArray.length == 0) {
            return null;
        }
        uniqueKeyElement = uniqueKeyElementArray[0];
        for (int i = 1; i < uniqueKeyElementArray.length; ++i) {
            if (uniqueKeyElementArray[i].getColumns().length >= uniqueKeyElement.getColumns().length) continue;
            uniqueKeyElement = uniqueKeyElementArray[i];
        }
        return uniqueKeyElement;
    }

    private void generatePkField(ColumnElement columnElement, boolean bl, boolean bl2) {
        EntityMember entityMember = EntityMember.create(columnElement);
        entityMember.setPrimaryKey(bl, bl2);
        EntityClass entityClass = this.getBean(columnElement.getDeclaringTable().getName().getName());
        entityMember.setMemberName(DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(entityClass), entityMember.getMemberName(), null));
        entityClass.getFields().add(entityMember);
    }

    private void generateRelationship(ForeignKeyElement foreignKeyElement) {
        String string = foreignKeyElement.getDeclaringTable().getName().getName();
        String string2 = foreignKeyElement.getReferencedTable().getName().getName();
        boolean bl = DbSchemaEjbGenerator.isFkUnique(foreignKeyElement);
        EntityClass entityClass = this.getBean(string2);
        if (entityClass == null) {
            return;
        }
        EntityClass entityClass2 = this.getBean(string);
        if (entityClass2 == null) {
            return;
        }
        String string3 = EntityMember.makeRelationshipFieldName(entityClass2.getClassName(), this.colectionType, !bl);
        string3 = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(entityClass), string3, null);
        RelationshipRole relationshipRole = new RelationshipRole(this.getRoleName(foreignKeyElement, entityClass.getClassName()), entityClass.getClassName(), string3, false, !bl, !this.isNullable(foreignKeyElement), this.isNullable(foreignKeyElement));
        relationshipRole.setEntityPkgName(entityClass.getPackage());
        entityClass.addRole(relationshipRole);
        String string4 = EntityMember.makeRelationshipFieldName(entityClass.getClassName(), this.colectionType, false);
        if (!this.containsColumns(foreignKeyElement.getColumns(), DbSchemaEjbGenerator.getPrimaryOrCandidateKey(foreignKeyElement.getDeclaringTable()))) {
            string4 = EntityMember.makeRelationshipFieldName(relationshipRole.getRoleName(), this.colectionType, false);
        }
        string4 = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(entityClass2), string4, null);
        RelationshipRole relationshipRole2 = new RelationshipRole(this.getRoleName(foreignKeyElement, entityClass2.getClassName()), entityClass2.getClassName(), string4, !bl, false, false, this.isNullable(foreignKeyElement));
        relationshipRole2.setEntityPkgName(entityClass2.getPackage());
        entityClass2.addRole(relationshipRole2);
        EntityRelation entityRelation = new EntityRelation(relationshipRole2, relationshipRole);
        entityRelation.setRelationName(relationshipRole2.getEntityName() + '-' + relationshipRole.getEntityName());
        this.relations.add(entityRelation);
        entityClass2.getCMPMapping().getCmrFieldMapping().put(string4, this.getLocalColumnData(foreignKeyElement));
        entityClass.getCMPMapping().getCmrFieldMapping().put(string3, this.getReferencedColumnData(foreignKeyElement));
    }

    private void reset() {
        this.beans.clear();
        this.relations.clear();
    }

    private void buildCMPSet() {
        this.reset();
        this.addAllTables();
        Iterator iterator = this.beans.keySet().iterator();
        while (iterator.hasNext()) {
            int n;
            String string = iterator.next().toString();
            TableElement tableElement = this.schemaElement.getTable(DBIdentifier.create((String)string));
            ColumnElement[] columnElementArray = tableElement.getColumns();
            UniqueKeyElement uniqueKeyElement = DbSchemaEjbGenerator.getPrimaryOrCandidateKey(tableElement);
            ForeignKeyElement[] foreignKeyElementArray = tableElement.getForeignKeys();
            for (n = 0; n < columnElementArray.length; ++n) {
                if (uniqueKeyElement != null && uniqueKeyElement.getColumn(columnElementArray[n].getName()) != null) {
                    this.generatePkField(columnElementArray[n], true, uniqueKeyElement.getColumns().length == 1);
                    continue;
                }
                if (this.isForeignKey(foreignKeyElementArray, columnElementArray[n])) continue;
                this.generatePkField(columnElementArray[n], false, false);
            }
            for (n = 0; foreignKeyElementArray != null && foreignKeyElementArray.length > n; ++n) {
                this.generateRelationship(foreignKeyElementArray[n]);
            }
            EntityClass entityClass = this.getBean(string);
            entityClass.usePkField(uniqueKeyElement != null && uniqueKeyElement.getColumns().length == 1);
            entityClass.setIsForTable(tableElement.isTable());
        }
        this.makeRelationsUnique();
    }

    private List getFieldNames(EntityClass entityClass) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EntityMember object : entityClass.getFields()) {
            arrayList.add(object.getMemberName());
        }
        for (RelationshipRole relationshipRole : entityClass.getRoles()) {
            arrayList.add(relationshipRole.getFieldName());
        }
        return arrayList;
    }

    private EntityRelation[] makeRelationsUnique() {
        EntityRelation[] entityRelationArray = this.getRelations();
        ArrayList arrayList = new ArrayList(entityRelationArray.length);
        for (int i = 0; i < entityRelationArray.length; ++i) {
            entityRelationArray[i].makeRoleNamesUnique();
            String string = entityRelationArray[i].getRelationName();
            entityRelationArray[i].setRelationName(DbSchemaEjbGenerator.uniqueAlgorithm(arrayList, string, "-"));
        }
        return entityRelationArray;
    }

    private static String uniqueAlgorithm(List list, String string, String string2) {
        String string3 = string;
        int n = 0;
        while (list.contains(string3)) {
            String string4 = string2 == null ? "" : string2;
            string3 = string + string4 + String.valueOf(++n);
        }
        list.add(string3);
        return string3;
    }
}

