/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitsTrackerImpl
extends KitsTracker {
    private static final Logger LOG = Logger.getLogger(KitsTrackerImpl.class.getName());
    private static final Set<String> ALREADY_LOGGED = Collections.synchronizedSet(new HashSet(10));
    private static final Logger TIMER = Logger.getLogger("TIMER");
    private final Map<String, FileObject> mimeType2kitClass = new HashMap<String, FileObject>();
    private final Map<Class, List<String>> kitClass2mimeTypes = new HashMap<Class, List<String>>();
    private final Set<String> knownMimeTypes = new HashSet<String>();
    private List<FileObject> eventSources = null;
    private boolean needsReloading = true;
    private boolean mimeType2kitClassLoaded = false;
    private static final Set<String> WELL_KNOWN_PARENTS = new HashSet<String>(Arrays.asList("java.lang.Object", "javax.swing.text.EditorKit", "javax.swing.text.DefaultEditorKit", "org.netbeans.editor.BaseKit", "org.netbeans.editor.ext.ExtKit", "org.netbeans.modules.editor.NbEditorKit", "org.netbeans.modules.xml.text.syntax.UniKit"));
    private static final Set<String> DYNAMIC_LANGUAGES = new HashSet<String>(Arrays.asList("org.netbeans.modules.languages.dataobject.LanguagesEditorKit", "org.netbeans.modules.gsf.GsfEditorKitFactory$GsfEditorKit"));
    private final ThreadLocal<Stack<String>> contexts = new ThreadLocal();
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fileEvent) {
            KitsTrackerImpl.this.invalidateCache();
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (fileEvent.getFile().isFolder()) {
                KitsTrackerImpl.this.invalidateCache();
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (fileRenameEvent.getFile().isFolder()) {
                KitsTrackerImpl.this.invalidateCache();
            }
        }
    };
    private static final ThreadLocal<Boolean> inReload = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public List<String> getMimeTypesForKitClass(Class clazz) {
        if (clazz != null) {
            if (WELL_KNOWN_PARENTS.contains(clazz.getName())) {
                return Collections.emptyList();
            }
            return (List)this.updateAndGet(clazz);
        }
        return Collections.singletonList("");
    }

    public String findMimeType(Class clazz) {
        if (clazz != null) {
            if (WELL_KNOWN_PARENTS.contains(clazz.getName())) {
                return null;
            }
            String string = null;
            Stack<String> stack = this.contexts.get();
            if (stack != null && !stack.empty()) {
                string = stack.peek();
            }
            if (string == null || string.length() == 0) {
                List<String> list = this.getMimeTypesForKitClass(clazz);
                if (list.size() == 0) {
                    if (LOG.isLoggable(Level.WARNING) && !DYNAMIC_LANGUAGES.contains(clazz.getName())) {
                        KitsTrackerImpl.logOnce(Level.WARNING, "No mime type uses editor kit implementation class: " + clazz);
                    }
                    return null;
                }
                if (list.size() == 1) {
                    return list.get(0);
                }
                if (LOG.isLoggable(Level.WARNING)) {
                    KitsTrackerImpl.logOnce(Level.WARNING, "Ambiguous mime types for editor kit implementation class: " + clazz + "; mime types: " + list);
                }
                return null;
            }
            return string;
        }
        return "";
    }

    public Class<?> findKitClass(String string) {
        if (string.length() > 0) {
            return (Class)this.updateAndGet(string);
        }
        return null;
    }

    public Set<String> getMimeTypes() {
        return (Set)this.updateAndGet(null);
    }

    public String setContextMimeType(String string) {
        String string2 = null;
        Stack<String> stack = this.contexts.get();
        if (stack == null) {
            stack = new Stack();
            this.contexts.set(stack);
        }
        if (string != null) {
            assert (MimePath.validate((CharSequence)string)) : "Invalid mime type: '" + string + "'";
            if (!stack.empty()) {
                string2 = stack.peek();
            }
            stack.push(string);
        } else if (!stack.empty()) {
            string2 = stack.pop();
        }
        return string2;
    }

    public String toString() {
        return "KitsTrackerImpl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reload(Set<String> set, List<FileObject> list) {
        assert (!inReload.get().booleanValue()) : "Re-entering KitsTracker.reload() is prohibited. This situation usually indicates wrong initialization of some setting.";
        inReload.set(true);
        try {
            KitsTrackerImpl._reload(set, list);
        }
        finally {
            inReload.set(false);
        }
    }

    private static void _reload(Set<String> set, List<FileObject> list) {
        FileObject fileObject = FileUtil.getConfigFile((String)"Editors");
        if (fileObject != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!KitsTrackerImpl.isValidType(fileObjectArray[i])) continue;
                FileObject[] fileObjectArray2 = fileObjectArray[i].getChildren();
                for (int j = 0; j < fileObjectArray2.length; ++j) {
                    if (!KitsTrackerImpl.isValidSubtype(fileObjectArray2[j])) continue;
                    String string = fileObjectArray[i].getNameExt() + "/" + fileObjectArray2[j].getNameExt();
                    set.add(string);
                }
                list.add(fileObjectArray[i]);
            }
            list.add(fileObject);
        }
    }

    private static FileObject findKitRegistration(FileObject fileObject) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (fileObject2.getAttribute("instanceOf") != null) {
                hashSet.add(fileObject2);
                continue;
            }
            hashSet2.add(fileObject2);
        }
        for (FileObject fileObject3 : hashSet) {
            if (!KitsTrackerImpl.isInstanceOf(fileObject3, EditorKit.class, false)) continue;
            return fileObject3;
        }
        for (FileObject fileObject4 : hashSet2) {
            if (!KitsTrackerImpl.isInstanceOf(fileObject4, EditorKit.class, false)) continue;
            return fileObject4;
        }
        return null;
    }

    private static boolean isInstanceOf(FileObject fileObject, Class clazz, boolean bl) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
            if (instanceCookie != null) {
                if (instanceCookie instanceof InstanceCookie.Of) {
                    if (!bl) {
                        return ((InstanceCookie.Of)instanceCookie).instanceOf(clazz);
                    }
                    if (!((InstanceCookie.Of)instanceCookie).instanceOf(clazz)) {
                        return false;
                    }
                    return instanceCookie.instanceClass() == clazz;
                }
                Class clazz2 = instanceCookie.instanceClass();
                if (!bl ? clazz.isAssignableFrom(clazz2) : clazz == clazz2) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static Class<?> instanceClass(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
            if (instanceCookie != null) {
                return instanceCookie.instanceClass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCache() {
        Map<String, FileObject> map = this.mimeType2kitClass;
        synchronized (map) {
            this.needsReloading = true;
        }
        this.firePropertyChange(null, null, null);
    }

    private static boolean isValidType(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return MimePath.validate((CharSequence)string, null);
    }

    private static boolean isValidSubtype(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return MimePath.validate(null, (CharSequence)string);
    }

    private static void logOnce(Level level, String string) {
        if (!ALREADY_LOGGED.contains(string)) {
            LOG.log(level, string);
            ALREADY_LOGGED.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Object updateAndGet(Object object) {
        boolean bl;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Map<String, FileObject> map = this.mimeType2kitClass;
        synchronized (map) {
            bl = this.needsReloading;
        }
        if (bl) {
            KitsTrackerImpl.reload(hashSet, arrayList);
        }
        map = this.mimeType2kitClass;
        synchronized (map) {
            FileObject fileObject;
            Object object2;
            if (bl) {
                if (this.eventSources != null) {
                    for (FileObject object3 : this.eventSources) {
                        object3.removeFileChangeListener(this.fcl);
                    }
                }
                this.knownMimeTypes.clear();
                this.knownMimeTypes.addAll(hashSet);
                this.eventSources = arrayList;
                for (FileObject fileObject2 : this.eventSources) {
                    fileObject2.addFileChangeListener(this.fcl);
                }
                this.needsReloading = false;
                this.mimeType2kitClassLoaded = false;
            }
            if (object == null) {
                Iterator<FileObject> iterator = new HashSet<String>(this.knownMimeTypes);
                TIMER.log(Level.FINE, "[M] Mime types", new Object[]{this, iterator.size()});
                return iterator;
            }
            if (!this.mimeType2kitClassLoaded) {
                long l = System.currentTimeMillis();
                this.mimeType2kitClassLoaded = true;
                this.mimeType2kitClass.clear();
                this.kitClass2mimeTypes.clear();
                object2 = FileUtil.getConfigFile((String)"Editors");
                for (String string : this.knownMimeTypes) {
                    FileObject fileObject3 = object2.getFileObject(string);
                    fileObject = KitsTrackerImpl.findKitRegistration(fileObject3);
                    if (fileObject != null) {
                        this.mimeType2kitClass.put(string, fileObject);
                        continue;
                    }
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("No kit for '" + string + "'");
                }
                long l2 = System.currentTimeMillis();
                TIMER.log(Level.FINE, "Kits scan", new Object[]{this, l2 - l});
                TIMER.log(Level.FINE, "[M] Kits", new Object[]{this, this.mimeType2kitClass.size()});
            }
            if (object instanceof Class) {
                void var7_16;
                Class clazz = (Class)object;
                List<String> list = this.kitClass2mimeTypes.get(clazz);
                if (list == null) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    this.kitClass2mimeTypes.put(clazz, arrayList2);
                    for (object2 = clazz; object2 != null && !WELL_KNOWN_PARENTS.contains(((Class)object2).getName()); object2 = ((Class)object2).getSuperclass()) {
                        boolean bl2 = (((Class)object2).getModifiers() & 0x10) != 0;
                        for (String string : this.mimeType2kitClass.keySet()) {
                            fileObject = this.mimeType2kitClass.get(string);
                            if (!KitsTrackerImpl.isInstanceOf(fileObject, (Class)object2, !bl2)) continue;
                            arrayList2.add(string);
                        }
                        if (!arrayList2.isEmpty()) break;
                    }
                }
                TIMER.log(Level.FINE, "[M] " + clazz.getSimpleName() + " used", new Object[]{this, var7_16.size()});
                return var7_16;
            }
            assert (object instanceof String);
            FileObject fileObject2 = this.mimeType2kitClass.get((String)object);
            return KitsTrackerImpl.instanceClass(fileObject2);
        }
    }
}

