/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class ModTimeResponse
implements Response {
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
    protected static final String SERVER_DATE_FORMAT = "dd MMM yyyy HH:mm:ss";

    ModTimeResponse() {
    }

    public void process(LoggedDataInputStream loggedDataInputStream, ResponseServices responseServices) throws ResponseException {
        try {
            String string = loggedDataInputStream.readLine();
            Date date = dateFormatter.parse(string.substring(0, string.length() - 6));
            if (date.getTime() < 0L) {
                if (date.getYear() < 100 && date.getYear() >= 70) {
                    date.setYear(date.getYear() + 1900);
                } else if (date.getYear() >= 0 && date.getYear() < 70) {
                    date.setYear(date.getYear() + 2000);
                } else {
                    date.setYear(2000 + date.getYear());
                }
            }
            responseServices.setNextFileDate(date);
        }
        catch (Exception exception) {
            throw new ResponseException(exception);
        }
    }

    public boolean isTerminalResponse() {
        return false;
    }

    static {
        dateFormatter.setTimeZone(Entry.getTimeZone());
    }
}

