/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateInformation;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class AnnotateBuilder
implements Builder {
    private static final String UNKNOWN = ": nothing known about";
    private static final String ANNOTATING = "Annotations for ";
    private static final String STARS = "***************";
    private AnnotateInformation annotateInformation;
    private final EventManager eventManager;
    private final String localPath;
    private String relativeDirectory;
    private int lineNum;
    private File tempDir;

    public AnnotateBuilder(EventManager eventManager, BasicCommand basicCommand) {
        this.eventManager = eventManager;
        this.localPath = basicCommand.getLocalDirectory();
        this.tempDir = basicCommand.getGlobalOptions().getTempDir();
    }

    public void outputDone() {
        if (this.annotateInformation == null) {
            return;
        }
        try {
            this.annotateInformation.closeTempFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.annotateInformation));
        this.annotateInformation = null;
    }

    public void parseLine(String string, boolean bl) {
        if (bl && string.startsWith(ANNOTATING)) {
            this.outputDone();
            this.annotateInformation = new AnnotateInformation(this.tempDir);
            this.annotateInformation.setFile(this.createFile(string.substring(ANNOTATING.length())));
            this.lineNum = 0;
            return;
        }
        if (bl && string.startsWith(STARS)) {
            return;
        }
        if (!bl) {
            this.processLines(string);
        }
    }

    private File createFile(String string) {
        return new File(this.localPath, string);
    }

    public void parseEnhancedMessage(String string, Object object) {
    }

    private void processLines(String string) {
        if (this.annotateInformation != null) {
            try {
                this.annotateInformation.addToTempFile(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static AnnotateLine processLine(String string) {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        AnnotateLine annotateLine = null;
        if (n > 0 && n2 > n) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1, n2);
            String string4 = string.substring(n2 + 3);
            int n3 = string3.lastIndexOf(32);
            String string5 = string3;
            String string6 = string3;
            if (n3 > 0) {
                string5 = string3.substring(0, n3).trim();
                string6 = string3.substring(n3).trim();
            }
            annotateLine = new AnnotateLine();
            annotateLine.setContent(string4);
            annotateLine.setAuthor(string5);
            annotateLine.setDateString(string6);
            annotateLine.setRevision(string2);
        }
        return annotateLine;
    }
}

