/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RefactoringContextActionsProvider
implements Class2LayerFolder<RefactoringContextActionsProvider>,
InstanceProvider<RefactoringContextActionsProvider> {
    private static final Logger LOG = Logger.getLogger(RefactoringContextActionsProvider.class.getName());
    private final List<FileObject> fileObjectList;
    private JComponent[] menuItems;

    public RefactoringContextActionsProvider() {
        this.fileObjectList = Collections.emptyList();
    }

    public RefactoringContextActionsProvider(List<FileObject> list) {
        this.fileObjectList = list;
    }

    public Class<RefactoringContextActionsProvider> getClazz() {
        return RefactoringContextActionsProvider.class;
    }

    public String getLayerFolderName() {
        return "RefactoringActions";
    }

    public InstanceProvider<RefactoringContextActionsProvider> getInstanceProvider() {
        return this;
    }

    public RefactoringContextActionsProvider createInstance(List<FileObject> list) {
        return new RefactoringContextActionsProvider(list);
    }

    public JComponent[] getMenuItems(boolean bl) {
        assert (EventQueue.isDispatchThread());
        if (this.menuItems == null || bl) {
            List<JComponent> list = this.createMenuItems();
            this.menuItems = list.toArray(new JComponent[list.size()]);
        }
        return this.menuItems;
    }

    private List<JComponent> createMenuItems() {
        if (this.fileObjectList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(this.fileObjectList.size() + 1);
        for (FileObject fileObject : this.fileObjectList) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
                if (instanceCookie == null) continue;
                Object object = instanceCookie.instanceCreate();
                RefactoringContextActionsProvider.resolveInstance(object, arrayList);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(Level.WARNING, fileObject.toString(), dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, fileObject.toString(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.WARNING, fileObject.toString(), classNotFoundException);
            }
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.get(0) instanceof JSeparator) {
                arrayList.set(0, null);
            } else {
                arrayList.add(0, null);
            }
        }
        return arrayList;
    }

    private static void resolveInstance(Object object, List<JComponent> list) throws IOException {
        if (object instanceof Presenter.Popup) {
            JMenuItem jMenuItem = ((Presenter.Popup)object).getPopupPresenter();
            list.add(jMenuItem);
        } else if (object instanceof JSeparator) {
            list.add(null);
        } else if (object instanceof JComponent) {
            list.add((JComponent)object);
        } else if (object instanceof Action) {
            Actions.MenuItem menuItem = new Actions.MenuItem((Action)object, true);
            list.add((JComponent)menuItem);
        } else {
            throw new IOException(String.format("Unsupported instance: %s, class: %s", object, object.getClass()));
        }
    }
}

