/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.actions;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectActionBase
extends NodeAction {
    private final boolean enabledAction;
    private boolean running;
    private JMenuItem presenter;
    private boolean inited = false;

    public ProjectActionBase(boolean bl) {
        this.enabledAction = bl;
    }

    protected abstract void performAction(Collection<CsmProject> var1);

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private JMenuItem getPresenter() {
        if (!this.inited) {
            this.presenter = new JMenuItem();
            Actions.connect((JMenuItem)this.presenter, (Action)((Object)this), (boolean)true);
            this.inited = true;
        }
        Collection<CsmProject> collection = this.getCsmProjects(this.getActivatedNodes());
        if (this.enabledAction) {
            if (collection == null) {
                this.setEnabled(!this.running);
                this.presenter.setVisible(false);
            } else {
                try {
                    this.presenter.setVisible(true);
                    this.setEnabled(!this.running);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.setEnabled(false);
                }
            }
        } else {
            this.presenter.setVisible(false);
        }
        return this.presenter;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] nodeArray) {
        if (!this.enabledAction) {
            return false;
        }
        if (this.running) {
            return false;
        }
        Collection<CsmProject> collection = this.getCsmProjects(nodeArray);
        if (collection == null) {
            return false;
        }
        return this.getState(collection) != State.Indeterminate;
    }

    public void performAction(final Node[] nodeArray) {
        this.running = true;
        CsmModelAccessor.getModel().enqueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ProjectActionBase.this.performAction(ProjectActionBase.this.getCsmProjects(nodeArray));
                }
                finally {
                    ProjectActionBase.this.running = false;
                }
            }
        }, (CharSequence)("csmproject action " + this.getName()));
    }

    protected boolean asynchronous() {
        return false;
    }

    protected Collection<CsmProject> getCsmProjects(Node[] nodeArray) {
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        for (int i = 0; i < nodeArray.length; ++i) {
            CsmProject csmProject = (CsmProject)nodeArray[i].getLookup().lookup(CsmProject.class);
            if (csmProject == null) {
                Object object;
                NativeProject nativeProject = (NativeProject)nodeArray[i].getLookup().lookup(NativeProject.class);
                if (nativeProject == null && (object = nodeArray[i].getValue("Project")) instanceof Project) {
                    nativeProject = (NativeProject)((Project)object).getLookup().lookup(NativeProject.class);
                }
                if (nativeProject != null) {
                    csmProject = CsmModelAccessor.getModel().getProject((Object)nativeProject);
                }
            }
            if (csmProject == null) continue;
            hashSet.add(csmProject);
        }
        return hashSet;
    }

    protected State getState(Collection<CsmProject> collection) {
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel == null || csmModel.getState() != CsmModelState.ON) {
            return State.Indeterminate;
        }
        State state = State.Indeterminate;
        for (CsmProject csmProject : collection) {
            State state2 = this.getState(csmProject);
            if (state == State.Indeterminate) {
                state = state2;
                continue;
            }
            if (state == state2) continue;
            return State.Indeterminate;
        }
        return state;
    }

    private State getState(CsmProject csmProject) {
        return csmProject != null && csmProject.isStable(null) ? State.Enabled : State.Disabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        Enabled,
        Disabled,
        Indeterminate;

    }
}

