/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

public final class ParserThread
implements Runnable {
    private volatile boolean stopped = false;
    private boolean isStoped = false;

    ParserThread() {
    }

    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._run();
        }
        finally {
            this.isStoped = true;
        }
    }

    public boolean isStoped() {
        return this.isStoped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void _run() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            this.trace("started");
        }
        ParserQueue parserQueue = ParserQueue.instance();
        while (!this.stopped) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                this.trace("polling queue");
            }
            try {
                Object var14_15;
                Diagnostic.StopWatch stopWatch;
                FileImpl fileImpl;
                String string;
                Thread thread;
                block30: {
                    block29: {
                        ParserQueue.Entry entry = parserQueue.poll();
                        if (entry == null) {
                            if (TraceFlags.TRACE_PARSER_QUEUE) {
                                this.trace("waiting");
                            }
                            this.isStoped = true;
                            parserQueue.waitReady();
                            this.isStoped = false;
                            continue;
                        }
                        thread = Thread.currentThread();
                        string = thread.getName();
                        fileImpl = entry.getFile();
                        thread.setName(string + ": Parsing " + fileImpl.getAbsolutePath());
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            this.trace("parsing started: " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
                        }
                        stopWatch = TraceFlags.TIMING_PARSE_PER_FILE_FLAT ? new Diagnostic.StopWatch() : null;
                        Collection<APTPreprocHandler.State> collection = entry.getPreprocStates();
                        Collection<APTPreprocHandler> collection2 = new ArrayList<APTPreprocHandler>(collection.size());
                        ProjectBase projectBase = fileImpl.getProjectImpl(true);
                        for (APTPreprocHandler.State state : collection) {
                            if (projectBase.isDisposing()) continue;
                            if (state == FileImpl.DUMMY_STATE) {
                                assert (collection.size() == 1) : "Dummy state sould never be mixed with normal states";
                                collection2 = FileImpl.DUMMY_HANDLERS;
                                break;
                            }
                            APTPreprocHandler aPTPreprocHandler = projectBase.createPreprocHandler(fileImpl.getBuffer().getFile(), state);
                            if (TraceFlags.TRACE_PARSER_QUEUE) {
                                System.err.println("before ensureParse on " + fileImpl.getAbsolutePath() + ParserQueue.tracePreprocState(state));
                            }
                            collection2.add(aPTPreprocHandler);
                        }
                        if (projectBase.isDisposing()) break block29;
                        fileImpl.ensureParsed(collection2);
                    }
                    var14_15 = null;
                    if (stopWatch == null) break block30;
                    stopWatch.stopAndReport("parsing " + fileImpl.getAbsolutePath());
                }
                try {
                    parserQueue.onFileParsingFinished(fileImpl);
                    if (TraceFlags.TRACE_PARSER_QUEUE) {
                        this.trace("parsing done for " + fileImpl.getAbsolutePath() + " took " + fileImpl.getLastParseTime() + "ms");
                    }
                    Notificator.instance().flush();
                    if (TraceFlags.TRACE_PARSER_QUEUE) {
                        this.trace("model event flushed");
                    }
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace(System.err);
                }
                thread.setName(string);
                {
                    continue;
                    catch (Throwable throwable) {
                        DiagnosticExceptoins.register(throwable);
                        var14_15 = null;
                        if (stopWatch != null) {
                            stopWatch.stopAndReport("parsing " + fileImpl.getAbsolutePath());
                        }
                        try {
                            parserQueue.onFileParsingFinished(fileImpl);
                            if (TraceFlags.TRACE_PARSER_QUEUE) {
                                this.trace("parsing done for " + fileImpl.getAbsolutePath() + " took " + fileImpl.getLastParseTime() + "ms");
                            }
                            Notificator.instance().flush();
                            if (TraceFlags.TRACE_PARSER_QUEUE) {
                                this.trace("model event flushed");
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable2.printStackTrace(System.err);
                        }
                        thread.setName(string);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    if (stopWatch != null) {
                        stopWatch.stopAndReport("parsing " + fileImpl.getAbsolutePath());
                    }
                    try {
                        parserQueue.onFileParsingFinished(fileImpl);
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            this.trace("parsing done for " + fileImpl.getAbsolutePath() + " took " + fileImpl.getLastParseTime() + "ms");
                        }
                        Notificator.instance().flush();
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            this.trace("model event flushed");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace(System.err);
                    }
                    thread.setName(string);
                    throw throwable;
                }
            }
            catch (InterruptedException interruptedException) {
                if (!TraceFlags.TRACE_PARSER_QUEUE) break;
                this.trace("interrupted");
                break;
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            this.trace(this.stopped ? "stopped" : "finished");
        }
    }

    private void trace(String string) {
        System.err.println(Thread.currentThread().getName() + ": " + string);
    }
}

