/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.api.editor.PhpElement;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.netbeans.modules.php.editor.DocRenderer;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.PHPCompletionResult;
import org.netbeans.modules.php.editor.PHPDOCCodeCompletion;
import org.netbeans.modules.php.editor.PhpElementCompletionItem;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedClassMember;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.IndexedNamespace;
import org.netbeans.modules.php.editor.index.IndexedVariable;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.ParameterInfoSupport;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.QualifiedNameKind;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.options.CodeCompletionPanel;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.project.api.PhpEditorExtender;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPCodeCompletion
implements CodeCompletionHandler {
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());
    static final Map<String, CompletionContextFinder.KeywordCompletionType> PHP_KEYWORDS = new HashMap<String, CompletionContextFinder.KeywordCompletionType>();
    private static final String[] PHP_KEYWORD_FUNCTIONS;
    static final String[] PHP_CLASS_KEYWORDS;
    private static final Collection<Character> AUTOPOPUP_STOP_CHARS;
    private static final Collection<PHPTokenId> TOKENS_TRIGGERING_AUTOPUP_TYPES_WS;
    private static final List<String> INVALID_PROPOSALS_FOR_CLS_MEMBERS;
    private static final List<String> CLASS_CONTEXT_KEYWORD_PROPOSAL;
    private static final List<String> INHERITANCE_KEYWORDS;
    private boolean caseSensitive;
    private QuerySupport.Kind nameKind;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        CompletionContextFinder.CompletionContext completionContext;
        PHPParseResult pHPParseResult2;
        int n;
        ParserResult parserResult;
        ArrayList<CompletionProposal> arrayList;
        String string;
        long l;
        block37: {
            block36: {
                l = 0L;
                if (LOGGER.isLoggable(Level.FINE)) {
                    l = System.currentTimeMillis();
                }
                string = codeCompletionContext.getPrefix();
                arrayList = new ArrayList<CompletionProposal>();
                BaseDocument baseDocument = (BaseDocument)codeCompletionContext.getParserResult().getSnapshot().getSource().getDocument(false);
                if (baseDocument == null) {
                    return CodeCompletionResult.NONE;
                }
                parserResult = codeCompletionContext.getParserResult();
                n = codeCompletionContext.getCaretOffset();
                this.caseSensitive = codeCompletionContext.isCaseSensitive();
                this.nameKind = this.caseSensitive ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX;
                pHPParseResult2 = (PHPParseResult)parserResult;
                if (pHPParseResult2.getProgram() != null) break block36;
                CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                return codeCompletionResult;
            }
            completionContext = CompletionContextFinder.findCompletionContext(parserResult, n);
            LOGGER.fine("CC context: " + (Object)((Object)completionContext));
            if (completionContext != CompletionContextFinder.CompletionContext.NONE) break block37;
            CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
            return codeCompletionResult;
        }
        PHPCompletionItem.CompletionRequest completionRequest = new PHPCompletionItem.CompletionRequest();
        completionRequest.anchor = n - this.getPrefix(parserResult, n, true).length();
        completionRequest.result = pHPParseResult2;
        completionRequest.info = parserResult;
        completionRequest.prefix = string;
        completionRequest.index = PHPIndex.get(parserResult);
        try {
            completionRequest.currentlyEditedFileURL = pHPParseResult2.getSnapshot().getSource().getFileObject().getURL().toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        switch (completionContext) {
            case NAMESPACE_KEYWORD: {
                this.autoCompleteNamespaces(arrayList, completionRequest, QualifiedNameKind.QUALIFIED);
                break;
            }
            case GLOBAL: {
                this.autoCompleteGlobals(arrayList, completionRequest);
                break;
            }
            case EXPRESSION: {
                this.autoCompleteNamespaces(arrayList, completionRequest);
                this.autoCompleteExpression(arrayList, completionRequest);
                this.autoCompleteExternals(arrayList, completionRequest);
                break;
            }
            case HTML: {
                arrayList.add(new PHPCompletionItem.KeywordItem("<?php", completionRequest));
                arrayList.add(new PHPCompletionItem.KeywordItem("<?=", completionRequest));
                break;
            }
            case NEW_CLASS: {
                this.autoCompleteNamespaces(arrayList, completionRequest);
                NamespaceIndexFilter<IndexedFunction> namespaceIndexFilter = new NamespaceIndexFilter<IndexedFunction>(string);
                Collection<IndexedFunction> collection = completionRequest.index.getConstructors(pHPParseResult2, namespaceIndexFilter.getName());
                for (IndexedFunction indexedFunction : namespaceIndexFilter.filter(collection)) {
                    int[] nArray = indexedFunction.getOptionalArgs();
                    for (int i = 0; i <= nArray.length; ++i) {
                        arrayList.add(new PHPCompletionItem.NewClassItem(indexedFunction, completionRequest, i));
                    }
                }
                break;
            }
            case CLASS_NAME: {
                this.autoCompleteNamespaces(arrayList, completionRequest);
                this.autoCompleteClassNames(arrayList, completionRequest, false);
                break;
            }
            case INTERFACE_NAME: {
                this.autoCompleteNamespaces(arrayList, completionRequest);
                this.autoCompleteInterfaceNames(arrayList, completionRequest);
                break;
            }
            case USE_KEYWORD: {
                this.autoCompleteNamespaces(arrayList, completionRequest, QualifiedNameKind.QUALIFIED);
                this.autoCompleteTypeNames(arrayList, completionRequest, QualifiedNameKind.QUALIFIED);
                break;
            }
            case TYPE_NAME: {
                this.autoCompleteNamespaces(arrayList, completionRequest);
                this.autoCompleteTypeNames(arrayList, completionRequest);
                break;
            }
            case STRING: {
                arrayList.addAll(this.getVariableProposals(completionRequest.result.getProgram(), completionRequest));
                break;
            }
            case CLASS_MEMBER: {
                this.autoCompleteClassMembers(arrayList, completionRequest, false);
                break;
            }
            case STATIC_CLASS_MEMBER: {
                this.autoCompleteClassMembers(arrayList, completionRequest, true);
                break;
            }
            case PHPDOC: {
                if (PHPDOCCodeCompletion.isTypeCtx(completionRequest)) {
                    this.autoCompleteTypeNames(arrayList, completionRequest);
                    break;
                }
                PHPDOCCodeCompletion.complete(arrayList, completionRequest);
                break;
            }
            case CLASS_CONTEXT_KEYWORDS: {
                this.autoCompleteInClassContext(parserResult, n, arrayList, completionRequest);
                break;
            }
            case METHOD_NAME: {
                this.autoCompleteMethodName(parserResult, n, arrayList, completionRequest);
                break;
            }
            case IMPLEMENTS: {
                this.autoCompleteKeywords(arrayList, completionRequest, Collections.singletonList("implements"));
                break;
            }
            case EXTENDS: {
                this.autoCompleteKeywords(arrayList, completionRequest, Collections.singletonList("extends"));
                break;
            }
            case INHERITANCE: {
                this.autoCompleteKeywords(arrayList, completionRequest, INHERITANCE_KEYWORDS);
                break;
            }
            case SERVER_ENTRY_CONSTANTS: {
                for (String string2 : PredefinedSymbols.SERVER_ENTRY_CONSTANTS) {
                    if (!string2.startsWith(completionRequest.prefix)) continue;
                    arrayList.add(new PHPCompletionItem.KeywordItem(string2, completionRequest){

                        public ImageIcon getIcon() {
                            return null;
                        }
                    });
                }
                break;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            long l2 = System.currentTimeMillis() - l;
            LOGGER.fine(String.format("complete() took %d ms, result contains %d items", l2, arrayList.size()));
        }
        ArrayList<Object> arrayList2 = arrayList;
        if (!codeCompletionContext.isPrefixMatch()) {
            arrayList2 = new ArrayList();
            for (CompletionProposal completionProposal : arrayList) {
                if (!string.equals(completionProposal.getName())) continue;
                arrayList2.add(completionProposal);
            }
        }
        return new PHPCompletionResult(codeCompletionContext, arrayList2);
    }

    private void autoCompleteClassNames(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, boolean bl) {
        this.autoCompleteClassNames(list, completionRequest, bl, null);
    }

    private void autoCompleteClassNames(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, boolean bl, QualifiedNameKind qualifiedNameKind) {
        NamespaceIndexFilter<IndexedClass> namespaceIndexFilter = new NamespaceIndexFilter<IndexedClass>(completionRequest.prefix);
        Collection<IndexedClass> collection = completionRequest.index.getClasses(completionRequest.result, namespaceIndexFilter.getName(), this.nameKind);
        for (IndexedClass indexedClass : namespaceIndexFilter.filter(collection)) {
            list.add(new PHPCompletionItem.ClassItem(indexedClass, completionRequest, bl, qualifiedNameKind));
        }
    }

    private void autoCompleteInterfaceNames(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        this.autoCompleteInterfaceNames(list, completionRequest, null);
    }

    private void autoCompleteInterfaceNames(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, QualifiedNameKind qualifiedNameKind) {
        NamespaceIndexFilter<IndexedInterface> namespaceIndexFilter = new NamespaceIndexFilter<IndexedInterface>(completionRequest.prefix);
        Collection<IndexedInterface> collection = completionRequest.index.getInterfaces(completionRequest.result, namespaceIndexFilter.getName(), this.nameKind);
        for (IndexedInterface indexedInterface : namespaceIndexFilter.filter(collection)) {
            list.add(new PHPCompletionItem.InterfaceItem(indexedInterface, completionRequest, qualifiedNameKind, false));
        }
    }

    private void autoCompleteTypeNames(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        this.autoCompleteTypeNames(list, completionRequest, null);
    }

    /*
     * WARNING - void declaration
     */
    private void autoCompleteTypeNames(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, QualifiedNameKind qualifiedNameKind) {
        NamespaceIndexFilter<IndexedInterface> namespaceIndexFilter = new NamespaceIndexFilter<IndexedInterface>(completionRequest.prefix);
        if (namespaceIndexFilter.getName().trim().length() > 0) {
            Collection<IndexedInterface> collection = completionRequest.index.getInterfaces(completionRequest.result, namespaceIndexFilter.getName(), this.nameKind);
            for (IndexedInterface object2 : namespaceIndexFilter.filter(collection)) {
                list.add(new PHPCompletionItem.InterfaceItem(object2, completionRequest, qualifiedNameKind, false));
            }
            NamespaceIndexFilter namespaceIndexFilter2 = new NamespaceIndexFilter(completionRequest.prefix);
            Collection<IndexedClass> collection2 = completionRequest.index.getClasses(completionRequest.result, namespaceIndexFilter.getName(), this.nameKind);
            for (IndexedClass indexedClass : namespaceIndexFilter2.filter(collection2)) {
                list.add(new PHPCompletionItem.ClassItem(indexedClass, completionRequest, false, qualifiedNameKind));
            }
        } else {
            void var7_14;
            NamespaceIndexFilter namespaceIndexFilter3 = new NamespaceIndexFilter(completionRequest.prefix);
            CodeCompletionPanel.VariablesScope variablesScope = OptionsUtils.codeCompletionVariablesScope();
            Object var7_11 = null;
            if (variablesScope.equals((Object)CodeCompletionPanel.VariablesScope.ALL)) {
                Collection<IndexedElement> collection = completionRequest.index.getAllTopLevel(completionRequest.result, namespaceIndexFilter3.getName(), this.nameKind);
            } else {
                EnumSet<PhpKind> enumSet = EnumSet.allOf(PhpKind.class);
                enumSet.remove((Object)PhpKind.VARIABLE);
                Collection<IndexedElement> collection = completionRequest.index.getAllTopLevel(completionRequest.result, namespaceIndexFilter3.getName(), this.nameKind, enumSet);
            }
            for (IndexedElement indexedElement : namespaceIndexFilter3.filter(var7_14)) {
                if (indexedElement instanceof IndexedClass) {
                    list.add(new PHPCompletionItem.ClassItem((IndexedClass)indexedElement, completionRequest, false, qualifiedNameKind));
                    continue;
                }
                if (!(indexedElement instanceof IndexedInterface)) continue;
                list.add(new PHPCompletionItem.InterfaceItem((IndexedInterface)indexedElement, completionRequest, qualifiedNameKind, false));
            }
        }
    }

    private void autoCompleteMagicItems(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, Collection<String> collection, boolean bl, Set<String> set) {
        for (String string : collection) {
            IndexedFunction indexedFunction;
            if (!string.startsWith(completionRequest.prefix) || set.contains(string) || (indexedFunction = PredefinedSymbols.MAGIC_METHODS.get(string)) == null) continue;
            if (bl) {
                list.add(new PHPCompletionItem.MagicMethodNameItem(indexedFunction, completionRequest));
                continue;
            }
            list.add(new PHPCompletionItem.MagicMethodItem(indexedFunction, completionRequest));
        }
    }

    private void autoCompleteKeywords(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, List<String> list2) {
        for (String string : list2) {
            if (!string.startsWith(completionRequest.prefix)) continue;
            list.add(new PHPCompletionItem.KeywordItem(string, completionRequest));
        }
    }

    private void autoCompleteNamespaces(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        this.autoCompleteNamespaces(list, completionRequest, null);
    }

    private void autoCompleteNamespaces(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, QualifiedNameKind qualifiedNameKind) {
        NamespaceIndexFilter<IndexedNamespace> namespaceIndexFilter = new NamespaceIndexFilter<IndexedNamespace>(completionRequest.prefix);
        String string = namespaceIndexFilter.getName();
        Collection<IndexedNamespace> collection = completionRequest.index.getNamespaces(completionRequest.result, string);
        collection = namespaceIndexFilter.filter(collection);
        for (IndexedNamespace indexedNamespace : collection) {
            list.add(new PHPCompletionItem.NamespaceItem(indexedNamespace, completionRequest, qualifiedNameKind));
        }
    }

    private void autoCompleteMethodName(ParserResult parserResult, int n, List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        ClassDeclaration classDeclaration = PHPCodeCompletion.findEnclosingClass(parserResult, CompletionContextFinder.lexerToASTOffset(parserResult, n));
        if (classDeclaration != null) {
            String string = classDeclaration.getName().getName();
            HashSet<String> hashSet = new HashSet<String>();
            Collection<IndexedFunction> collection = completionRequest.index.getMethods(completionRequest.result, string, completionRequest.prefix, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, -1);
            for (IndexedFunction indexedFunction : collection) {
                hashSet.add(indexedFunction.getName());
            }
            this.autoCompleteMagicItems(list, completionRequest, PredefinedSymbols.MAGIC_METHODS.keySet(), true, hashSet);
        }
    }

    private void autoCompleteInClassContext(ParserResult parserResult, int n, List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        Collection<IndexedFunction> collection;
        Object object;
        Object object2;
        TokenHierarchy tokenHierarchy = parserResult.getSnapshot().getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(PHPTokenId.language());
        assert (tokenSequence != null);
        tokenSequence.move(n);
        boolean bl = true;
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            object2 = tokenSequence.token();
            int n2 = tokenSequence.token().offset(tokenHierarchy);
            bl = !CompletionContextFinder.lineContainsAny((Token<PHPTokenId>)object2, n - n2, (TokenSequence<PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PROTECTED, PHPTokenId.PHP_ABSTRACT, PHPTokenId.PHP_VAR, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_CONST));
        }
        this.autoCompleteKeywords(list, completionRequest, CLASS_CONTEXT_KEYWORD_PROPOSAL);
        object2 = PHPCodeCompletion.findEnclosingClass(parserResult, CompletionContextFinder.lexerToASTOffset(parserResult, n));
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        if (object2 != null) {
            object = ((TypeDeclaration)object2).getName().getName();
            collection = completionRequest.index.getMethods(completionRequest.result, (String)object, completionRequest.prefix, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, -1);
            for (IndexedFunction iterator : collection) {
                hashSet.add(iterator.getName());
                hashSet2.add(iterator.getName());
            }
        }
        if (object2 != null && bl) {
            Object object3;
            Collection<IndexedClassMember<IndexedFunction>> collection2;
            object = ((ClassDeclaration)object2).getSuperClass();
            if (object != null) {
                collection = CodeUtils.extractUnqualifiedSuperClassName((ClassDeclaration)object2);
                collection2 = completionRequest.index.getAllMethods(completionRequest.result, (String)((Object)collection), completionRequest.prefix, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, 5);
                for (IndexedClassMember<IndexedFunction> indexedClassMember : collection2) {
                    object3 = indexedClassMember.getMember();
                    if (!((IndexedElement)object3).getName().startsWith(completionRequest.prefix) || ((IndexedElement)object3).isFinal() || hashSet.contains(((IndexedElement)object3).getName()) || hashSet2.contains(((IndexedElement)object3).getName())) continue;
                    for (int i = 0; i <= ((IndexedFunction)object3).getOptionalArgs().length; ++i) {
                        hashSet2.add(((IndexedElement)object3).getName());
                        list.add(new PHPCompletionItem.FunctionDeclarationItem((IndexedFunction)object3, completionRequest, i, false));
                    }
                }
            }
            collection = ((TypeDeclaration)object2).getInterfaes();
            for (Expression expression : collection) {
                String string = CodeUtils.extractUnqualifiedName(expression);
                object3 = completionRequest.index.getAllMethods(completionRequest.result, string, completionRequest.prefix, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, 5);
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    IndexedClassMember indexedClassMember = (IndexedClassMember)iterator.next();
                    IndexedFunction indexedFunction = (IndexedFunction)indexedClassMember.getMember();
                    if (!indexedFunction.getName().startsWith(completionRequest.prefix) || indexedFunction.isFinal() || hashSet2.contains(indexedFunction.getName())) continue;
                    for (int i = 0; i <= indexedFunction.getOptionalArgs().length; ++i) {
                        hashSet2.add(indexedFunction.getName());
                        list.add(new PHPCompletionItem.FunctionDeclarationItem(indexedFunction, completionRequest, i, true));
                    }
                }
            }
            collection2 = new ArrayList();
            for (String string : PredefinedSymbols.MAGIC_METHODS.keySet()) {
                if (hashSet2.contains(string)) continue;
                hashSet2.add(string);
                collection2.add((IndexedClassMember<IndexedFunction>)((Object)string));
            }
            this.autoCompleteMagicItems(list, completionRequest, collection2, false, hashSet);
        }
    }

    private void autoCompleteClassMembers(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest, boolean bl) {
        TokenHierarchy tokenHierarchy = completionRequest.info.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(tokenHierarchy, completionRequest.anchor);
        if (tokenSequence == null) {
            return;
        }
        tokenSequence.move(completionRequest.anchor);
        if (tokenSequence.movePrevious()) {
            String string;
            Object object;
            Object object2;
            boolean bl2 = !bl;
            int n = 1;
            if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                tokenSequence.movePrevious();
            }
            tokenSequence.movePrevious();
            String string2 = ((Object)tokenSequence.token().text()).toString();
            Collection<Object> collection = Collections.emptyList();
            List<String> list2 = INVALID_PROPOSALS_FOR_CLS_MEMBERS;
            Model model = completionRequest.result.getModel();
            if (string2.equals("self")) {
                collection = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, completionRequest.anchor);
                if (!collection.isEmpty()) {
                    bl = true;
                    n |= 6;
                }
            } else if (string2.equals("parent")) {
                list2 = Collections.emptyList();
                collection = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, completionRequest.anchor);
                if (!collection.isEmpty() && (object2 = (TypeScope)ModelUtils.getFirst(collection)) != null) {
                    bl2 = true;
                    bl = true;
                    n |= 4;
                }
            } else if (string2.equals("$this")) {
                if (bl) {
                    return;
                }
                collection = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, completionRequest.anchor);
                if (!collection.isEmpty()) {
                    bl = false;
                    bl2 = true;
                    n |= 6;
                }
            } else {
                if (bl && string2.startsWith("$")) {
                    return;
                }
                collection = ModelUtils.resolveTypeAfterReferenceToken(model, tokenSequence, completionRequest.anchor);
                if (collection.isEmpty() && (object2 = model.getVariableScope(completionRequest.anchor)) != null) {
                    FileObject fileObject;
                    EditorExtender typeScope;
                    tokenSequence.move(completionRequest.anchor);
                    object = VariousUtils.getVariableName(VariousUtils.getSemiType(tokenSequence, VariousUtils.State.START, (VariableScope)object2));
                    if (object != null && (string = (typeScope = PhpEditorExtender.forFileObject((FileObject)(fileObject = completionRequest.result.getSnapshot().getSource().getFileObject()))).getClass(fileObject, (String)object)) != null) {
                        collection = VariousUtils.getType((VariableScope)object2, string.getFullyQualifiedName(), completionRequest.anchor, true);
                    }
                }
            }
            if (collection != null) {
                object2 = new HashSet();
                object = PHPCodeCompletion.findEnclosingClass(completionRequest.info, CompletionContextFinder.lexerToASTOffset(completionRequest.result, completionRequest.anchor));
                for (TypeScope typeScope : collection) {
                    Collection<IndexedClassMember<IndexedConstant>> collection2;
                    if (object != null && (string = CodeUtils.extractClassName((ClassDeclaration)object)) != null && string.equalsIgnoreCase(typeScope.getName())) {
                        n |= 6;
                    }
                    string = typeScope.getName();
                    boolean bl3 = OptionsUtils.codeCompletionStaticMethods();
                    boolean bl4 = OptionsUtils.codeCompletionNonStaticMethods();
                    QualifiedName qualifiedName = typeScope.getNamespaceName().append(string);
                    if (!object2.add(qualifiedName)) continue;
                    Collection<IndexedClassMember<IndexedFunction>> collection3 = completionRequest.index.getAllMethods(completionRequest.result, qualifiedName, completionRequest.prefix, this.nameKind, n);
                    for (IndexedClassMember<IndexedFunction> indexedClassMember : collection3) {
                        collection2 = indexedClassMember.getMember();
                        if ((!bl || !((IndexedElement)((Object)collection2)).isStatic() && !bl4) && (!bl2 || ((IndexedElement)((Object)collection2)).isStatic() && !bl3)) continue;
                        for (int i = 0; i <= ((IndexedFunction)((Object)collection2)).getOptionalArgs().length; ++i) {
                            if (list2.contains(((IndexedElement)((Object)collection2)).getName())) continue;
                            list.add(new PHPCompletionItem.FunctionItem(indexedClassMember, completionRequest, i));
                        }
                    }
                    String string3 = bl && completionRequest.prefix.startsWith("$") ? completionRequest.prefix.substring(1) : completionRequest.prefix;
                    Collection<IndexedClassMember<IndexedConstant>> collection4 = completionRequest.index.getAllFields(completionRequest.result, qualifiedName, string3, this.nameKind, n);
                    for (IndexedClassMember indexedClassMember : collection4) {
                        IndexedConstant indexedConstant = (IndexedConstant)indexedClassMember.getMember();
                        if ((!bl || !indexedConstant.isStatic()) && (!bl2 || indexedConstant.isStatic())) continue;
                        PHPCompletionItem.VariableItem variableItem = new PHPCompletionItem.VariableItem(indexedClassMember, completionRequest);
                        if (!bl) {
                            variableItem.doNotInsertDollarPrefix();
                        }
                        list.add(variableItem);
                    }
                    if (!bl) continue;
                    collection2 = completionRequest.index.getAllTypeConstants(completionRequest.result, qualifiedName, completionRequest.prefix, this.nameKind);
                    for (IndexedClassMember<IndexedConstant> indexedClassMember : collection2) {
                        list.add(new PHPCompletionItem.ClassConstantItem(indexedClassMember, completionRequest));
                    }
                }
            }
        }
    }

    private static ClassDeclaration findEnclosingClass(ParserResult parserResult, int n) {
        List<ASTNode> list = NavUtils.underCaret(parserResult, n);
        for (ASTNode aSTNode : list) {
            if (!(aSTNode instanceof ClassDeclaration)) continue;
            return (ClassDeclaration)aSTNode;
        }
        return null;
    }

    private void autoCompleteExpression(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        Object object;
        Object object2;
        for (String localVariables : PHP_KEYWORDS.keySet()) {
            if (!this.startsWith(localVariables, completionRequest.prefix)) continue;
            list.add(new PHPCompletionItem.KeywordItem(localVariables, completionRequest));
        }
        for (String string : PHP_KEYWORD_FUNCTIONS) {
            if (!this.startsWith(string, completionRequest.prefix)) continue;
            list.add(new PHPCompletionItem.SpecialFunctionItem(string, completionRequest));
        }
        if (this.startsWith("return", completionRequest.prefix)) {
            list.add(new PHPCompletionItem.ReturnItem(completionRequest));
        }
        PHPIndex pHPIndex = completionRequest.index;
        LocalVariables localVariables = this.getLocalVariables(completionRequest.result, completionRequest.prefix, completionRequest.anchor, completionRequest.currentlyEditedFileURL);
        LinkedHashMap<String, IndexedVariable> linkedHashMap = new LinkedHashMap<String, IndexedVariable>();
        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
        NamespaceIndexFilter<IndexedElement> namespaceIndexFilter = new NamespaceIndexFilter<IndexedElement>(completionRequest.prefix);
        QualifiedNameKind qualifiedNameKind = namespaceIndexFilter.getKind();
        CodeCompletionPanel.VariablesScope variablesScope = OptionsUtils.codeCompletionVariablesScope();
        Collection<IndexedElement> collection = null;
        if (variablesScope.equals((Object)CodeCompletionPanel.VariablesScope.ALL)) {
            collection = completionRequest.index.getAllTopLevel(completionRequest.result, namespaceIndexFilter.getName(), this.nameKind);
        } else {
            object2 = EnumSet.allOf(PhpKind.class);
            ((AbstractCollection)object2).remove((Object)PhpKind.VARIABLE);
            collection = completionRequest.index.getAllTopLevel(completionRequest.result, namespaceIndexFilter.getName(), this.nameKind, (EnumSet<PhpKind>)object2);
        }
        if (!qualifiedNameKind.isUnqualified()) {
            collection = namespaceIndexFilter.filter(collection);
        }
        for (IndexedElement indexedElement : collection) {
            if (indexedElement instanceof IndexedFunction) {
                object = (IndexedFunction)indexedElement;
                for (int i = 0; i <= ((IndexedFunction)object).getOptionalArgs().length; ++i) {
                    list.add(new PHPCompletionItem.FunctionItem((IndexedFunction)object, completionRequest, i));
                }
                continue;
            }
            if (indexedElement instanceof IndexedClass) {
                list.add(new PHPCompletionItem.ClassItem((IndexedClass)indexedElement, completionRequest, true, null));
                continue;
            }
            if (indexedElement instanceof IndexedInterface) {
                list.add(new PHPCompletionItem.InterfaceItem((IndexedInterface)indexedElement, completionRequest, true));
                continue;
            }
            if (indexedElement instanceof IndexedVariable) {
                if (!localVariables.globalContext || completionRequest.currentlyEditedFileURL.equals(((IndexedElement)(object = (IndexedVariable)indexedElement)).getFilenameUrl())) continue;
                IndexedVariable indexedVariable = (IndexedVariable)linkedHashMap.get(((IndexedElement)object).getName());
                if (indexedVariable == null) {
                    linkedHashMap.put(((IndexedElement)object).getName(), (IndexedVariable)object);
                    continue;
                }
                linkedHashMap2.put(((IndexedElement)object).getName(), object);
                continue;
            }
            if (!(indexedElement instanceof IndexedConstant)) continue;
            list.add(new PHPCompletionItem.ConstantItem((IndexedConstant)indexedElement, completionRequest));
        }
        for (IndexedVariable indexedVariable : localVariables.vars) {
            linkedHashMap.put(indexedVariable.getName(), indexedVariable);
            linkedHashMap2.remove(indexedVariable.getName());
        }
        for (IndexedVariable indexedVariable : linkedHashMap2.values()) {
            linkedHashMap.remove(indexedVariable.getName());
            object = new PHPCompletionItem.UnUniqueVaraibaleItems(indexedVariable, completionRequest);
            list.add((CompletionProposal)object);
        }
        for (IndexedVariable indexedVariable : linkedHashMap.values()) {
            CodeUtils.resolveFunctionType(completionRequest.result, pHPIndex, linkedHashMap, indexedVariable);
            object = new PHPCompletionItem.VariableItem(indexedVariable, completionRequest);
            list.add((CompletionProposal)object);
        }
        for (String string : PredefinedSymbols.SUPERGLOBALS) {
            if (!this.isPrefix("$" + string, completionRequest.prefix)) continue;
            object = new PHPCompletionItem.SuperGlobalItem(completionRequest, string);
            list.add((CompletionProposal)object);
        }
        object2 = PHPCodeCompletion.findEnclosingClass(completionRequest.info, CompletionContextFinder.lexerToASTOffset(completionRequest.result, completionRequest.anchor));
        if (object2 != null) {
            for (final String string : PHP_CLASS_KEYWORDS) {
                if (!this.startsWith(string, completionRequest.prefix)) continue;
                list.add(new PHPCompletionItem.KeywordItem(string, completionRequest, (ClassDeclaration)object2){
                    final /* synthetic */ ClassDeclaration val$classDecl;
                    {
                        this.val$classDecl = classDeclaration;
                        super(string3, completionRequest);
                    }

                    public String getLhsHtml(HtmlFormatter htmlFormatter) {
                        if (string.startsWith("$")) {
                            String string2 = CodeUtils.extractClassName(this.val$classDecl);
                            if (string2 != null) {
                                htmlFormatter.type(true);
                                htmlFormatter.appendText(string2);
                                htmlFormatter.type(false);
                            }
                            htmlFormatter.appendText(" ");
                        }
                        return super.getLhsHtml(htmlFormatter);
                    }
                });
            }
        }
    }

    private void autoCompleteGlobals(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        Collection collection;
        LinkedHashMap<String, IndexedVariable> linkedHashMap = new LinkedHashMap<String, IndexedVariable>();
        CodeCompletionPanel.VariablesScope variablesScope = OptionsUtils.codeCompletionVariablesScope();
        Collection<IndexedElement> collection2 = null;
        if (variablesScope.equals((Object)CodeCompletionPanel.VariablesScope.ALL)) {
            collection2 = completionRequest.index.getAllTopLevel(completionRequest.result, completionRequest.prefix, this.nameKind);
        } else {
            collection = EnumSet.allOf(PhpKind.class);
            ((AbstractCollection)collection).remove((Object)PhpKind.VARIABLE);
            collection2 = completionRequest.index.getAllTopLevel(completionRequest.result, completionRequest.prefix, this.nameKind, (EnumSet<PhpKind>)collection);
        }
        for (IndexedElement object : collection2) {
            if (!(object instanceof IndexedVariable)) continue;
            IndexedVariable indexedVariable = (IndexedVariable)object;
            linkedHashMap.put(indexedVariable.getName(), indexedVariable);
        }
        collection = linkedHashMap.values();
        for (IndexedVariable indexedVariable : collection) {
            String string = indexedVariable.getTypeName();
            if (indexedVariable.isResolved() && (string == null || !string.startsWith("@"))) {
                list.add(new PHPCompletionItem.VariableItem(indexedVariable, completionRequest));
                continue;
            }
            list.add(new PHPCompletionItem.UnUniqueVaraibaleItems(indexedVariable, completionRequest));
        }
    }

    private Collection<CompletionProposal> getVariableProposals(Program program, PHPCompletionItem.CompletionRequest completionRequest) {
        PHPCompletionItem pHPCompletionItem;
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        Collection<IndexedVariable> collection = this.getVariables(completionRequest.result, completionRequest.index, completionRequest.prefix, completionRequest.anchor, completionRequest.currentlyEditedFileURL);
        for (IndexedVariable object : collection) {
            pHPCompletionItem = new PHPCompletionItem.VariableItem(object, completionRequest);
            arrayList.add(pHPCompletionItem);
        }
        for (String string : PredefinedSymbols.SUPERGLOBALS) {
            if (!this.isPrefix("$" + string, completionRequest.prefix)) continue;
            pHPCompletionItem = new PHPCompletionItem.SuperGlobalItem(completionRequest, string);
            arrayList.add(pHPCompletionItem);
        }
        return arrayList;
    }

    public Collection<IndexedVariable> getVariables(PHPParseResult pHPParseResult, PHPIndex pHPIndex, String string, int n, String string2) {
        LocalVariables localVariables = this.getLocalVariables(pHPParseResult, string, n, string2);
        LinkedHashMap<String, IndexedVariable> linkedHashMap = new LinkedHashMap<String, IndexedVariable>();
        for (IndexedVariable indexedVariable : localVariables.vars) {
            linkedHashMap.put(indexedVariable.getName(), indexedVariable);
        }
        if (localVariables.globalContext) {
            for (IndexedVariable indexedVariable : pHPIndex.getTopLevelVariables(pHPParseResult, string, QuerySupport.Kind.PREFIX)) {
                IndexedVariable indexedVariable2;
                IndexedVariable indexedVariable3;
                if (string2.equals(indexedVariable.getFilenameUrl()) || (indexedVariable3 = (IndexedVariable)linkedHashMap.get(indexedVariable.getName())) != null && indexedVariable3.getOffset() == indexedVariable.getOffset() || (indexedVariable2 = linkedHashMap.put(indexedVariable.getName(), indexedVariable)) == null || !localVariables.vars.contains(indexedVariable2)) continue;
                linkedHashMap.put(indexedVariable2.getName(), indexedVariable2);
            }
        }
        for (IndexedVariable indexedVariable : linkedHashMap.values()) {
            CodeUtils.resolveFunctionType(pHPParseResult, pHPIndex, linkedHashMap, indexedVariable);
        }
        return linkedHashMap.values();
    }

    private boolean isPrefix(String string, String string2) {
        return string != null && (string.startsWith(string2) || this.nameKind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && string.toLowerCase().startsWith(string2.toLowerCase()));
    }

    private void autoCompleteExternals(List<CompletionProposal> list, PHPCompletionItem.CompletionRequest completionRequest) {
        FileObject fileObject = completionRequest.result.getSnapshot().getSource().getFileObject();
        EditorExtender editorExtender = PhpEditorExtender.forFileObject((FileObject)fileObject);
        for (PhpElement phpElement : editorExtender.getElementsForCodeCompletion(fileObject)) {
            list.add(PhpElementCompletionItem.fromPhpElement(phpElement, completionRequest));
        }
    }

    private LocalVariables getLocalVariables(PHPParseResult pHPParseResult, String string, int n, String string2) {
        HashMap<String, IndexedVariable> hashMap = new HashMap<String, IndexedVariable>();
        LocalVariables localVariables = new LocalVariables();
        localVariables.vars = hashMap.values();
        Model model = pHPParseResult.getModel();
        VariableScope variableScope = model.getVariableScope(n);
        if (variableScope != null) {
            localVariables.globalContext = variableScope instanceof NamespaceScope;
            List<? extends VariableName> list = ModelUtils.filter(variableScope.getDeclaredVariables(), QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, string);
            int n2 = n + string.length();
            for (VariableName variableName : list) {
                String string3;
                String string4;
                if (variableName.getNameRange().getEnd() >= n2 || PredefinedSymbols.SUPERGLOBALS.contains(string4 = (string3 = variableName.getName()).startsWith("$") ? string3.substring(1) : string3) || variableName.representsThis()) continue;
                Collection<? extends String> collection = variableName.getTypeNames(n);
                String string5 = collection.size() > 1 ? "mixed" : ModelUtils.getFirst(collection);
                IndexedVariable indexedVariable = new IndexedVariable(string3, null, null, string2, -1, 0, string5);
                hashMap.put(string3, indexedVariable);
            }
        }
        return localVariables;
    }

    public String document(ParserResult parserResult, ElementHandle elementHandle) {
        if (elementHandle instanceof ModelElement) {
            ModelElement modelElement = (ModelElement)elementHandle;
            Scope scope = modelElement.getInScope();
            String string = modelElement.getFileObject().getNameExt();
            String string2 = null;
            string2 = scope instanceof TypeScope ? (Object)((Object)modelElement.getPhpKind()) + ": " + scope.getName() + "<b> " + modelElement.getName() + " </b>" + "(" + string + ")" : (Object)((Object)modelElement.getPhpKind()) + ":<b> " + modelElement.getName() + " </b>" + "(" + string + ")";
            return String.format("<div align=\"right\"><font size=-1>%s</font></div>", string2);
        }
        return elementHandle instanceof PredefinedSymbols.MagicIndexedFunction ? null : DocRenderer.document(parserResult, elementHandle);
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        return null;
    }

    private static final boolean isPHPIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '@';
    }

    private static final boolean isPrefixBreaker(char c) {
        return !PHPCodeCompletion.isPHPIdentifierPart(c) && c != '\\' && c != '$' && c != ':';
    }

    public String getPrefix(ParserResult parserResult, int n, boolean bl) {
        try {
            BaseDocument baseDocument = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
            if (baseDocument == null) {
                return null;
            }
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n2 != -1) {
                int n3;
                int n4;
                String string;
                int n5;
                int n6;
                int n7 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                String string2 = baseDocument.getText(n2, n7 - n2);
                int n8 = n6 = n - n2;
                if (n6 > 0) {
                    int n9 = n6 - 1;
                    while (n9 >= 0 && (PHPCodeCompletion.isPHPIdentifierPart((char)(n5 = (int)string2.charAt(n9))) || n5 == 92)) {
                        n8 = n9--;
                    }
                }
                if (bl) {
                    string = string2.substring(n8, n6);
                    n5 = string.lastIndexOf(36);
                    if (n5 > 0) {
                        string = string.substring(n5);
                    }
                } else if (n6 == string2.length()) {
                    string = string2.substring(n8);
                } else {
                    char c;
                    n5 = string2.length();
                    n4 = n6;
                    for (n3 = n6; n3 < n5 && PHPCodeCompletion.isPHPIdentifierPart(c = string2.charAt(n3)); ++n3) {
                        n4 = n3 + 1;
                    }
                    string = string2.substring(n8, n4);
                }
                if (string.length() > 0) {
                    if (string.endsWith("::")) {
                        return "";
                    }
                    if (string.endsWith(":") && string.length() > 1) {
                        return null;
                    }
                    n5 = string.lastIndexOf("::");
                    if (n5 != -1) {
                        string = string.substring(n5 + 2);
                    }
                    if (string.length() == 1) {
                        n4 = string.charAt(0);
                        if (PHPCodeCompletion.isPrefixBreaker((char)n4)) {
                            return null;
                        }
                    } else {
                        for (n4 = string.length() - 2; n4 >= 0; --n4) {
                            n3 = string.charAt(n4);
                            if (n4 == 0 && n3 == 58 || !PHPCodeCompletion.isPrefixBreaker((char)n3)) continue;
                            string = string.substring(n4 + 1);
                            break;
                        }
                    }
                }
                if (string != null && string.startsWith("@")) {
                    TokenSequence<PHPTokenId> tokenSequence;
                    TokenHierarchy tokenHierarchy = parserResult.getSnapshot().getTokenHierarchy();
                    TokenSequence<PHPTokenId> tokenSequence2 = tokenSequence = tokenHierarchy != null ? LexUtilities.getPHPTokenSequence(tokenHierarchy, n) : null;
                    if (tokenSequence != null) {
                        Token token;
                        PHPTokenId pHPTokenId;
                        tokenSequence.move(n);
                        if (tokenSequence.moveNext() && tokenSequence.movePrevious() && ((pHPTokenId = (PHPTokenId)(token = tokenSequence.token()).id()).equals((Object)PHPTokenId.PHP_STRING) || pHPTokenId.equals((Object)PHPTokenId.PHP_TOKEN))) {
                            string = string.substring(1);
                        }
                    }
                }
                return string;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        int n;
        if (string.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char c = string.charAt(string.length() - 1);
        if (AUTOPOPUP_STOP_CHARS.contains(Character.valueOf(c))) {
            return CodeCompletionHandler.QueryType.STOP;
        }
        Document document = jTextComponent.getDocument();
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(document, n = jTextComponent.getCaretPosition());
        if (tokenSequence == null) {
            return CodeCompletionHandler.QueryType.STOP;
        }
        Token token = null;
        int n2 = tokenSequence.move(n);
        if (n2 > 0 && tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenId;
            token = tokenSequence.token();
            if (OptionsUtils.autoCompletionTypes()) {
                if (c == ' ' || c == '\t') {
                    if (tokenSequence.movePrevious() && TOKENS_TRIGGERING_AUTOPUP_TYPES_WS.contains(tokenSequence.token().id())) {
                        return CodeCompletionHandler.QueryType.ALL_COMPLETION;
                    }
                    return CodeCompletionHandler.QueryType.STOP;
                }
                if (token.id() == PHPTokenId.PHP_OBJECT_OPERATOR || token.id() == PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM) {
                    return CodeCompletionHandler.QueryType.ALL_COMPLETION;
                }
            }
            if (OptionsUtils.autoCompletionVariables() && (token.id() == PHPTokenId.PHP_TOKEN && c == '$' || token.id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && c == '$')) {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
            if (OptionsUtils.autoCompletionNamespaces() && token.id() == PHPTokenId.PHP_NS_SEPARATOR) {
                return PHPCodeCompletion.isPhp_53(document) ? CodeCompletionHandler.QueryType.ALL_COMPLETION : CodeCompletionHandler.QueryType.NONE;
            }
            if (token.id() == PHPTokenId.PHPDOC_COMMENT && c == '@') {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
            if (OptionsUtils.autoCompletionFull() && token != null && ((tokenId = token.id()).equals((Object)PHPTokenId.PHP_STRING) || tokenId.equals((Object)PHPTokenId.PHP_VARIABLE)) && token.length() > 0) {
                return CodeCompletionHandler.QueryType.ALL_COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public static boolean isPhp_53(Document document) {
        FileObject fileObject = CodeUtils.getFileObject(document);
        assert (fileObject != null);
        return fileObject != null ? CodeUtils.isPhp_53(fileObject) : false;
    }

    public String resolveTemplateVariable(String string, ParserResult parserResult, int n, String string2, Map map) {
        return null;
    }

    public Set<String> getApplicableTemplates(ParserResult parserResult, int n, int n2) {
        return null;
    }

    public ParameterInfo parameters(ParserResult parserResult, int n, CompletionProposal completionProposal) {
        Model model = ((PHPParseResult)parserResult).getModel();
        ParameterInfoSupport parameterInfoSupport = model.getParameterInfoSupport(n);
        return parameterInfoSupport.getParameterInfo();
    }

    private boolean startsWith(String string, String string2) {
        if (string2.length() == 0) {
            return true;
        }
        return this.caseSensitive ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    static {
        PHP_KEYWORDS.put("__FILE__", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("__LINE__", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("__FUNCTION__", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("__CLASS__", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("__METHOD__", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("use", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("namespace", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("php_user_filter", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("class", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("const", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("continue", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("function", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("new", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("static", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("var", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("final", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("interface", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("instanceof", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("implements", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("extends", CompletionContextFinder.KeywordCompletionType.SIMPLE);
        PHP_KEYWORDS.put("public", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("private", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("protected", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("abstract", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("clone", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("global", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("goto", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("throw", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SPACE);
        PHP_KEYWORDS.put("if", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("switch", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("for", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("array", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("die", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("eval", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("exit", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("empty", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("foreach", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("isset", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("list", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("print", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("unset", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("while", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("catch", CompletionContextFinder.KeywordCompletionType.CURSOR_INSIDE_BRACKETS);
        PHP_KEYWORDS.put("try", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_CURLY_BRACKETS);
        PHP_KEYWORDS.put("endif", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_SEMICOLON);
        PHP_KEYWORDS.put("case", CompletionContextFinder.KeywordCompletionType.ENDS_WITH_COLON);
        PHP_KEYWORD_FUNCTIONS = new String[]{"echo", "include", "include_once", "require", "require_once"};
        PHP_CLASS_KEYWORDS = new String[]{"$this->", "self::", "parent::"};
        AUTOPOPUP_STOP_CHARS = new TreeSet<Character>(Arrays.asList(Character.valueOf('='), Character.valueOf(';'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('?')));
        TOKENS_TRIGGERING_AUTOPUP_TYPES_WS = Arrays.asList(PHPTokenId.PHP_NEW, PHPTokenId.PHP_EXTENDS, PHPTokenId.PHP_IMPLEMENTS, PHPTokenId.PHP_INSTANCEOF);
        INVALID_PROPOSALS_FOR_CLS_MEMBERS = Arrays.asList("__construct", "__destruct");
        CLASS_CONTEXT_KEYWORD_PROPOSAL = Arrays.asList("abstract", "const", "function", "private", "final", "protected", "public", "static", "var");
        INHERITANCE_KEYWORDS = Arrays.asList("extends", "implements");
    }

    private class LocalVariables {
        Collection<IndexedVariable> vars;
        boolean globalContext;

        private LocalVariables() {
        }
    }
}

