/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider;

import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.AuthParam;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.ClientAuthModule;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.provider.AuthParamHelper;
import com.sun.xml.wss.provider.WssProviderAuthModule;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class ClientSecurityAuthModule
extends WssProviderAuthModule
implements ClientAuthModule {
    public void initialize(AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler handler, Map options) {
        super.initialize(requestPolicy, responsePolicy, handler, options, true);
    }

    public void secureRequest(AuthParam param, Subject subject, Map sharedState) throws AuthException {
        try {
            ProcessingContextImpl context = new ProcessingContextImpl();
            this._sEnvironment.setSubject(subject, context.getExtraneousProperties());
            if (sharedState != null) {
                sharedState.put("SELF_SUBJECT", subject);
            }
            MessagePolicy senderConfg = ((DeclarativeSecurityConfiguration)this._policy).senderSettings();
            SOAPMessage msg = AuthParamHelper.getRequest(param);
            context.setSecurityPolicy(senderConfg);
            context.setSOAPMessage(msg);
            context.setSecurityEnvironment(this._sEnvironment);
            if (this.optimize != 0 && this.isOptimized(msg)) {
                context.setConfigType(this.optimize);
            } else {
                try {
                    msg.getSOAPBody();
                    msg.getSOAPHeader();
                    context.setConfigType(0);
                }
                catch (SOAPException ex) {
                    throw new AuthException(ex.getMessage());
                }
            }
            SecurityAnnotator.secureMessage(context);
        }
        catch (XWSSecurityException xwsse) {
            xwsse.printStackTrace();
            throw new AuthException(xwsse.getMessage());
        }
    }

    public void validateResponse(AuthParam param, Subject subject, Map sharedState) throws AuthException {
        try {
            ProcessingContextImpl context = new ProcessingContextImpl();
            if (sharedState != null) {
                Subject selfSubject = (Subject)sharedState.get("SELF_SUBJECT");
                this._sEnvironment.setSubject(selfSubject, context.getExtraneousProperties());
            }
            this._sEnvironment.setRequesterSubject(subject, context.getExtraneousProperties());
            MessagePolicy receiverConfg = ((DeclarativeSecurityConfiguration)this._policy).receiverSettings();
            context.setSecurityPolicy(receiverConfg);
            context.setSOAPMessage(AuthParamHelper.getResponse(param));
            context.setSecurityEnvironment(this._sEnvironment);
            SecurityRecipient.validateMessage(context);
            context.getSecurableSoapMessage().deleteSecurityHeader();
        }
        catch (XWSSecurityException xwsse) {
            xwsse.printStackTrace();
            throw new AuthException(xwsse.getMessage());
        }
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
        if (subject == null) {
            throw new AuthException("Error disposing Subject: null value for Subject");
        }
        if (!subject.isReadOnly()) {
            return;
        }
        Set<Principal> principals = subject.getPrincipals();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        try {
            principals.clear();
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        Iterator<Object> pi = privateCredentials.iterator();
        while (pi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)pi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
            }
            catch (ClassCastException cce) {}
        }
        Iterator<Object> qi = publicCredentials.iterator();
        while (qi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)qi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
            }
            catch (ClassCastException cce) {}
        }
    }
}

