/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.textsync;

import java.util.Arrays;
import java.util.List;
import javax.swing.text.Position;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionManager;
import org.netbeans.lib.editor.codetemplates.textsync.TextSync;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.editor.util.swing.PositionRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextRegion<I> {
    private static final Position FIXED_ZERO_POSITION = PositionRegion.createFixedPosition((int)0);
    private Position startPos;
    private Position endPos;
    private TextSync textSync;
    private TextRegion<?> parent;
    private List<TextRegion<?>> regions;
    private I clientInfo;

    public static Position createFixedPosition(int n) {
        return PositionRegion.createFixedPosition((int)n);
    }

    public TextRegion() {
        this(FIXED_ZERO_POSITION, FIXED_ZERO_POSITION);
    }

    public TextRegion(int n, int n2) {
        this(PositionRegion.createFixedPosition((int)n), PositionRegion.createFixedPosition((int)n2));
    }

    public TextRegion(Position position, Position position2) {
        if (position == null) {
            throw new IllegalArgumentException("startPos cannot be null");
        }
        if (position2 == null) {
            throw new IllegalArgumentException("endPos cannot be null");
        }
        this.startPos = position;
        this.endPos = position2;
    }

    public int startOffset() {
        return this.startPos.getOffset();
    }

    public int endOffset() {
        return this.endPos.getOffset();
    }

    public void updateBounds(Position position, Position position2) {
        if (this.textRegionManager() != null) {
            throw new IllegalStateException("Change of bounds of region connected to textRegionManager prohibited.");
        }
        if (position != null) {
            this.setStartPos(position);
        }
        if (position2 != null) {
            this.setEndPos(position2);
        }
    }

    public I clientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(I i) {
        this.clientInfo = i;
    }

    public TextSync textSync() {
        return this.textSync;
    }

    void setTextSync(TextSync textSync) {
        this.textSync = textSync;
    }

    TextRegion<?> parent() {
        return this.parent;
    }

    void setParent(TextRegion<?> textRegion) {
        this.parent = textRegion;
    }

    List<TextRegion<?>> regions() {
        return this.regions;
    }

    List<TextRegion<?>> validRegions() {
        if (this.regions == null) {
            this.regions = new GapList(2);
        }
        return this.regions;
    }

    void initRegions(TextRegion<?>[] textRegionArray) {
        assert (this.regions == null || this.regions.size() == 0);
        this.regions = new GapList(Arrays.asList(textRegionArray));
    }

    void clearRegions() {
        this.regions = null;
    }

    void setStartPos(Position position) {
        this.startPos = position;
    }

    void setEndPos(Position position) {
        this.endPos = position;
    }

    TextRegionManager textRegionManager() {
        return this.textSync != null ? this.textSync.textRegionManager() : null;
    }

    public String toString() {
        return "<" + this.startOffset() + "," + this.endOffset() + ") IHC=" + System.identityHashCode(this) + ", parent=" + (this.parent != null ? Integer.valueOf(System.identityHashCode(this.parent)) : "null") + (this.clientInfo != null ? " clientInfo:" + this.clientInfo : "");
    }
}

