/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import javax.lang.model.element.Element;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.beans.BeanPanel;
import org.netbeans.modules.beans.BeanScanningTask;
import org.netbeans.modules.beans.ClassPattern;
import org.netbeans.modules.beans.PatternNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPanelUI
extends JPanel
implements ExplorerManager.Provider {
    private static WaitNode WAIT_NODE;
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private JLabel filtersLbl;
    private Lookup lookup = null;
    private Action[] actions;
    private static final Rectangle ZERO;

    public BeanPanelUI() {
        this.initComponents();
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.manager.setRootContext(BeanPanelUI.getWaitNode());
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return bl;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public BeanScanningTask getTask() {
        return new BeanScanningTask(this);
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BeanPanelUI.this.elementView.setRootVisible(true);
                BeanPanelUI.this.manager.setRootContext(BeanPanelUI.getWaitNode());
            }
        });
    }

    public void selectElementNode(ElementHandle<Element> elementHandle) {
    }

    public void refresh(final ClassPattern classPattern) {
        final PatternNode patternNode = this.getRootNode();
        if (patternNode != null && patternNode.getPattern().getPatternAnalyser().getFileObject().equals(classPattern.getPatternAnalyser().getFileObject())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    patternNode.updateRecursively(classPattern);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BeanPanelUI.this.elementView.setRootVisible(false);
                    BeanPanelUI.this.manager.setRootContext((Node)new PatternNode(classPattern, true));
                    boolean bl = BeanPanelUI.this.elementView.getScrollOnExpand();
                    BeanPanelUI.this.elementView.setScrollOnExpand(false);
                    BeanPanelUI.this.elementView.expandAll();
                    BeanPanelUI.this.elementView.setScrollOnExpand(bl);
                }
            });
        }
    }

    public void sort() {
        throw new UnsupportedOperationException();
    }

    public void expandNode(Node node) {
        this.elementView.expandNode(node);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        return this.getRootNode().getPattern().getPatternAnalyser().getFileObject();
    }

    public void filterStateChanged(ChangeEvent changeEvent) {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private PatternNode getRootNode() {
        Node node = this.manager.getRootContext();
        if (node instanceof PatternNode) {
            return (PatternNode)node;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        MyBeanTreeView myBeanTreeView = new MyBeanTreeView();
        return myBeanTreeView;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    static {
        ZERO = new Rectangle(0, 0, 1, 1);
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int n) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(BeanPanel.class, (String)"LBL_WaitNode");
        }
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        private MyBeanTreeView() {
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean bl) {
            this.tree.setScrollsOnExpand(bl);
        }
    }
}

