/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.NoMainProjectWarning;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.awt.MouseUtils;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class MainProjectAction
extends LookupSensitiveAction
implements PropertyChangeListener {
    private String command;
    private ProjectActionPerformer performer;
    private String name;

    public MainProjectAction(ProjectActionPerformer projectActionPerformer, String string, Icon icon) {
        this(null, projectActionPerformer, string, icon);
    }

    public MainProjectAction(String string, String string2, Icon icon) {
        this(string, null, string2, icon);
    }

    public MainProjectAction(String string, ProjectActionPerformer projectActionPerformer, String string2, Icon icon) {
        super(icon, null, new Class[]{Project.class, DataObject.class});
        this.command = string;
        this.performer = projectActionPerformer;
        this.name = string2;
        String string3 = "";
        if (string2 != null) {
            string3 = MessageFormat.format(string2, -1);
        }
        this.setDisplayName(string3);
        if (icon != null) {
            this.setSmallIcon(icon);
        }
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
    }

    protected boolean init() {
        boolean bl = super.init();
        if (bl) {
            this.refreshView(null);
        }
        return bl;
    }

    public void actionPerformed(Lookup lookup) {
        ActionProvider actionProvider;
        Project project = OpenProjectList.getDefault().getMainProject();
        if (project == null && ((Project[])(actionProvider = ActionsUtil.getProjectsFromLookup(lookup, this.command))).length == 1) {
            project = actionProvider[0];
        }
        if (project == null && ((Project[])(actionProvider = OpenProjects.getDefault().getOpenProjects())).length == 1) {
            project = actionProvider[0];
        }
        if (project == null) {
            if (this.showNoMainProjectWarning(OpenProjectList.getDefault().getOpenProjects(), this.getPresenterName(this.name, OpenProjectList.getDefault().getMainProject(), project))) {
                return;
            }
            project = OpenProjectList.getDefault().getMainProject();
        }
        if (this.command != null) {
            actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
            if (actionProvider != null) {
                if (Arrays.asList(actionProvider.getSupportedActions()).contains(this.command)) {
                    actionProvider.invokeAction(this.command, Lookup.EMPTY);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    this.refreshView(null);
                }
            }
        } else {
            this.performer.perform(project);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "MainProject" || propertyChangeEvent.getPropertyName() == "OpenProjects") {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    MainProjectAction.this.refreshView(null);
                }
            });
        }
    }

    private void refreshView(Lookup lookup) {
        boolean bl;
        Project[] projectArray;
        Project project = OpenProjectList.getDefault().getMainProject();
        Lookup lookup2 = lookup;
        if (project == null) {
            if (lookup2 == null) {
                lookup2 = LookupSensitiveAction.LastActivatedWindowLookup.INSTANCE;
            }
            if (lookup2 != null && (projectArray = ActionsUtil.getProjectsFromLookup(lookup2, this.command)).length == 1) {
                project = projectArray[0];
            }
        }
        if (project == null && (projectArray = OpenProjects.getDefault().getOpenProjects()).length == 1) {
            project = projectArray[0];
        }
        boolean bl2 = bl = OpenProjectList.getDefault().getOpenProjects().length == 0;
        if (this.command == null) {
            this.enable(this.performer.enable(project));
        } else if (project == null) {
            this.enable(false);
        } else if (ActionsUtil.commandSupported(project, this.command, Lookup.EMPTY)) {
            this.enable(!bl);
        } else {
            this.enable(false);
        }
        Project project2 = OpenProjectList.getDefault().getMainProject();
        String string = this.getPresenterName(this.name, project2, project);
        this.putValue("menuText", string);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)string));
    }

    private String getPresenterName(String string, Project project, Project project2) {
        String string2 = "";
        Object[] objectArray = project == null ? (project2 == null ? new Object[]{0} : new Object[]{1, ProjectUtils.getInformation((Project)project2).getDisplayName()}) : new Object[]{-1};
        if (string != null) {
            string2 = MessageFormat.format(string, objectArray);
        }
        return string2;
    }

    private void enable(final boolean bl) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MainProjectAction.this.setEnabled(bl);
                }
            });
        } else {
            this.setEnabled(bl);
        }
    }

    private boolean showNoMainProjectWarning(Project[] projectArray, String string) {
        boolean bl;
        final JButton jButton = new JButton(NbBundle.getMessage(NoMainProjectWarning.class, (String)"LBL_NoMainClassWarning_ChooseMainProject_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NoMainProjectWarning.class, (String)"AD_NoMainClassWarning_ChooseMainProject_OK"));
        final NoMainProjectWarning noMainProjectWarning = new NoMainProjectWarning(projectArray);
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        noMainProjectWarning.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                    if (noMainProjectWarning.getSelectedProject() != null) {
                        jButton.doClick();
                    }
                } else {
                    jButton.setEnabled(noMainProjectWarning.getSelectedProject() != null);
                }
            }
        });
        jButton.setEnabled(noMainProjectWarning.getSelectedProject() != null);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)noMainProjectWarning, string == null ? NbBundle.getMessage(NoMainProjectWarning.class, (String)"CTL_NoMainProjectWarning_Title") : Actions.cutAmpersand((String)string), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != objectArray[0]) {
            bl = true;
        } else {
            Project project = noMainProjectWarning.getSelectedProject();
            OpenProjectList.getDefault().setMainProject(project);
            bl = false;
        }
        dialog.dispose();
        return bl;
    }

    protected void refresh(Lookup lookup) {
        this.refreshView(lookup);
    }
}

