/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.mobility.antext.Bundle;
import org.netbeans.mobility.antext.EMapFormat;
import org.netbeans.mobility.antext.StackTraceTranslator;

public class RunTask
extends Task {
    private static final String DEFAULT_PLATFORM_TYPE = "UEI-1.0";
    private File jadFile;
    private File jarFile;
    private String jadUrl;
    private String execMethod;
    private String device;
    private File platformHome;
    private String platformType;
    private Path classPath;
    private String securityDomain;
    private boolean debug;
    private String debuggerAddressProperty;
    private String debugAddress;
    private String debugTransport;
    private boolean debugServer = true;
    private boolean debugSuspend = true;
    private String commandLine = null;
    private String cmdOptions;
    private String listCommandLine = null;
    private String otaRunCommandLine = null;
    protected URL jadUrlURL = null;
    protected final HashMap<String, Object> args = new HashMap();
    private static final String CMD_RUN = "CMD_Run_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File file = null;
        try {
            block49: {
                if (this.platformHome == null) {
                    throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "platformHome"));
                }
                if (this.jadFile == null && this.jadUrl == null) {
                    throw new BuildException(Bundle.getMessage("ERR_MissingJad"));
                }
                if (!this.platformHome.isDirectory()) {
                    throw new BuildException(Bundle.getMessage("ERR_MissingPlatformHome", this.platformHome.toString()));
                }
                if (this.platformType == null) {
                    this.log(Bundle.getMessage("WARN_DefaultPlatform", DEFAULT_PLATFORM_TYPE), 1);
                    this.platformType = DEFAULT_PLATFORM_TYPE;
                }
                if (Bundle.getMessage("NAME_STANDARD").equals(this.execMethod)) {
                    this.execMethod = null;
                }
                if (Bundle.getMessage("NAME_CUSTOM").equals(this.platformType)) {
                    if (this.commandLine == null) {
                        this.log(Bundle.getMessage("WARN_MissingCommandLine", DEFAULT_PLATFORM_TYPE), 1);
                        this.platformType = DEFAULT_PLATFORM_TYPE;
                    }
                } else {
                    this.commandLine = null;
                }
                if (this.jadUrl != null && !this.jadUrl.startsWith("${")) {
                    try {
                        this.jadUrlURL = new URL(this.jadUrl);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (this.commandLine == null && this.execMethod != null) {
                    try {
                        this.commandLine = Bundle.getMessage(CMD_RUN + this.platformType + "_" + this.execMethod);
                        if (!Bundle.getMessage("NAME_OTA").equals(this.execMethod)) break block49;
                        try {
                            this.listCommandLine = Bundle.getMessage(CMD_RUN + this.platformType + "_" + this.execMethod + "_List");
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                        try {
                            this.otaRunCommandLine = Bundle.getMessage(CMD_RUN + this.platformType + "_" + this.execMethod + "_Run");
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                        if (this.jadUrlURL == null) {
                            this.log(Bundle.getMessage("WARN_MissingJadUrlAttrSettingDefault"), 1);
                            this.execMethod = null;
                            this.listCommandLine = null;
                            this.otaRunCommandLine = null;
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        this.log(Bundle.getMessage(this.debug ? "WARN_UnsupportedDebugMethod" : "WARN_UnsupportedExecMethod", this.platformType, this.execMethod), 1);
                        this.execMethod = null;
                        this.listCommandLine = null;
                        this.otaRunCommandLine = null;
                    }
                }
            }
            if (this.commandLine == null) {
                try {
                    this.commandLine = Bundle.getMessage(CMD_RUN + this.platformType);
                    if (this.jadFile == null) {
                        throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "jadFile"));
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    throw new BuildException(Bundle.getMessage(this.debug ? "ERR_UnsupportedDebugging" : "ERR_UnsupportedExecution", this.platformType));
                }
            }
            this.args.put("platformhome", this.platformHome.getAbsolutePath());
            this.args.put("cmdoptions", this.cmdOptions == null ? "" : this.cmdOptions);
            if (this.classPath != null) {
                this.args.put("classpath", this.classPath.toString());
            }
            if (this.device != null && !"".equals(this.device)) {
                this.args.put("device", this.device);
            }
            if (this.jadFile != null) {
                if (this.jarFile != null && this.jarFile.isFile() && this.jadFile.isFile() && this.jarFile.getParentFile() != null && this.jarFile.getParentFile().equals(this.jadFile.getParentFile())) {
                    try {
                        file = File.createTempFile("nbrun", "", this.jarFile.getParentFile());
                        file.delete();
                        this.copy(this.jadFile, file);
                        this.copy(this.jarFile, file);
                        file.deleteOnExit();
                        this.jadFile = new File(file, this.jadFile.getName());
                        try {
                            this.jadFile = this.jadFile.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            this.jadFile = this.jadFile.getAbsoluteFile();
                        }
                        this.jadFile.deleteOnExit();
                        this.jarFile = new File(file, this.jarFile.getName());
                        try {
                            this.jarFile = this.jarFile.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            this.jarFile = this.jarFile.getAbsoluteFile();
                        }
                        this.jarFile.deleteOnExit();
                    }
                    catch (Exception exception) {
                        this.log(exception.getLocalizedMessage(), 1);
                    }
                }
                this.args.put("jadfile", this.jadFile.getAbsolutePath());
            }
            if (this.jadUrlURL != null) {
                this.args.put("jadurl", this.jadUrlURL);
                this.log(Bundle.getMessage("Inf_JadURL", this.jadUrlURL.toExternalForm()), 2);
            }
            if (this.securityDomain != null && !"".equals(this.securityDomain)) {
                this.args.put("securitydomain", this.securityDomain);
            }
            if (this.debug) {
                if (this.debugAddress == null) {
                    try {
                        this.debugAddress = Integer.toString(this.determineFreePort());
                    }
                    catch (IOException iOException) {
                        throw new BuildException((Throwable)iOException);
                    }
                }
                this.args.put("debug", "");
                this.args.put("debugaddress", this.debugAddress);
                this.args.put("debugtransport", this.debugTransport != null ? this.debugTransport : "dt_socket");
                this.args.put("debugserver", this.debugServer ? "y" : "n");
                this.args.put("debugsuspend", this.debugSuspend ? "y" : "n");
                if (this.debuggerAddressProperty != null) {
                    this.getProject().setNewProperty(this.debuggerAddressProperty, this.debugAddress);
                }
            }
            this.args.put("/", File.separator);
            if (this.debug) {
                this.log(Bundle.getMessage("MSG_RunDebug", this.debugAddress), 2);
            } else {
                this.log(Bundle.getMessage("MSG_RunExec"), 2);
            }
            try {
                int n = this.doExecute();
                if (n != 0) {
                    throw new BuildException(Bundle.getMessage("ERR_RunFailed", String.valueOf(n)));
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            if (file != null) {
                this.delete(file);
            }
        }
        catch (Throwable throwable) {
            if (file != null) {
                this.delete(file);
            }
            throw throwable;
        }
    }

    private void copy(File file, File file2) throws BuildException {
        Copy copy = new Copy();
        copy.setProject(this.getProject());
        FileSet fileSet = new FileSet();
        fileSet.setFile(file);
        copy.addFileset(fileSet);
        copy.setTodir(file2);
        copy.execute();
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.delete(fileArray[i]);
            }
        }
        file.delete();
    }

    private int doExecute() throws IOException {
        this.commandLine = EMapFormat.format(this.commandLine, this.args);
        Execute execute = new Execute();
        execute.setAntRun(this.getProject());
        execute.setVMLauncher(true);
        execute.setCommandline(Commandline.translateCommandline((String)this.commandLine));
        if (this.classPath != null && this.isClassFileAvailable()) {
            execute.setStreamHandler((ExecuteStreamHandler)new StackTraceTranslatorHandler(this.getProject().getBaseDir(), this.classPath.list()));
        }
        this.log(Bundle.getMessage("MSG_ExecCmd", this.commandLine), 3);
        int n = 0;
        try {
            n = execute.execute();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.log(illegalThreadStateException.getLocalizedMessage(), 3);
        }
        if (n == 0 && this.listCommandLine != null) {
            this.listCommandLine = EMapFormat.format(this.listCommandLine, this.args);
            execute = new Execute();
            execute.setAntRun(this.getProject());
            execute.setVMLauncher(true);
            execute.setCommandline(Commandline.translateCommandline((String)this.listCommandLine));
            execute.setStreamHandler((ExecuteStreamHandler)new ListStreamHandler());
            this.log(Bundle.getMessage("MSG_ExecCmd", this.listCommandLine), 3);
            try {
                n = execute.execute();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                this.log(illegalThreadStateException.getLocalizedMessage(), 3);
            }
        }
        if (n == 0 && this.otaRunCommandLine != null) {
            this.otaRunCommandLine = EMapFormat.format(this.otaRunCommandLine, this.args);
            execute = new Execute();
            execute.setAntRun(this.getProject());
            execute.setVMLauncher(true);
            execute.setCommandline(Commandline.translateCommandline((String)this.otaRunCommandLine));
            if (this.classPath != null && this.isClassFileAvailable()) {
                execute.setStreamHandler((ExecuteStreamHandler)new StackTraceTranslatorHandler(this.getProject().getBaseDir(), this.classPath.list()));
            }
            this.log(Bundle.getMessage("MSG_ExecCmd", this.otaRunCommandLine), 3);
            try {
                n = execute.execute();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                this.log(illegalThreadStateException.getLocalizedMessage(), 3);
            }
        }
        return n;
    }

    private boolean isClassFileAvailable() {
        try {
            Class.forName("org.netbeans.modules.classfile.ClassFile");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int determineFreePort() throws IOException {
        Socket socket = new Socket();
        socket.bind(null);
        int n = socket.getLocalPort();
        socket.close();
        return n;
    }

    public void setJadFile(File file) {
        this.jadFile = file;
    }

    public void setJarFile(File file) {
        this.jarFile = file;
    }

    public void setJadUrl(String string) {
        this.jadUrl = string;
    }

    public void setExecMethod(String string) {
        this.execMethod = string.toUpperCase();
    }

    public void setDevice(String string) {
        this.device = string;
    }

    public void setPlatformHome(File file) {
        this.platformHome = file;
    }

    public void setPlatformType(String string) {
        this.platformType = string.toUpperCase();
    }

    public void setClassPath(Path path) {
        this.createClassPath().append(path);
    }

    public Path createClassPath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        return this.classPath.createPath();
    }

    public void setClassPathRef(Reference reference) {
        this.createClassPath().setRefid(reference);
    }

    public void setSecurityDomain(String string) {
        this.securityDomain = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setDebuggerAddressProperty(String string) {
        this.debuggerAddressProperty = string;
    }

    public void setDebugAddress(String string) {
        this.debugAddress = string;
    }

    public void setDebugTransport(String string) {
        this.debugTransport = string;
    }

    public void setDebugServer(boolean bl) {
        this.debugServer = bl;
    }

    public void setDebugSuspend(boolean bl) {
        this.debugSuspend = bl;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public void setCmdOptions(String string) {
        this.cmdOptions = string;
    }

    private class StackTraceTranslatorHandler
    extends PumpStreamHandler {
        protected final StackTraceTranslator stt;
        private boolean isBci;

        StackTraceTranslatorHandler(File file, String[] stringArray) {
            this.stt = new StackTraceTranslator(file, stringArray);
        }

        protected Thread createPump(final InputStream inputStream, final OutputStream outputStream, final boolean bl) {
            Thread thread = new Thread(new Runnable(){
                private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                private final StringBuffer sb = new StringBuffer();
                protected boolean sleep;
                private final Thread timer = new Thread(new Runnable(){

                    public void run() {
                        try {
                            while (true) {
                                sleep = true;
                                while (sleep) {
                                    sleep = false;
                                    Thread.sleep(400L);
                                }
                                this.flush(true);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                });

                protected synchronized void flush(boolean bl3) {
                    Pattern pattern = Pattern.compile("((?:\t| *|\\[catch\\] )at )((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*[a-zA-Z_$][a-zA-Z0-9_$]*)\\.([a-zA-Z_$<][a-zA-Z0-9_$>]*)\\(\\+([0-9]+)\\)[\t ]*[\n\r]*");
                    Pattern pattern2 = Pattern.compile("((?:\t| *)- )((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*[a-zA-Z_$][a-zA-Z0-9_$]*)\\.([a-zA-Z_$<][a-zA-Z0-9_$>]*)\\(\\), bci=([0-9]+)[\t ]*[\n\r]*");
                    try {
                        String string;
                        if (this.buffer.size() > 0) {
                            string = this.buffer.toString();
                            boolean bl2 = pattern2.matcher(string).matches();
                            if (bl2) {
                                StackTraceTranslatorHandler.this.isBci = true;
                            }
                            if (pattern.matcher(string).matches() || bl2) {
                                this.sb.append(string);
                                this.buffer.reset();
                            }
                        }
                        if ((bl3 || this.buffer.size() > 0) && this.sb.length() > 0) {
                            try {
                                string = StackTraceTranslatorHandler.this.stt.translate(this.sb.toString(), StackTraceTranslatorHandler.this.isBci);
                                outputStream.write(string.getBytes());
                                this.sb.setLength(0);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (this.buffer.size() > 0) {
                            outputStream.write(this.buffer.toByteArray());
                            this.buffer.reset();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        this.timer.setDaemon(true);
                        this.timer.start();
                        int n = inputStream.read();
                        while (n >= 0) {
                            1 var2_5;
                            while (n >= 0 && n != 10 && n != 13) {
                                var2_5 = this;
                                synchronized (var2_5) {
                                    this.buffer.write(n);
                                }
                                this.sleep = true;
                                n = inputStream.read();
                            }
                            while (n == 10 || n == 13) {
                                var2_5 = this;
                                synchronized (var2_5) {
                                    this.buffer.write(n);
                                }
                                this.sleep = true;
                                n = inputStream.read();
                            }
                            this.flush(n < 0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        this.timer.interrupt();
                        if (bl) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
            thread.setDaemon(true);
            return thread;
        }
    }

    private class ListStreamHandler
    implements ExecuteStreamHandler,
    Runnable {
        private BufferedReader in;

        private ListStreamHandler() {
        }

        public void setProcessErrorStream(InputStream inputStream) throws IOException {
        }

        public void setProcessInputStream(OutputStream outputStream) throws IOException {
        }

        public void setProcessOutputStream(InputStream inputStream) throws IOException {
            this.in = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void start() throws IOException {
            new Thread(this).start();
        }

        public void stop() {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void run() {
            try {
                String string;
                int n = 0;
                while ((string = this.in.readLine()) != null) {
                    if ((string = string.trim()).startsWith("[") && string.endsWith("]")) {
                        try {
                            n = Integer.parseInt(string.substring(1, string.length() - 1));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (!string.startsWith("Installed From:")) continue;
                    try {
                        if (!new URL(string.substring(15).trim()).equals(RunTask.this.jadUrlURL)) continue;
                        RunTask.this.args.put("storagenum", String.valueOf(n));
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

