/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProviderFactory;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProviderFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataProvidersManager {
    private static final Logger log = DLightLogger.getLogger(DataProvidersManager.class);
    private static final DataProvidersManager instance = new DataProvidersManager();
    private final LookupListener lookupListener;
    private final Collection<VisualizerDataProviderFactory> allVisualizerDataProviders = new ArrayList<VisualizerDataProviderFactory>();
    private final Lookup.Result<VisualizerDataProviderFactory> lookupResult = Lookup.getDefault().lookupResult(VisualizerDataProviderFactory.class);
    private final Collection<VisualizerDataProvider> activeVisualizerDataProviders;

    private DataProvidersManager() {
        this.lookupListener = new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                Collection collection = DataProvidersManager.this.allVisualizerDataProviders;
                synchronized (collection) {
                    Collection collection2 = DataProvidersManager.this.lookupResult.allInstances();
                    DataProvidersManager.this.allVisualizerDataProviders.retainAll(collection2);
                    for (VisualizerDataProviderFactory visualizerDataProviderFactory : collection2) {
                        Collection collection3;
                        if (DataProvidersManager.this.allVisualizerDataProviders.contains(visualizerDataProviderFactory) || (collection3 = visualizerDataProviderFactory.getProvidedDataModelScheme()) == null) continue;
                        DataProvidersManager.this.allVisualizerDataProviders.add(visualizerDataProviderFactory);
                        log.log(Level.FINE, "New VisualizerDataProvider factory registered for the following schemas: {0}", Arrays.toString(collection3.toArray(new DataModelScheme[0])));
                    }
                }
            }
        };
        this.lookupResult.addLookupListener(this.lookupListener);
        this.lookupListener.resultChanged(null);
        this.activeVisualizerDataProviders = new ArrayList<VisualizerDataProvider>();
    }

    public static DataProvidersManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualizerDataProvider getDataProviderFor(DataModelScheme dataModelScheme) {
        Collection<VisualizerDataProviderFactory> collection = this.allVisualizerDataProviders;
        synchronized (collection) {
            for (VisualizerDataProviderFactory visualizerDataProviderFactory : this.allVisualizerDataProviders) {
                try {
                    if (!visualizerDataProviderFactory.provides(dataModelScheme)) continue;
                    VisualizerDataProvider visualizerDataProvider = visualizerDataProviderFactory.create();
                    this.activeVisualizerDataProviders.add(visualizerDataProvider);
                    return visualizerDataProvider;
                }
                catch (Throwable throwable) {
                    log.log(Level.FINE, "Exeption in getDataProviderFor " + dataModelScheme, throwable);
                }
            }
        }
        return null;
    }

    public Collection<DataProviderFactory> getDataProviderFactories(DataModelScheme dataModelScheme) {
        Collection collection = Lookup.getDefault().lookupAll(DataProviderFactory.class);
        ArrayList<DataProviderFactory> arrayList = new ArrayList<DataProviderFactory>();
        for (DataProviderFactory dataProviderFactory : collection) {
            if (!dataProviderFactory.getProvidedDataModelScheme().contains(dataModelScheme)) continue;
            arrayList.add(dataProviderFactory);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public DataProvider createProvider(DataProviderFactory dataProviderFactory) {
        DataProvider dataProvider = dataProviderFactory.create();
        this.activeVisualizerDataProviders.add((VisualizerDataProvider)dataProvider);
        return dataProvider;
    }
}

