/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.openide.filesystems.FileObject;
import org.openide.windows.WindowManager;

final class ResizablePopup {
    static final String HELP_COOKIE = "help";
    private static final WindowListener windowListener = new WindowAdapter(){

        public void windowClosing(WindowEvent windowEvent) {
            ResizablePopup.cleanup(windowEvent.getWindow());
        }

        private boolean aboutToShowHelp(Window window) {
            JRootPane jRootPane;
            if (window instanceof RootPaneContainer && Boolean.TRUE.equals((jRootPane = ((RootPaneContainer)((Object)window)).getRootPane()).getClientProperty(ResizablePopup.HELP_COOKIE))) {
                jRootPane.putClientProperty(ResizablePopup.HELP_COOKIE, null);
                return true;
            }
            return false;
        }
    };

    ResizablePopup() {
    }

    static JDialog getDialog(FileObject fileObject) {
        JDialog jDialog = new JDialog(WindowManager.getDefault().getMainWindow(), "", false){

            public void setVisible(boolean bl) {
                boolean bl2 = this.isVisible();
                if (bl2 && !bl) {
                    JavaMembersAndHierarchyOptions.setLastBounds(this.getBounds());
                }
                super.setVisible(bl);
            }
        };
        jDialog.setBounds(JavaMembersAndHierarchyOptions.getLastBounds());
        jDialog.addWindowListener(windowListener);
        jDialog.setDefaultCloseOperation(2);
        Logger.getLogger("TIMER").log(Level.FINE, "Java Navigation Dialogs", new Object[]{fileObject, jDialog});
        return jDialog;
    }

    static void cleanup(Window window) {
        window.setVisible(false);
        if (window instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)window)).setContentPane(new JPanel());
        }
        window.removeWindowListener(windowListener);
        window.dispose();
    }
}

