/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FQNImporter {
    private FileObject javaFile;
    private boolean handleInitComponents;
    private String formListener;
    private Collection<String> variableNames;
    private Collection<String> eventHandlers;

    FQNImporter(FileObject fileObject) {
        this.javaFile = fileObject;
    }

    void setHandleInitComponents(boolean bl) {
        this.handleInitComponents = bl;
    }

    void setHandleVariables(Collection<String> collection) {
        this.variableNames = collection;
    }

    void setHandleFormListener(String string) {
        this.formListener = string;
    }

    void setHandleEventHandlers(Collection<String> collection) {
        this.eventHandlers = collection;
    }

    void importFQNs() {
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.javaFile);
            CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    Tree tree;
                    Object object;
                    Tree tree2;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                    ClassTree classTree = null;
                    String string = FQNImporter.this.javaFile.getName();
                    for (Tree object2 : compilationUnitTree.getTypeDecls()) {
                        ClassTree classTree2;
                        if (Tree.Kind.CLASS != object2.getKind() || !string.equals((classTree2 = (ClassTree)object2).getSimpleName().toString())) continue;
                        classTree = classTree2;
                        break;
                    }
                    if (classTree == null) {
                        return;
                    }
                    GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
                    if (FQNImporter.this.handleInitComponents) {
                        for (Tree tree3 : classTree.getMembers()) {
                            if (Tree.Kind.METHOD != tree3.getKind() || !"initComponents".equals((tree2 = (MethodTree)tree3).getName().toString())) continue;
                            object = tree2.getBody();
                            Tree tree4 = generatorUtilities.importFQNs((Tree)object);
                            workingCopy.rewrite((Tree)object, tree4);
                        }
                    }
                    if (FQNImporter.this.formListener != null) {
                        for (Tree tree5 : classTree.getMembers()) {
                            if (Tree.Kind.CLASS != tree5.getKind()) continue;
                            tree2 = (ClassTree)tree5;
                            if (!FQNImporter.this.formListener.equals(tree2.getSimpleName().toString())) continue;
                            object = generatorUtilities.importFQNs(tree2);
                            workingCopy.rewrite(tree2, (Tree)object);
                        }
                    }
                    if (FQNImporter.this.variableNames != null) {
                        for (Tree tree6 : classTree.getMembers()) {
                            if (Tree.Kind.VARIABLE != tree6.getKind()) continue;
                            tree2 = (VariableTree)tree6;
                            if (!FQNImporter.this.variableNames.contains(tree2.getName().toString())) continue;
                            object = tree2.getType();
                            Tree tree7 = generatorUtilities.importFQNs((Tree)object);
                            workingCopy.rewrite((Tree)object, tree7);
                            tree = tree2.getInitializer();
                            if (tree == null) continue;
                            Tree tree8 = generatorUtilities.importFQNs(tree);
                            workingCopy.rewrite(tree, tree8);
                        }
                    }
                    if (FQNImporter.this.eventHandlers != null) {
                        for (Tree tree9 : classTree.getMembers()) {
                            if (Tree.Kind.METHOD != tree9.getKind()) continue;
                            tree2 = (MethodTree)tree9;
                            if (!FQNImporter.this.eventHandlers.contains(tree2.getName().toString())) continue;
                            for (VariableTree variableTree : tree2.getParameters()) {
                                tree = generatorUtilities.importFQNs((Tree)variableTree);
                                workingCopy.rewrite((Tree)variableTree, tree);
                            }
                        }
                    }
                }

                public void cancel() {
                }
            };
            ModificationResult modificationResult = javaSource.runModificationTask((Task)cancellableTask);
            List list = modificationResult.getDifferences(this.javaFile);
            if (list != null) {
                for (ModificationResult.Difference difference : list) {
                    difference.setCommitToGuards(true);
                }
                modificationResult.commit();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, iOException.getMessage(), iOException);
        }
    }
}

