/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.spi;

import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.JComponent;
import org.netbeans.modules.apisupport.project.ui.wizard.TypeChooserPanelImpl;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class ModuleTypePanel {
    private static final String IS_STANDALONE_OR_SUITE_COMPONENT = "tc_isStandaloneOrSuiteComp";
    private static final String SUITE_ROOT = "tc_suiteRoot";
    private static final String ACTIVE_PLATFORM_ID = "tc_activePlatform_id";
    private static final String ACTIVE_NB_PLATFORM = "tc_activeNBPlatform";
    private static final String IS_NETBEANS_ORG = "isNetBeansOrg";
    private static final String PROJECT_FOLDER = "tc_projectFolderForTypeChooser";

    private ModuleTypePanel() {
    }

    public static JComponent createComponent(WizardDescriptor wizardDescriptor) {
        return new TypeChooserPanelImpl(wizardDescriptor);
    }

    public static boolean validate(WizardDescriptor wizardDescriptor) {
        if (ModuleTypePanel.isSuiteComponent(wizardDescriptor) && ModuleTypePanel.getSuiteRoot(wizardDescriptor) == null) {
            ModuleTypePanel.setErrorMessage(wizardDescriptor, NbBundle.getMessage(ModuleTypePanel.class, (String)"MSG_ChooseRegularSuite"));
            return false;
        }
        if (ModuleTypePanel.isStandalone(wizardDescriptor) && (ModuleTypePanel.getActiveNbPlatform(wizardDescriptor) == null || !ModuleTypePanel.getActiveNbPlatform(wizardDescriptor).isValid())) {
            ModuleTypePanel.setErrorMessage(wizardDescriptor, NbBundle.getMessage(ModuleTypePanel.class, (String)"MSG_ChosenPlatformIsInvalid"));
            return false;
        }
        return true;
    }

    public static boolean isPanelUpdated(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        return IS_STANDALONE_OR_SUITE_COMPONENT.equals(string) || SUITE_ROOT.equals(string) || ACTIVE_PLATFORM_ID.equals(string);
    }

    public static void setProjectFolder(WizardDescriptor wizardDescriptor, File file) {
        wizardDescriptor.putProperty(PROJECT_FOLDER, (Object)file);
    }

    public static boolean isSuiteComponent(WizardDescriptor wizardDescriptor) {
        Object object = wizardDescriptor.getProperty(IS_STANDALONE_OR_SUITE_COMPONENT);
        return !ModuleTypePanel.extractBoolean(object, true);
    }

    public static boolean isStandalone(WizardDescriptor wizardDescriptor) {
        Object object = wizardDescriptor.getProperty(IS_STANDALONE_OR_SUITE_COMPONENT);
        return ModuleTypePanel.extractBoolean(object, false);
    }

    public static boolean isNetBeansOrg(WizardDescriptor wizardDescriptor) {
        Object object = wizardDescriptor.getProperty(IS_NETBEANS_ORG);
        return ModuleTypePanel.extractBoolean(object, false);
    }

    public static String getSuiteRoot(WizardDescriptor wizardDescriptor) {
        Object object = wizardDescriptor.getProperty(SUITE_ROOT);
        return ModuleTypePanel.extractString(object, null);
    }

    public static String getActivePlatformId(WizardDescriptor wizardDescriptor) {
        Object object = wizardDescriptor.getProperty(ACTIVE_PLATFORM_ID);
        return ModuleTypePanel.extractString(object, null);
    }

    private static NbPlatform getActiveNbPlatform(WizardDescriptor wizardDescriptor) {
        Object object = wizardDescriptor.getProperty(ACTIVE_NB_PLATFORM);
        if (object != null && object instanceof NbPlatform) {
            return (NbPlatform)object;
        }
        return null;
    }

    private static boolean extractBoolean(Object object, boolean bl) {
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    private static String extractString(Object object, String string) {
        if (object != null && object instanceof String) {
            return (String)object;
        }
        return string;
    }

    private static void setErrorMessage(WizardDescriptor wizardDescriptor, String string) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
    }
}

