/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.options.OptionsPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.options.OptionsPanel0;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NewOptionsIterator
extends BasicWizardIterator {
    private DataModel data;

    private NewOptionsIterator() {
    }

    public static NewOptionsIterator createIterator() {
        return new NewOptionsIterator();
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles createdModifiedFiles = this.data.getCreatedModifiedFiles();
        createdModifiedFiles.run();
        return NewOptionsIterator.getCreatedFiles(createdModifiedFiles, this.data.getProject());
    }

    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        this.data = new DataModel(wizardDescriptor);
        return new BasicWizardIterator.Panel[]{new OptionsPanel0(wizardDescriptor, this.data), new OptionsPanel(wizardDescriptor, this.data)};
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        super.uninitialize(wizardDescriptor);
        this.data = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private static final int SUCCESS = 0;
        private static final int ERR_INVALID_CLASSNAME_PREFIX = 1;
        private static final int MSG_BLANK_SECONDARY_PANEL_TITLE = 1024;
        private static final int MSG_BLANK_PRIMARY_PANEL = 1026;
        private static final int MSG_BLANK_CATEGORY_NAME = 1028;
        private static final int MSG_BLANK_ICONPATH = 1029;
        private static final int MSG_BLANK_PACKAGE_NAME = 1030;
        private static final int MSG_BLANK_CLASSNAME_PREFIX = 1031;
        private static final int MSG_BLANK_KEYWORDS = 1032;
        private static final int WARNING_INCORRECT_ICON_SIZE = -1;
        private static final String[] CATEGORY_BUNDLE_KEYS = new String[]{"OptionsCategory_Name", "OptionsCategory_Keywords"};
        private static final String[] ADVANCED_BUNDLE_KEYS = new String[]{"AdvancedOption_DisplayName", "AdvancedOption_Keywords"};
        private static final String[] TOKENS = new String[]{"PACKAGE_NAME", "AdvancedOption_CLASS_NAME", "OptionsCategory_CLASS_NAME", "Panel_CLASS_NAME", "OptionsPanelController_CLASS_NAME", "OptionsPanelController_ANNOTATION", "ICON_PATH", ADVANCED_BUNDLE_KEYS[0], ADVANCED_BUNDLE_KEYS[1], CATEGORY_BUNDLE_KEYS[0], CATEGORY_BUNDLE_KEYS[1]};
        private static final String ADVANCED_OPTION = "AdvancedOption";
        private static final String OPTIONS_CATEGORY = "OptionsCategory";
        private static final String PANEL = "Panel";
        private static final String OPTIONS_PANEL_CONTROLLER = "OptionsPanelController";
        private static final String JAVA_TEMPLATE_PREFIX = "template_myplugin";
        private static final String FORM_TEMPLATE_PREFIX = "template_myplugin_form";
        private CreatedModifiedFiles files;
        private String codeNameBase;
        private boolean advanced;
        private String primaryPanel;
        private String secondaryPanelTitle;
        private String primaryKeywords;
        private String categoryName;
        private String iconPath;
        private String secondaryKeywords;
        private boolean allowAdvanced;
        private String classNamePrefix;

        DataModel(WizardDescriptor wizardDescriptor) {
            super(wizardDescriptor);
        }

        int setDataForSecondaryPanel(String string, String string2, String string3) {
            this.advanced = true;
            this.primaryPanel = string;
            this.secondaryPanelTitle = string2;
            this.secondaryKeywords = string3;
            return this.checkFirstPanel();
        }

        int setDataForPrimaryPanel(String string, String string2, boolean bl, String string3) {
            this.advanced = false;
            this.categoryName = string;
            this.iconPath = string2;
            this.allowAdvanced = bl;
            this.primaryKeywords = string3;
            return this.checkFirstPanel();
        }

        @Override
        public String getPackageName() {
            String string = super.getPackageName();
            if (string == null) {
                string = this.getCodeNameBase();
                super.setPackageName(string);
            }
            return string;
        }

        public int setPackageAndPrefix(String string, String string2) {
            this.setPackageName(string);
            this.classNamePrefix = string2;
            int n = this.checkFinalPanel();
            if (DataModel.isSuccessCode(n)) {
                this.generateCreatedModifiedFiles();
            }
            return n;
        }

        private String getAbsoluteIconPath() {
            return this.getProject().getProjectDirectory() + "/src/" + this.getIconPath();
        }

        private Map<String, String> getTokenMap(boolean bl) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < TOKENS.length; ++i) {
                if (this.isAdvanced() && "ICON_PATH".equals(TOKENS[i])) continue;
                hashMap.put(TOKENS[i], this.getReplacement(TOKENS[i], bl));
            }
            return hashMap;
        }

        private String getReplacement(String string, boolean bl) {
            if ("PACKAGE_NAME".equals(string)) {
                return this.getPackageName();
            }
            if ("AdvancedOption_CLASS_NAME".equals(string)) {
                return this.getAdvancedOptionClassName();
            }
            if ("OptionsCategory_CLASS_NAME".equals(string)) {
                return this.getOptionsCategoryClassName();
            }
            if ("Panel_CLASS_NAME".equals(string)) {
                return this.getPanelClassName();
            }
            if ("OptionsPanelController_CLASS_NAME".equals(string)) {
                return this.getOptionsPanelControllerClassName();
            }
            if ("ICON_PATH".equals(string)) {
                return this.addCreateIconOperation(new CreatedModifiedFiles(this.getProject()), this.getAbsoluteIconPath());
            }
            if ("OptionsPanelController_ANNOTATION".equals(string)) {
                if (!bl) {
                    return "";
                }
                if (this.isAdvanced()) {
                    return "@OptionsPanelController.SubRegistration(\n    location=\"" + this.getPrimaryPanel() + "\",\n" + "    displayName=\"#AdvancedOption_DisplayName_" + this.getClassNamePrefix() + "\",\n" + "    keywords=\"#AdvancedOption_Keywords_" + this.getClassNamePrefix() + "\",\n" + "    keywordsCategory=\"" + this.getPrimaryPanel() + "/" + this.getClassNamePrefix() + "\"\n" + ")\n";
                }
                if (this.isAdvancedCategory()) {
                    return "<should never be used>";
                }
                return "@OptionsPanelController.TopLevelRegistration(\n    categoryName=\"#OptionsCategory_Name_" + this.getClassNamePrefix() + "\",\n" + "    iconBase=\"" + this.iconPath + "\",\n" + "    keywords=\"#OptionsCategory_Keywords_" + this.getClassNamePrefix() + "\",\n" + "    keywordsCategory=\"" + this.getClassNamePrefix() + "\"\n" + ")\n";
            }
            return string + "_" + this.getClassNamePrefix();
        }

        private String getBundleValue(String string) {
            if (string.startsWith("OptionsCategory_Name")) {
                return this.getCategoryName();
            }
            if (string.startsWith("AdvancedOption_DisplayName")) {
                return this.getSecondaryPanelTitle();
            }
            if (string.startsWith("OptionsCategory_Keywords")) {
                return this.getPrimaryKeywords();
            }
            if (string.startsWith("AdvancedOption_Keywords")) {
                return this.getSecondaryKeywords();
            }
            throw new AssertionError((Object)string);
        }

        String getMessage(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    return "";
                }
                case 1024: {
                    string = "FIELD_SecondaryPanelTitle";
                    break;
                }
                case 1026: {
                    string = "FIELD_PrimaryPanel";
                    break;
                }
                case 1032: {
                    string = "FIELD_Keywords";
                    break;
                }
                case 1028: {
                    string = "FIELD_CategoryName";
                    break;
                }
                case 1029: {
                    string = "FIELD_IconPath";
                    break;
                }
                case 1030: {
                    string = "FIELD_PackageName";
                    break;
                }
                case 1031: {
                    string = "FIELD_ClassNamePrefix";
                    break;
                }
                case 1: {
                    string = "FIELD_ClassNamePrefix";
                    break;
                }
                case -1: {
                    File file = new File(this.getAbsoluteIconPath());
                    assert (file.exists());
                    return UIUtil.getIconDimensionWarning(file, 32, 32);
                }
                default: {
                    assert (false) : "Unknown code: " + n;
                    break;
                }
            }
            string = NbBundle.getMessage(NewOptionsIterator.class, (String)string);
            if (DataModel.isErrorCode(n)) {
                return NbBundle.getMessage(NewOptionsIterator.class, (String)"ERR_FieldInvalid", (Object)string);
            }
            if (DataModel.isInfoCode(n)) {
                return NbBundle.getMessage(NewOptionsIterator.class, (String)"MSG_FieldEmpty", (Object)string);
            }
            return "";
        }

        static boolean isSuccessCode(int n) {
            return n == 0;
        }

        static boolean isErrorCode(int n) {
            return 0 < n && n < 1024;
        }

        static boolean isWarningCode(int n) {
            return n < 0;
        }

        static boolean isInfoCode(int n) {
            return n >= 1024;
        }

        private int checkFirstPanel() {
            if (this.advanced) {
                if (this.getPrimaryPanel().length() == 0) {
                    return 1026;
                }
                if (this.getSecondaryPanelTitle().length() == 0) {
                    return 1024;
                }
                if (this.getSecondaryKeywords().length() == 0) {
                    return 1032;
                }
            } else {
                if (this.getCategoryName().length() == 0) {
                    return 1028;
                }
                if (this.getIconPath().length() == 0) {
                    return 1029;
                }
                if (this.getPrimaryKeywords().length() == 0) {
                    return 1032;
                }
                File file = new File(this.getAbsoluteIconPath());
                if (!file.exists()) {
                    return 1029;
                }
                file = new File(this.getAbsoluteIconPath());
                assert (file.exists());
                if (!UIUtil.isValidIcon(file, 32, 32)) {
                    return -1;
                }
            }
            return 0;
        }

        private int checkFinalPanel() {
            if (this.getPackageName().length() == 0) {
                return 1030;
            }
            if (this.getClassNamePrefix().length() == 0) {
                return 1031;
            }
            if (!Utilities.isJavaIdentifier((String)this.getClassNamePrefix())) {
                return 1;
            }
            return 0;
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            if (this.files == null) {
                this.files = this.generateCreatedModifiedFiles();
            }
            return this.files;
        }

        private CreatedModifiedFiles generateCreatedModifiedFiles() {
            assert (DataModel.isSuccessCode(this.checkFirstPanel()) || DataModel.isWarningCode(this.checkFirstPanel()));
            assert (DataModel.isSuccessCode(this.checkFinalPanel()));
            this.files = new CreatedModifiedFiles(this.getProject());
            boolean bl = new SpecificationVersion(LayerUtils.getPlatformForProject(this.getProject()).getModule("org.netbeans.modules.options.api").getSpecificationVersion()).compareTo((Object)new SpecificationVersion("1.14")) >= 0;
            this.generateDependencies();
            if (bl && this.isAdvancedCategory()) {
                this.generatePackageInfo();
            } else {
                this.generateFiles(bl);
            }
            this.generateBundleKeys();
            if (!bl) {
                this.generateLayerEntry();
            }
            if (!this.isAdvanced()) {
                this.addCreateIconOperation(this.files, this.getAbsoluteIconPath());
            }
            return this.files;
        }

        private void generateFiles(boolean bl) {
            if (this.isAdvanced()) {
                this.files.add(this.createJavaFileCopyOperation(OPTIONS_PANEL_CONTROLLER, bl));
                this.files.add(this.createJavaFileCopyOperation(PANEL, bl));
                this.files.add(this.createFormFileCopyOperation(PANEL));
            } else if (!this.isAdvancedCategory()) {
                this.files.add(this.createJavaFileCopyOperation(OPTIONS_PANEL_CONTROLLER, bl));
                this.files.add(this.createJavaFileCopyOperation(PANEL, bl));
                this.files.add(this.createFormFileCopyOperation(PANEL));
            }
        }

        private void generateBundleKeys() {
            String[] stringArray = this.isAdvanced() ? ADVANCED_BUNDLE_KEYS : CATEGORY_BUNDLE_KEYS;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this.getReplacement(stringArray[i], false);
                String string2 = this.getBundleValue(string);
                this.files.add(this.files.bundleKey(this.getDefaultPackagePath("Bundle.properties", true), string, string2));
            }
        }

        private void generateDependencies() {
            this.files.add(this.files.addModuleDependency("org.openide.util"));
            this.files.add(this.files.addModuleDependency("org.netbeans.modules.options.api", "1", null, true));
            this.files.add(this.files.addModuleDependency("org.openide.awt"));
            this.files.add(this.files.addModuleDependency("org.jdesktop.layout"));
        }

        private void generateLayerEntry() {
            if (this.isAdvanced()) {
                String string = "OptionsDialog/" + this.getPrimaryPanel() + "/";
                String string2 = this.getAdvancedOptionClassName();
                String string3 = string + this.getPackageName().replace('.', '-') + "-" + string2 + ".instance";
                this.files.add(this.files.createLayerEntry(string3, null, null, null, null));
                this.files.add(this.files.createLayerAttribute(string3, "instanceCreate", "methodvalue:org.netbeans.spi.options.AdvancedOption.createSubCategory"));
                this.files.add(this.files.createLayerAttribute(string3, "controller", "newvalue:" + this.getPackageName() + "." + this.getOptionsPanelControllerClassName()));
                this.files.add(this.files.createLayerAttribute(string3, "displayName", "bundlevalue:" + this.getPackageName() + ".Bundle#AdvancedOption_DisplayName_" + this.getClassNamePrefix()));
                this.files.add(this.files.createLayerAttribute(string3, "keywords", "bundlevalue:" + this.getPackageName() + ".Bundle#AdvancedOption_Keywords_" + this.getClassNamePrefix()));
                this.files.add(this.files.createLayerAttribute(string3, "keywordsCategory", this.getPrimaryPanel() + "/" + this.getClassNamePrefix()));
            } else {
                String string = "OptionsDialog/";
                String string4 = this.isAdvancedCategory() ? this.getClassNamePrefix() : this.getOptionsCategoryClassName();
                String string5 = string + string4 + ".instance";
                HashMap<String, Object> hashMap = new HashMap<String, Object>(7);
                hashMap.put("iconBase", this.iconPath);
                hashMap.put("keywordsCategory", this.getClassNamePrefix());
                this.files.add(this.files.createLayerEntry(string5, null, null, null, hashMap));
                this.files.add(this.files.createLayerAttribute(string5, "instanceCreate", "methodvalue:org.netbeans.spi.options.OptionsCategory.createCategory"));
                this.files.add(this.files.createLayerAttribute(string5, "categoryName", "bundlevalue:" + this.getPackageName() + ".Bundle#OptionsCategory_Name_" + this.getClassNamePrefix()));
                if (this.isAdvancedCategory()) {
                    this.files.add(this.files.createLayerAttribute(string5, "advancedOptionsFolder", string + string4));
                } else {
                    this.files.add(this.files.createLayerAttribute(string5, "controller", "newvalue:" + this.getPackageName() + "." + this.getOptionsPanelControllerClassName()));
                }
                this.files.add(this.files.createLayerAttribute(string5, "keywords", "bundlevalue:" + this.getPackageName() + ".Bundle#OptionsCategory_Keywords_" + this.getClassNamePrefix()));
            }
        }

        private void generatePackageInfo() {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("id", this.getClassNamePrefix());
            linkedHashMap.put("categoryName", "#OptionsCategory_Name_" + this.getClassNamePrefix());
            linkedHashMap.put("iconBase", this.iconPath);
            linkedHashMap.put("keywords", "#OptionsCategory_Keywords_" + this.getClassNamePrefix());
            linkedHashMap.put("keywordsCategory", this.getClassNamePrefix());
            this.files.add(this.files.packageInfo(this.getPackageName(), Collections.singletonMap("org.netbeans.spi.options.OptionsPanelController.ContainerRegistration", linkedHashMap)));
        }

        private CreatedModifiedFiles.Operation createJavaFileCopyOperation(String string, boolean bl) {
            FileObject fileObject = CreatedModifiedFiles.getTemplate(JAVA_TEMPLATE_PREFIX + string + ".java");
            assert (fileObject != null) : "template_myplugin" + string;
            return this.files.createFileWithSubstitutions(this.getFilePath(string), fileObject, this.getTokenMap(bl));
        }

        private String getFilePath(String string) {
            String string2 = this.getClassNamePrefix() + string + ".java";
            return this.getDefaultPackagePath(string2, false);
        }

        private CreatedModifiedFiles.Operation createFormFileCopyOperation(String string) {
            FileObject fileObject = CreatedModifiedFiles.getTemplate(FORM_TEMPLATE_PREFIX + string + ".form");
            assert (fileObject != null) : "template_myplugin" + string;
            String string2 = this.getClassNamePrefix() + string + ".form";
            String string3 = this.getDefaultPackagePath(string2, false);
            return this.files.createFile(string3, fileObject);
        }

        private String getCodeNameBase() {
            if (this.codeNameBase == null) {
                NbModuleProvider nbModuleProvider = (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
                this.codeNameBase = nbModuleProvider.getCodeNameBase();
            }
            return this.codeNameBase;
        }

        private String getPrimaryPanel() {
            return this.primaryPanel;
        }

        private String getSecondaryPanelTitle() {
            assert (!this.isAdvanced() || this.secondaryPanelTitle != null);
            return this.secondaryPanelTitle;
        }

        private String getPrimaryKeywords() {
            assert (this.isAdvanced() || this.primaryKeywords != null);
            return this.primaryKeywords;
        }

        private String getSecondaryKeywords() {
            assert (!this.isAdvanced() || this.secondaryKeywords != null);
            return this.secondaryKeywords;
        }

        private String getCategoryName() {
            assert (this.isAdvanced() || this.categoryName != null);
            return this.categoryName;
        }

        private String getIconPath() {
            assert (this.isAdvanced() || this.iconPath != null);
            return this.iconPath;
        }

        String getClassNamePrefix() {
            if (this.classNamePrefix == null) {
                this.classNamePrefix = this.isAdvanced() ? this.getSecondaryPanelTitle() : this.getCategoryName();
                this.classNamePrefix = this.classNamePrefix.trim().replaceAll(" ", "");
                if (!Utilities.isJavaIdentifier((String)this.classNamePrefix)) {
                    this.classNamePrefix = "";
                }
            }
            return this.classNamePrefix;
        }

        private boolean isAdvanced() {
            return this.advanced;
        }

        private boolean isAdvancedCategory() {
            return this.allowAdvanced;
        }

        private String getAdvancedOptionClassName() {
            return this.getClassName(ADVANCED_OPTION);
        }

        private String getOptionsCategoryClassName() {
            return this.getClassName(OPTIONS_CATEGORY);
        }

        private String getPanelClassName() {
            return this.getClassName(PANEL);
        }

        private String getOptionsPanelControllerClassName() {
            return this.getClassName(OPTIONS_PANEL_CONTROLLER);
        }

        private String getClassName(String string) {
            return this.getClassNamePrefix() + string;
        }
    }
}

