/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class InconsistentPortType
extends AbstractWebServiceRule {
    protected ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        AnnotationMirror annotationMirror = Utilities.findAnnotation(typeElement, "javax.jws.WebService");
        if (typeElement.getKind() == ElementKind.CLASS && Utilities.getAnnotationAttrValue(annotationMirror, "endpointInterface") == null) {
            Service service = (Service)problemContext.getLookup().lookup(Service.class);
            WSDLModel wSDLModel = (WSDLModel)problemContext.getLookup().lookup(WSDLModel.class);
            if (service != null && wSDLModel != null && wSDLModel.getState() == Model.State.VALID) {
                Object object;
                PortType portType = (PortType)wSDLModel.findComponentByName(typeElement.getSimpleName().toString(), PortType.class);
                if (portType == null && (object = Utilities.getAnnotationAttrValue(annotationMirror, "name")) != null) {
                    portType = (PortType)wSDLModel.findComponentByName(object.toString(), PortType.class);
                }
                if (portType == null) {
                    object = NbBundle.getMessage(InconsistentPortType.class, (String)"MSG_InconsistentPortType");
                    AnnotationTree annotationTree = (AnnotationTree)problemContext.getCompilationInfo().getTrees().getTree(typeElement, annotationMirror);
                    ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, "wsdlLocation");
                    problemContext.setElementToAnnotate(expressionTree);
                    ErrorDescription errorDescription = InconsistentPortType.createProblem((Element)typeElement, problemContext, (String)object, (Fix)null);
                    problemContext.setElementToAnnotate(null);
                    return new ErrorDescription[]{errorDescription};
                }
            }
        }
        return null;
    }
}

