/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.repository.GroupListChildren;
import org.netbeans.modules.maven.repository.register.RepositoryRegisterUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RepositoryNode
extends AbstractNode {
    private RepositoryInfo info;

    public RepositoryNode(RepositoryInfo repositoryInfo) {
        super((Children)new GroupListChildren(repositoryInfo));
        this.info = repositoryInfo;
        this.setName(repositoryInfo.getId());
        this.setDisplayName(repositoryInfo.getName());
    }

    public Image getIcon(int n) {
        if (this.info.isRemoteDownloadable()) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/remoterepo.png", (boolean)true);
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/localrepo.png", (boolean)true);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_ID", (Object)this.info.getId()));
        stringBuffer.append(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_Name", (Object)this.info.getName()));
        if (this.info.getRepositoryUrl() != null) {
            stringBuffer.append(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_Url", (Object)this.info.getRepositoryUrl()));
        }
        if (this.info.getIndexUpdateUrl() != null) {
            stringBuffer.append(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_Index_Url", (Object)this.info.getIndexUpdateUrl()));
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    public void destroy() throws IOException {
        RepositoryPreferences.getInstance().removeRepositoryInfo(this.info);
        super.destroy();
    }

    public boolean canDestroy() {
        return !this.info.isLocal();
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{new RefreshIndexAction(), new EditAction(), DeleteAction.get(DeleteAction.class), null, PropertiesAction.get(PropertiesAction.class)};
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        try {
            PropertySupport.Reflection reflection = new PropertySupport.Reflection((Object)this.info, String.class, "getId", null);
            reflection.setName("Id");
            reflection.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Id"));
            reflection.setShortDescription("");
            PropertySupport.Reflection reflection2 = new PropertySupport.Reflection((Object)this.info, String.class, "getName", null);
            reflection2.setName("name");
            reflection2.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Name"));
            reflection2.setShortDescription("");
            PropertySupport.Reflection reflection3 = new PropertySupport.Reflection((Object)this.info, String.class, "getType", null);
            reflection3.setName("type");
            reflection3.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Repository_Type"));
            PropertySupport.Reflection reflection4 = new PropertySupport.Reflection((Object)this.info, Boolean.TYPE, "isLocal", null);
            reflection4.setName("local");
            reflection4.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Local"));
            reflection4.setShortDescription("");
            PropertySupport.Reflection reflection5 = new PropertySupport.Reflection((Object)this.info, String.class, "getRepositoryPath", null);
            reflection5.setName("repositoryPath");
            reflection5.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Local_repository_path"));
            PropertySupport.Reflection reflection6 = new PropertySupport.Reflection((Object)this.info, Boolean.TYPE, "isRemoteDownloadable", null);
            reflection6.setName("remoteDownloadable");
            reflection6.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Remote_Index"));
            PropertySupport.Reflection reflection7 = new PropertySupport.Reflection((Object)this.info, String.class, "getRepositoryUrl", null);
            reflection7.setName("repositoryUrl");
            reflection7.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Remote_URL"));
            PropertySupport.Reflection reflection8 = new PropertySupport.Reflection((Object)this.info, String.class, "getIndexUpdateUrl", null);
            reflection8.setName("indexUpdateUrl");
            reflection8.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Remote_Index_URL"));
            set.put(new Node.Property[]{reflection, reflection2, reflection3, reflection4, reflection5, reflection6, reflection7, reflection8});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return sheet;
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("Name", NbBundle.getMessage(RepositoryNode.class, (String)"ACT_Edit..."));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RepositoryRegisterUI repositoryRegisterUI = new RepositoryRegisterUI();
            repositoryRegisterUI.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Add_Repo"));
            repositoryRegisterUI.modify(RepositoryNode.this.info);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)repositoryRegisterUI, NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Add_Repo"));
            dialogDescriptor.setClosingOptions(new Object[]{repositoryRegisterUI.getButton(), DialogDescriptor.CANCEL_OPTION});
            dialogDescriptor.setOptions(new Object[]{repositoryRegisterUI.getButton(), DialogDescriptor.CANCEL_OPTION});
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (repositoryRegisterUI.getButton() == object) {
                RepositoryInfo repositoryInfo = repositoryRegisterUI.getRepositoryInfo();
                RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(repositoryInfo);
                RepositoryNode.this.info = repositoryInfo;
                RepositoryNode.this.setDisplayName(repositoryInfo.getName());
                RepositoryNode.this.fireIconChange();
                RepositoryNode.this.fireOpenedIconChange();
                ((GroupListChildren)RepositoryNode.this.getChildren()).refreshGroups();
            }
        }
    }

    public class RefreshIndexAction
    extends AbstractAction {
        public RefreshIndexAction() {
            this.putValue("Name", NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_Update_Index"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    RepositoryIndexer.indexRepo((RepositoryInfo)RepositoryNode.this.info);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            RefreshIndexAction.this.setEnabled(true);
                        }
                    });
                }
            });
        }
    }
}

