/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.hyperlink;

import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.IssueFinderUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorHyperlinkProviderImpl
implements HyperlinkProviderExt,
LookupListener {
    private static Logger LOG = Logger.getLogger(EditorHyperlinkProviderImpl.class.getName());
    private final Lookup.Result<IssueFinder> lookupResult = Lookup.getDefault().lookupResult(IssueFinder.class);
    private IssueFinder[] issueFinders;

    public EditorHyperlinkProviderImpl() {
        this.lookupResult.addLookupListener((LookupListener)this);
        this.refreshIssueFinders();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refreshIssueFinders();
    }

    private void refreshIssueFinders() {
        Collection collection = this.lookupResult.allInstances();
        IssueFinder[] issueFinderArray = new IssueFinder[collection.size()];
        collection.toArray(issueFinderArray);
        this.issueFinders = issueFinderArray;
    }

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document document, int n, HyperlinkType hyperlinkType) {
        return this.getIssueSpan(document, n, hyperlinkType) != null;
    }

    public int[] getHyperlinkSpan(Document document, int n, HyperlinkType hyperlinkType) {
        int[] nArray;
        IssueFinderUtils.HyperlinkSpanInfo hyperlinkSpanInfo = this.getIssueSpan(document, n, hyperlinkType);
        if (hyperlinkSpanInfo != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = hyperlinkSpanInfo.startOffset;
            nArray = nArray2;
            nArray2[1] = hyperlinkSpanInfo.endOffset;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public void performClickAction(final Document document, int n, HyperlinkType hyperlinkType) {
        final String string = this.getIssueId(document, n, hyperlinkType);
        if (string == null) {
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class IssueDisplayer
        implements Runnable {
            IssueDisplayer() {
            }

            @Override
            public void run() {
                FileObject fileObject;
                DataObject dataObject = (DataObject)document.getProperty("stream");
                File file = null;
                if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null) {
                    file = FileUtil.toFile((FileObject)fileObject);
                }
                if (file == null) {
                    return;
                }
                fileObject = BugtrackingOwnerSupport.getInstance().getRepository(file, string, true);
                if (fileObject == null) {
                    return;
                }
                BugtrackingOwnerSupport.getInstance().setFirmAssociation(file, (Repository)fileObject);
                Issue.open((Repository)fileObject, (String)string);
            }
        }
        RequestProcessor.getDefault().post((Runnable)new IssueDisplayer());
    }

    public String getTooltipText(Document document, int n, HyperlinkType hyperlinkType) {
        return NbBundle.getMessage(EditorHyperlinkProviderImpl.class, (String)"LBL_OpenIssue", (Object[])new Object[]{this.getIssueId(document, n, hyperlinkType)});
    }

    private String getIssueId(Document document, int n, HyperlinkType hyperlinkType) {
        IssueFinderUtils.HyperlinkSpanInfo hyperlinkSpanInfo = this.getIssueSpan(document, n, hyperlinkType);
        if (hyperlinkSpanInfo == null) {
            return null;
        }
        String string = null;
        try {
            int n2;
            String string2;
            int[] nArray;
            if (hyperlinkSpanInfo.startOffset <= n && n <= hyperlinkSpanInfo.endOffset && (nArray = hyperlinkSpanInfo.issueFinder.getIssueSpans((CharSequence)(string2 = document.getText(hyperlinkSpanInfo.startOffset, n2 = hyperlinkSpanInfo.endOffset - hyperlinkSpanInfo.startOffset)))).length == 2) {
                string = hyperlinkSpanInfo.issueFinder.getIssueId(string2);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.SEVERE, null, badLocationException);
        }
        return string;
    }

    private IssueFinderUtils.HyperlinkSpanInfo getIssueSpan(Document document, int n, HyperlinkType hyperlinkType) {
        if (this.issueFinders.length == 0) {
            return null;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        List list = tokenHierarchy.embeddedTokenSequences(n, false);
        for (TokenSequence tokenSequence : list) {
            String string;
            String string2;
            if (tokenSequence == null) {
                return null;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return null;
            }
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId == null || (string2 = tokenId.primaryCategory()) == null || (string = tokenId.name()) == null || string2.toUpperCase().indexOf("COMMENT") <= -1 && string.toUpperCase().indexOf("COMMENT") <= -1) continue;
            CharSequence charSequence = token.text();
            for (IssueFinder issueFinder : this.issueFinders) {
                int[] nArray = issueFinder.getIssueSpans(charSequence);
                for (int i = 1; i < nArray.length; i += 2) {
                    if (tokenSequence.offset() + nArray[i - 1] > n || n > tokenSequence.offset() + nArray[i]) continue;
                    return new IssueFinderUtils.HyperlinkSpanInfo(issueFinder, tokenSequence.offset() + nArray[i - 1], tokenSequence.offset() + nArray[i]);
                }
            }
        }
        return null;
    }
}

