/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;

public class SimpleValue
implements KeyValue {
    private final List columns = new ArrayList();
    private String typeName;
    private Properties identifierGeneratorProperties;
    private String identifierGeneratorStrategy = "assigned";
    private String nullValue;
    private Table table;
    private String foreignKeyName;
    private boolean alternateUniqueKey;
    private Properties typeParameters;
    private boolean cascadeDeleteEnabled;

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public void setCascadeDeleteEnabled(boolean cascadeDeleteEnabled) {
        this.cascadeDeleteEnabled = cascadeDeleteEnabled;
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
        column.setValue(this);
        column.setTypeIndex(this.columns.size() - 1);
    }

    public void addFormula(Formula formula) {
        this.columns.add(formula);
    }

    public boolean hasFormula() {
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Formula)) continue;
            return true;
        }
        return false;
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public List getConstraintColumns() {
        return this.columns;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String type) {
        this.typeName = type;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public SimpleValue(Table table) {
        this.table = table;
    }

    public SimpleValue() {
    }

    public void createForeignKey() throws MappingException {
    }

    public void createForeignKeyOfEntity(String entityName) {
        if (!this.hasFormula() && !"none".equals(this.getForeignKeyName())) {
            ForeignKey fk = this.table.createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), entityName);
            fk.setCascadeDeleteEnabled(this.cascadeDeleteEnabled);
        }
    }

    public IdentifierGenerator createIdentifierGenerator(Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) throws MappingException {
        Properties params = new Properties();
        if (defaultSchema != null) {
            params.setProperty("schema", defaultSchema);
        }
        if (defaultCatalog != null) {
            params.setProperty("catalog", defaultCatalog);
        }
        if (rootClass != null) {
            params.setProperty("entity_name", rootClass.getEntityName());
        }
        String tableName = this.getTable().getQuotedName(dialect);
        params.setProperty("target_table", tableName);
        String columnName = ((Column)this.getColumnIterator().next()).getQuotedName(dialect);
        params.setProperty("target_column", columnName);
        if (rootClass != null) {
            StringBuffer tables = new StringBuffer();
            Iterator iter = rootClass.getIdentityTables().iterator();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                tables.append(table.getQuotedName(dialect));
                if (!iter.hasNext()) continue;
                tables.append(", ");
            }
            params.setProperty("identity_tables", tables.toString());
        } else {
            params.setProperty("identity_tables", tableName);
        }
        if (this.identifierGeneratorProperties != null) {
            params.putAll((Map<?, ?>)this.identifierGeneratorProperties);
        }
        return IdentifierGeneratorFactory.create(this.identifierGeneratorStrategy, this.getType(), params, dialect);
    }

    public boolean isUpdateable() {
        return true;
    }

    public FetchMode getFetchMode() {
        return FetchMode.SELECT;
    }

    public Properties getIdentifierGeneratorProperties() {
        return this.identifierGeneratorProperties;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public Table getTable() {
        return this.table;
    }

    public String getIdentifierGeneratorStrategy() {
        return this.identifierGeneratorStrategy;
    }

    public boolean isIdentityColumn(Dialect dialect) {
        return IdentifierGeneratorFactory.getIdentifierGeneratorClass(this.identifierGeneratorStrategy, dialect).equals(IdentityGenerator.class);
    }

    public void setIdentifierGeneratorProperties(Properties identifierGeneratorProperties) {
        this.identifierGeneratorProperties = identifierGeneratorProperties;
    }

    public void setIdentifierGeneratorStrategy(String identifierGeneratorStrategy) {
        this.identifierGeneratorStrategy = identifierGeneratorStrategy;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public boolean isAlternateUniqueKey() {
        return this.alternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean unique) {
        this.alternateUniqueKey = unique;
    }

    public boolean isNullable() {
        if (this.hasFormula()) {
            return true;
        }
        boolean nullable = true;
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            if (((Column)iter.next()).isNullable()) continue;
            nullable = false;
            return nullable;
        }
        return nullable;
    }

    public boolean isSimpleValue() {
        return true;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        return this.getColumnSpan() == this.getType().getColumnSpan(mapping);
    }

    public Type getType() throws MappingException {
        if (this.typeName == null) {
            throw new MappingException("No type name");
        }
        Type result = TypeFactory.heuristicType(this.typeName, this.typeParameters);
        if (result == null) {
            String msg = "Could not determine type for: " + this.typeName;
            if (this.columns != null && this.columns.size() > 0) {
                msg = msg + ", for columns: " + this.columns;
            }
            throw new MappingException(msg);
        }
        return result;
    }

    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.typeName == null) {
            if (className == null) {
                throw new MappingException("you must specify types for a dynamic entity: " + propertyName);
            }
            this.typeName = ReflectHelper.reflectedPropertyClass(className, propertyName).getName();
        }
    }

    public boolean isTypeSpecified() {
        return this.typeName != null;
    }

    public void setTypeParameters(Properties parameterMap) {
        this.typeParameters = parameterMap;
    }

    public Properties getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.columns.toString() + ')';
    }

    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean[] getColumnInsertability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        int i = 0;
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            Selectable s = (Selectable)iter.next();
            result[i++] = !s.isFormula();
        }
        return result;
    }

    public boolean[] getColumnUpdateability() {
        return this.getColumnInsertability();
    }
}

